/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class RowBuffer {
    @JsonIgnore
    public static final String XML_TAG = "row-buffer";
    private IRowMeta rowMeta;
    private List<Object[]> buffer;

    public RowBuffer() {
        this.rowMeta = new RowMeta();
        this.buffer = Collections.synchronizedList(new ArrayList());
    }

    public RowBuffer(IRowMeta rowMeta, List<Object[]> buffer) {
        this.rowMeta = rowMeta;
        this.buffer = buffer;
    }

    public RowBuffer(IRowMeta rowMeta) {
        this(rowMeta, Collections.synchronizedList(new ArrayList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowBuffer that = (RowBuffer)o;
        if (!this.rowMeta.equals(that.rowMeta)) {
            return false;
        }
        if (this.buffer.size() != that.buffer.size()) {
            return false;
        }
        for (int i = 0; i < this.buffer.size(); ++i) {
            Object[] thisRow = this.buffer.get(i);
            Object[] thatRow = that.buffer.get(i);
            for (int v = 0; v < this.rowMeta.size(); ++v) {
                IValueMeta valueMeta = this.rowMeta.getValueMeta(v);
                try {
                    if (valueMeta.compare(thisRow[v], thatRow[v]) == 0) continue;
                    return false;
                }
                catch (HopValueException e) {
                    throw new RuntimeException("Error comparing 2 values in a row buffer row: " + valueMeta.getName(), e);
                }
            }
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.rowMeta, this.buffer);
    }

    public String toString() {
        if (this.rowMeta == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(this.rowMeta.toStringMeta());
        str.append("\n");
        for (Object[] row : this.buffer) {
            try {
                str.append("  ").append(this.rowMeta.getString(row)).append("\n");
            }
            catch (HopException e) {
                str.append("  conversion error on row-to-string: ").append(e.getMessage()).append("\n");
            }
        }
        return str.toString();
    }

    @JsonIgnore
    public String getXml() throws IOException {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag(XML_TAG));
        xml.append(this.rowMeta.getMetaXml());
        for (Object[] row : this.buffer) {
            xml.append(this.rowMeta.getDataXml(row));
        }
        xml.append(XmlHandler.closeTag(XML_TAG));
        return xml.toString();
    }

    public RowBuffer(Node node) throws HopException {
        this();
        Node rowMetaNode = XmlHandler.getSubNode(node, "row-meta");
        this.rowMeta = new RowMeta(rowMetaNode);
        List<Node> dataNodes = XmlHandler.getNodes(node, "row-data");
        for (Node dataNode : dataNodes) {
            this.buffer.add(this.rowMeta.getRow(dataNode));
        }
    }

    public int size() {
        return this.buffer.size();
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public void addRow(Object ... row) {
        this.buffer.add(row);
    }

    public void addRow(int index, Object[] row) {
        this.buffer.add(index, row);
    }

    public Object[] removeRow(int index) {
        return this.buffer.remove(index);
    }

    public void setRow(int index, Object[] row) {
        this.buffer.set(index, row);
    }

    public IRowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(IRowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public List<Object[]> getBuffer() {
        return this.buffer;
    }

    public void setBuffer(List<Object[]> buffer) {
        this.buffer = buffer;
    }
}

