/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonQualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

final class Util {
    public static final Set<Annotation> NO_ANNOTATIONS = Collections.emptySet();

    Util() {
    }

    public static boolean typesMatch(Type pattern, Type candidate) {
        return pattern.equals(candidate);
    }

    public static Set<? extends Annotation> jsonAnnotations(AnnotatedElement annotatedElement) {
        return Util.jsonAnnotations(annotatedElement.getAnnotations());
    }

    public static Set<? extends Annotation> jsonAnnotations(Annotation[] annotations) {
        LinkedHashSet<Annotation> result = null;
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(JsonQualifier.class)) continue;
            if (result == null) {
                result = new LinkedHashSet<Annotation>();
            }
            result.add(annotation);
        }
        return result != null ? Collections.unmodifiableSet(result) : NO_ANNOTATIONS;
    }

    public static boolean isAnnotationPresent(Set<? extends Annotation> annotations, Class<? extends Annotation> annotationClass) {
        if (annotations.isEmpty()) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != annotationClass) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNullable(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getSimpleName().equals("Nullable")) continue;
            return true;
        }
        return false;
    }
}

