/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class RestoreError {
    public static final RestoreError INVALID_REVISION = new RestoreError().withTag(Tag.INVALID_REVISION);
    public static final RestoreError IN_PROGRESS = new RestoreError().withTag(Tag.IN_PROGRESS);
    public static final RestoreError OTHER = new RestoreError().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError pathLookupValue;
    private WriteError pathWriteValue;

    private RestoreError() {
    }

    private RestoreError withTag(Tag _tag) {
        RestoreError result = new RestoreError();
        result._tag = _tag;
        return result;
    }

    private RestoreError withTagAndPathLookup(Tag _tag, LookupError pathLookupValue) {
        RestoreError result = new RestoreError();
        result._tag = _tag;
        result.pathLookupValue = pathLookupValue;
        return result;
    }

    private RestoreError withTagAndPathWrite(Tag _tag, WriteError pathWriteValue) {
        RestoreError result = new RestoreError();
        result._tag = _tag;
        result.pathWriteValue = pathWriteValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPathLookup() {
        return this._tag == Tag.PATH_LOOKUP;
    }

    public static RestoreError pathLookup(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RestoreError().withTagAndPathLookup(Tag.PATH_LOOKUP, value);
    }

    public LookupError getPathLookupValue() {
        if (this._tag != Tag.PATH_LOOKUP) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH_LOOKUP, but was Tag." + this._tag.name());
        }
        return this.pathLookupValue;
    }

    public boolean isPathWrite() {
        return this._tag == Tag.PATH_WRITE;
    }

    public static RestoreError pathWrite(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RestoreError().withTagAndPathWrite(Tag.PATH_WRITE, value);
    }

    public WriteError getPathWriteValue() {
        if (this._tag != Tag.PATH_WRITE) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH_WRITE, but was Tag." + this._tag.name());
        }
        return this.pathWriteValue;
    }

    public boolean isInvalidRevision() {
        return this._tag == Tag.INVALID_REVISION;
    }

    public boolean isInProgress() {
        return this._tag == Tag.IN_PROGRESS;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathLookupValue, this.pathWriteValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RestoreError) {
            RestoreError other = (RestoreError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH_LOOKUP: {
                    return this.pathLookupValue == other.pathLookupValue || this.pathLookupValue.equals(other.pathLookupValue);
                }
                case PATH_WRITE: {
                    return this.pathWriteValue == other.pathWriteValue || this.pathWriteValue.equals(other.pathWriteValue);
                }
                case INVALID_REVISION: {
                    return true;
                }
                case IN_PROGRESS: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<RestoreError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RestoreError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH_LOOKUP: {
                    g.writeStartObject();
                    this.writeTag("path_lookup", g);
                    g.writeFieldName("path_lookup");
                    LookupError.Serializer.INSTANCE.serialize(value.pathLookupValue, g);
                    g.writeEndObject();
                    break;
                }
                case PATH_WRITE: {
                    g.writeStartObject();
                    this.writeTag("path_write", g);
                    g.writeFieldName("path_write");
                    WriteError.Serializer.INSTANCE.serialize(value.pathWriteValue, g);
                    g.writeEndObject();
                    break;
                }
                case INVALID_REVISION: {
                    g.writeString("invalid_revision");
                    break;
                }
                case IN_PROGRESS: {
                    g.writeString("in_progress");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public RestoreError deserialize(JsonParser p) throws IOException, JsonParseException {
            RestoreError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path_lookup".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path_lookup", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = RestoreError.pathLookup(fieldValue);
            } else if ("path_write".equals(tag)) {
                WriteError fieldValue = null;
                Serializer.expectField("path_write", p);
                fieldValue = WriteError.Serializer.INSTANCE.deserialize(p);
                value = RestoreError.pathWrite(fieldValue);
            } else {
                value = "invalid_revision".equals(tag) ? INVALID_REVISION : ("in_progress".equals(tag) ? IN_PROGRESS : OTHER);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH_LOOKUP,
        PATH_WRITE,
        INVALID_REVISION,
        IN_PROGRESS,
        OTHER;

    }
}

