/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.w3c.dom.Node;

public class SslConfiguration {
    private static final Class<?> PKG = SslConfiguration.class;
    public static final String XML_TAG = "sslConfig";
    private static final String XML_TAG_KEY_STORE = "keyStore";
    private static final String XML_TAG_KEY_STORE_TYPE = "keyStoreType";
    private static final String XML_TAG_KEY_PASSWORD = "keyPassword";
    private static final String XML_TAG_KEY_STORE_PASSWORD = "keyStorePassword";
    private static final String EMPTY = "empty";
    private static final String NULL = "null";
    private static final String CONST_ILLEGAL_PARAMETER = "WebServer.Error.IllegalSslParameter";
    @HopMetadataProperty
    private String keyStoreType = "JKS";
    @HopMetadataProperty
    private String keyStore;
    @HopMetadataProperty(password=true)
    private String keyStorePassword;
    @HopMetadataProperty(password=true)
    private String keyPassword;

    public SslConfiguration() {
    }

    public SslConfiguration(Node sslConfigNode) {
        this.setKeyStore(XmlHandler.getTagValue((Node)sslConfigNode, (String)XML_TAG_KEY_STORE));
        this.setKeyStorePassword(Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)sslConfigNode, (String)XML_TAG_KEY_STORE_PASSWORD)));
        this.setKeyPassword(Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)sslConfigNode, (String)XML_TAG_KEY_PASSWORD)));
        this.setKeyStoreType(XmlHandler.getTagValue((Node)sslConfigNode, (String)XML_TAG_KEY_STORE_TYPE));
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        if (keyStoreType != null) {
            this.keyStoreType = keyStoreType;
        }
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        Validate.notNull((Object)keyStore, (String)BaseMessages.getString(PKG, (String)CONST_ILLEGAL_PARAMETER, (String[])new String[]{XML_TAG_KEY_STORE, NULL}));
        Validate.notEmpty((String)keyStore, (String)BaseMessages.getString(PKG, (String)CONST_ILLEGAL_PARAMETER, (String[])new String[]{XML_TAG_KEY_STORE, EMPTY}));
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        Validate.notNull((Object)keyStorePassword, (String)BaseMessages.getString(PKG, (String)CONST_ILLEGAL_PARAMETER, (String[])new String[]{XML_TAG_KEY_STORE_PASSWORD, NULL}));
        Validate.notEmpty((String)keyStorePassword, (String)BaseMessages.getString(PKG, (String)CONST_ILLEGAL_PARAMETER, (String[])new String[]{XML_TAG_KEY_STORE_PASSWORD, EMPTY}));
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword != null ? this.keyPassword : this.getKeyStorePassword();
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("        ").append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        SslConfiguration.addXmlValue(xml, XML_TAG_KEY_STORE, this.keyStore);
        SslConfiguration.addXmlValue(xml, XML_TAG_KEY_STORE_PASSWORD, SslConfiguration.encrypt(this.keyStorePassword));
        SslConfiguration.addXmlValue(xml, XML_TAG_KEY_PASSWORD, SslConfiguration.encrypt(this.keyPassword));
        xml.append("        ").append(XmlHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    private static void addXmlValue(StringBuilder xml, String key, String value) {
        if (!StringUtils.isBlank((String)value)) {
            xml.append("          ").append(XmlHandler.addTagValue((String)key, (String)value, (boolean)false, (String[])new String[0]));
        }
    }

    private static String encrypt(String value) {
        if (!StringUtils.isBlank((String)value)) {
            return Encr.encryptPasswordIfNotUsingVariables((String)value);
        }
        return null;
    }
}

