/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.UpdatableSummary;

public class IntegerSummary
implements UpdatableSummary<Integer> {
    private int value_;
    private final Mode mode_;
    private static final int SERIALIZED_SIZE_BYTES = 5;
    private static final int VALUE_INDEX = 0;
    private static final int MODE_BYTE_INDEX = 4;

    private IntegerSummary(int value, Mode mode) {
        this.value_ = value;
        this.mode_ = mode;
    }

    public IntegerSummary(Mode mode) {
        this.mode_ = mode;
        switch (mode.ordinal()) {
            case 0: {
                this.value_ = 0;
                break;
            }
            case 1: {
                this.value_ = Integer.MAX_VALUE;
                break;
            }
            case 2: {
                this.value_ = Integer.MIN_VALUE;
                break;
            }
            case 3: {
                this.value_ = 1;
            }
        }
    }

    public IntegerSummary update(Integer value) {
        switch (this.mode_.ordinal()) {
            case 0: {
                this.value_ += value.intValue();
                break;
            }
            case 1: {
                if (value >= this.value_) break;
                this.value_ = value;
                break;
            }
            case 2: {
                if (value <= this.value_) break;
                this.value_ = value;
                break;
            }
            case 3: {
                this.value_ = 1;
            }
        }
        return this;
    }

    @Override
    public IntegerSummary copy() {
        return new IntegerSummary(this.value_, this.mode_);
    }

    public int getValue() {
        return this.value_;
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[5];
        ByteArrayUtil.putIntLE(bytes, 0, this.value_);
        bytes[4] = (byte)this.mode_.ordinal();
        return bytes;
    }

    public static DeserializeResult<IntegerSummary> fromMemorySegment(MemorySegment seg) {
        return new DeserializeResult<IntegerSummary>(new IntegerSummary(seg.get(ValueLayout.JAVA_INT_UNALIGNED, 0L), Mode.values()[seg.get(ValueLayout.JAVA_BYTE, 4L)]), 5);
    }

    public static enum Mode {
        Sum,
        Min,
        Max,
        AlwaysOne;

    }
}

