/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigDecimal;
import org.apache.daffodil.lib.calendar.DFDLDateTime;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.FNFromDateTime;
import org.apache.daffodil.runtime1.dpath.FNSecondsFromDateTime$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class FNSecondsFromDateTime
extends FNFromDateTime
implements Product {
    private final CompiledDPath recipe;
    private final NodeInfo.Kind argType;
    private final String fieldName;
    private final int field;

    public static FNSecondsFromDateTime apply(CompiledDPath compiledDPath, NodeInfo.Kind kind) {
        return FNSecondsFromDateTime$.MODULE$.apply(compiledDPath, kind);
    }

    public static FNSecondsFromDateTime fromProduct(Product product) {
        return FNSecondsFromDateTime$.MODULE$.fromProduct(product);
    }

    public static FNSecondsFromDateTime unapply(FNSecondsFromDateTime fNSecondsFromDateTime) {
        return FNSecondsFromDateTime$.MODULE$.unapply(fNSecondsFromDateTime);
    }

    public FNSecondsFromDateTime(CompiledDPath recipe, NodeInfo.Kind argType) {
        this.recipe = recipe;
        this.argType = argType;
        super(recipe, argType);
        this.fieldName = "seconds";
        this.field = 13;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FNSecondsFromDateTime)) return false;
        FNSecondsFromDateTime fNSecondsFromDateTime = (FNSecondsFromDateTime)object;
        CompiledDPath compiledDPath = this.recipe();
        CompiledDPath compiledDPath2 = fNSecondsFromDateTime.recipe();
        if (compiledDPath == null) {
            if (compiledDPath2 != null) {
                return false;
            }
        } else if (!compiledDPath.equals(compiledDPath2)) return false;
        NodeInfo.Kind kind = this.argType();
        NodeInfo.Kind kind2 = fNSecondsFromDateTime.argType();
        if (kind == null) {
            if (kind2 != null) {
                return false;
            }
        } else if (!kind.equals(kind2)) return false;
        if (!fNSecondsFromDateTime.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FNSecondsFromDateTime;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "FNSecondsFromDateTime";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "recipe";
        }
        if (1 == n2) {
            return "argType";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CompiledDPath recipe() {
        return this.recipe;
    }

    public NodeInfo.Kind argType() {
        return this.argType;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public int field() {
        return this.field;
    }

    @Override
    public BigDecimal computeValue(Object a, DState dstate) {
        Number number;
        Object object = DataValue$.MODULE$.getAnyRef$extension(a);
        if (object instanceof DFDLDateTime) {
            DFDLDateTime dt = (DFDLDateTime)object;
            int seconds = dt.calendar().get(13);
            int frac = dt.calendar().get(14);
            if (frac == 0) {
                number = Predef$.MODULE$.int2Integer(seconds);
            } else {
                double d = (double)seconds + (double)frac / 1000.0;
                number = Predef$.MODULE$.double2Double(d);
            }
        } else {
            throw new NumberFormatException("fn:" + this.fieldName() + "-from-dateTime only accepts xs:dateTime.");
        }
        Number res = number;
        return DataValue$.MODULE$.toDataValue(Numbers$.MODULE$.asBigDecimal(res));
    }

    public FNSecondsFromDateTime copy(CompiledDPath recipe, NodeInfo.Kind argType) {
        return new FNSecondsFromDateTime(recipe, argType);
    }

    public CompiledDPath copy$default$1() {
        return this.recipe();
    }

    public NodeInfo.Kind copy$default$2() {
        return this.argType();
    }

    public CompiledDPath _1() {
        return this.recipe();
    }

    public NodeInfo.Kind _2() {
        return this.argType();
    }
}

