/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Bits;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.RspList;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class MPerfRpc
implements Receiver {
    protected String props;
    protected JChannel channel;
    protected RpcDispatcher disp;
    protected Address local_addr;
    protected String name;
    protected int num_msgs = 1000000;
    protected int msg_size = 1000;
    protected int num_threads = 25;
    protected int log_interval = this.num_msgs / 10;
    protected int receive_log_interval = this.num_msgs / 10;
    protected int num_senders = -1;
    protected boolean sync = true;
    protected boolean oob = false;
    protected final ConcurrentMap<Address, Stats> received_msgs = Util.createConcurrentMap();
    protected final AtomicLong total_received_msgs = new AtomicLong(0L);
    protected final List<Address> members = new CopyOnWriteArrayList<Address>();
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean looping = true;
    protected long last_interval = 0L;
    protected final ResponseCollector<Result> results = new ResponseCollector();
    protected volatile Address result_collector = null;
    protected volatile boolean initiator = false;
    protected RequestOptions send_options = RequestOptions.ASYNC();
    protected static final NumberFormat format = NumberFormat.getNumberInstance();
    protected static final short handleData = 0;
    protected static final short startSending = 1;
    protected static final short sendingDone = 2;
    protected static final short result = 3;
    protected static final short clearResults = 4;
    protected static final short configChange = 5;
    protected static final short configReq = 6;
    protected static final short configRsp = 7;
    protected static final short exit = 8;
    protected static final Method[] METHODS = new Method[9];

    public void start(String props, String name) throws Exception {
        this.props = props;
        this.name = name;
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n----------------------- MPerf -----------------------\n");
        sb.append("Date: ").append(new Date()).append('\n');
        sb.append("Run by: ").append(System.getProperty("user.name")).append("\n");
        sb.append("JGroups version: ").append(Version.description).append('\n');
        System.out.println(sb);
        this.channel = new JChannel(props);
        this.channel.setName(name);
        this.disp = new RpcDispatcher(this.channel, this).setReceiver(this).setMethodLookup(id -> METHODS[id]);
        this.send_options.mode(this.sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE);
        if (this.oob) {
            this.send_options.flags(Message.Flag.OOB);
        }
        this.channel.connect("mperf");
        this.local_addr = this.channel.getAddress();
        JmxConfigurator.registerChannel(this.channel, Util.getMBeanServer(), "jgroups", "mperf", true);
        Address coord = this.channel.getView().getCoord();
        if (coord != null && !this.local_addr.equals(coord)) {
            this.invokeRpc((short)6, coord, RequestOptions.ASYNC().flags(Message.Flag.RSVP), this.local_addr);
        }
    }

    protected void loop() {
        String INPUT = "[1] Invoke [2] View\n[3] Set num RPCs (%d) [4] Set msg size (%s) [5] Set threads (%d)\n[6] Number of senders (%s) [s] Toggle sync (%s) [o] Toggle OOB (%s)\n[x] Exit this [X] Exit all";
        while (this.looping) {
            try {
                int c = Util.keyPress(String.format("[1] Invoke [2] View\n[3] Set num RPCs (%d) [4] Set msg size (%s) [5] Set threads (%d)\n[6] Number of senders (%s) [s] Toggle sync (%s) [o] Toggle OOB (%s)\n[x] Exit this [X] Exit all", this.num_msgs, Util.printBytes(this.msg_size), this.num_threads, this.num_senders <= 0 ? "all" : String.valueOf(this.num_senders), this.sync, this.oob));
                switch (c) {
                    case 49: {
                        this.initiator = true;
                        this.results.reset(this.getSenders());
                        this.invokeRpc((short)4, RequestOptions.SYNC().flags(Message.Flag.RSVP), new Object[0]);
                        this.invokeRpc((short)1, RequestOptions.ASYNC(), this.local_addr);
                        break;
                    }
                    case 50: {
                        System.out.println("view: " + this.channel.getView() + " (local address=" + this.channel.getAddress() + ")");
                        break;
                    }
                    case 51: {
                        this.configChange("num_msgs");
                        break;
                    }
                    case 52: {
                        this.configChange("msg_size");
                        break;
                    }
                    case 53: {
                        this.configChange("num_threads");
                        break;
                    }
                    case 54: {
                        this.configChange("num_senders");
                        break;
                    }
                    case 115: {
                        ConfigChange change = new ConfigChange("sync", !this.sync);
                        this.invokeRpc((short)5, RequestOptions.SYNC().flags(Message.Flag.RSVP), change);
                        break;
                    }
                    case 111: {
                        ConfigChange change = new ConfigChange("oob", !this.oob);
                        this.invokeRpc((short)5, RequestOptions.SYNC().flags(Message.Flag.RSVP), change);
                        break;
                    }
                    case -1: 
                    case 120: {
                        this.looping = false;
                        break;
                    }
                    case 88: {
                        this.invokeRpc((short)8, RequestOptions.ASYNC(), new Object[0]);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.stop();
    }

    protected void displayResults() {
        System.out.println("\nResults:\n");
        Map<Address, Result> tmp_results = this.results.getResults();
        for (Map.Entry<Address, Result> entry : tmp_results.entrySet()) {
            Result val = entry.getValue();
            if (val == null) continue;
            System.out.println(entry.getKey() + ": " + MPerfRpc.computeStats(val.time, val.msgs, this.msg_size));
        }
        long total_msgs = 0L;
        long total_time = 0L;
        long num = 0L;
        for (Result res : tmp_results.values()) {
            if (res == null) continue;
            total_time += res.time;
            total_msgs += res.msgs;
            ++num;
        }
        if (num > 0L) {
            System.out.println("\n===============================================================================");
            System.out.println("\u001b[1m Average/node:    " + MPerfRpc.computeStats(total_time / num, total_msgs / num, this.msg_size));
            System.out.println("\u001b[0m Average/cluster: " + MPerfRpc.computeStats(total_time / num, total_msgs, this.msg_size));
            System.out.println("================================================================================\n\n");
        } else {
            System.out.println("\n===============================================================================");
            System.out.println("\u001b[1m Received no results");
            System.out.println("\u001b[0m");
            System.out.println("================================================================================\n\n");
        }
    }

    protected void configChange(String name) throws Exception {
        int tmp = Util.readIntFromStdin(name + ": ");
        ConfigChange change = new ConfigChange(name, tmp);
        this.invokeRpc((short)5, RequestOptions.SYNC().flags(Message.Flag.RSVP), change);
    }

    protected RspList<?> invokeRpc(short method_id, RequestOptions options, Object ... args) throws Exception {
        MethodCall call = new MethodCall(method_id, args);
        return this.disp.callRemoteMethods(null, call, options);
    }

    protected Object invokeRpc(short method_id, Address dest, RequestOptions options, Object ... args) throws Exception {
        MethodCall call = new MethodCall(method_id, args);
        return this.disp.callRemoteMethod(dest, call, options);
    }

    public void stop() {
        this.looping = false;
        try {
            JmxConfigurator.unregisterChannel(this.channel, Util.getMBeanServer(), "jgroups", "mperf");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Util.close((Closeable)this.channel);
    }

    public void handleData(Address src, byte[] payload, long seqno, boolean check_order) {
        long received_so_far;
        Stats tmp;
        int length = payload.length;
        if (length == 0) {
            return;
        }
        Stats tmp_result = (Stats)this.received_msgs.get(src);
        if (tmp_result == null && (tmp = this.received_msgs.putIfAbsent(src, tmp_result = new Stats())) != null) {
            tmp_result = tmp;
        }
        tmp_result.addMessage(seqno, check_order);
        if (this.last_interval == 0L) {
            this.last_interval = System.currentTimeMillis();
        }
        if ((received_so_far = this.total_received_msgs.incrementAndGet()) % (long)this.receive_log_interval == 0L) {
            long curr_time = System.currentTimeMillis();
            long diff = curr_time - this.last_interval;
            double msgs_sec = (double)this.receive_log_interval / ((double)diff / 1000.0);
            double throughput = msgs_sec * (double)this.msg_size;
            this.last_interval = curr_time;
            System.out.println("-- received " + received_so_far + " rpcs (" + diff + " ms, " + format.format(msgs_sec) + " rpcs/sec, " + Util.printBytes(throughput) + "/sec)");
        }
    }

    public void startSending(Address initiator) {
        int my_rank;
        if (this.num_senders > 0 && (my_rank = Util.getRank(this.members, this.local_addr)) >= 0 && my_rank > this.num_senders) {
            return;
        }
        this.result_collector = initiator;
        this.sendMessages();
    }

    public void sendingDone(Address sender) {
        Stats tmp = (Stats)this.received_msgs.get(sender);
        if (tmp != null) {
            tmp.stop();
        }
        boolean all_done = true;
        List<Address> senders = this.getSenders();
        for (Map.Entry entry : this.received_msgs.entrySet()) {
            Address mbr = (Address)entry.getKey();
            Stats tmp_result = (Stats)entry.getValue();
            if (!senders.contains(mbr) || tmp_result.isDone()) continue;
            all_done = false;
            break;
        }
        if (all_done && this.result_collector != null) {
            long start = 0L;
            long stop = 0L;
            long msgs = 0L;
            for (Stats res : this.received_msgs.values()) {
                if (res.start > 0L) {
                    long l = start = start == 0L ? res.start : Math.min(start, res.start);
                }
                if (res.stop > 0L) {
                    stop = stop == 0L ? res.stop : Math.max(stop, res.stop);
                }
                msgs += res.num_msgs_received;
            }
            Result tmp_result = new Result(stop - start, msgs);
            try {
                if (this.result_collector != null) {
                    this.invokeRpc((short)3, this.result_collector, RequestOptions.SYNC().flags(Message.Flag.RSVP), this.local_addr, tmp_result);
                }
            }
            catch (Exception e) {
                System.err.println("failed sending results to " + this.result_collector + ": " + e);
            }
        }
    }

    public void result(Address sender, Result res) {
        this.results.add(sender, res);
        if (this.initiator && this.results.hasAllResponses()) {
            this.initiator = false;
            this.displayResults();
        }
    }

    public void clearResults() {
        this.received_msgs.values().forEach(Stats::reset);
        this.total_received_msgs.set(0L);
        this.last_interval = 0L;
    }

    public void configChange(ConfigChange config_change) {
        String attr_name = config_change.attr_name;
        try {
            Object attr_value = config_change.getValue();
            Field field = Util.getField(this.getClass(), attr_name);
            Util.setField(field, this, attr_value);
            System.out.println(config_change.attr_name + "=" + attr_value);
            this.log_interval = this.num_msgs / 10;
            this.receive_log_interval = this.num_msgs * Math.max(1, this.members.size()) / 10;
            this.send_options.mode(this.sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE);
            if (this.oob) {
                this.send_options.flags(Message.Flag.OOB);
            }
        }
        catch (Exception e) {
            System.err.println("failed applying config change for attr " + attr_name + ": " + e);
        }
    }

    public void configReq(Address sender) throws Exception {
        Configuration cfg = new Configuration();
        cfg.addChange("num_msgs", this.num_msgs);
        cfg.addChange("msg_size", this.msg_size);
        cfg.addChange("num_threads", this.num_threads);
        cfg.addChange("num_senders", this.num_senders);
        cfg.addChange("sync", this.sync);
        cfg.addChange("oob", this.oob);
        this.invokeRpc((short)7, sender, RequestOptions.ASYNC(), cfg);
    }

    public void configRsp(Configuration cfg) {
        cfg.changes.forEach(this::configChange);
    }

    public void exit() {
        ProtocolStack stack = this.channel.getProtocolStack();
        String cluster_name = this.channel.getClusterName();
        try {
            JmxConfigurator.unregisterChannel(this.channel, Util.getMBeanServer(), "jgroups", "mperf");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stack.stopStack(cluster_name);
        stack.destroy();
    }

    protected List<Address> getSenders() {
        if (this.num_senders <= 0) {
            return new ArrayList<Address>(this.members);
        }
        ArrayList<Address> retval = new ArrayList<Address>();
        for (int i = 0; i < this.num_senders; ++i) {
            retval.add(this.members.get(i));
        }
        return retval;
    }

    @Override
    public void viewAccepted(View view) {
        System.out.println("** " + view);
        List<Address> mbrs = view.getMembers();
        this.members.clear();
        this.members.addAll(mbrs);
        this.receive_log_interval = this.num_msgs * mbrs.size() / 10;
        this.received_msgs.keySet().retainAll(mbrs);
        for (Address member : mbrs) {
            this.received_msgs.putIfAbsent(member, new Stats());
        }
        this.results.retainAll(mbrs);
        if (this.result_collector != null && !mbrs.contains(this.result_collector)) {
            this.result_collector = null;
        }
    }

    protected void sendMessages() {
        AtomicInteger num_msgs_sent = new AtomicInteger(0);
        AtomicLong seqno = new AtomicLong(1L);
        Sender[] senders = new Sender[this.num_threads];
        CyclicBarrier barrier = new CyclicBarrier(this.num_threads + 1);
        byte[] payload = new byte[this.msg_size];
        for (int i = 0; i < this.num_threads; ++i) {
            senders[i] = new Sender(barrier, num_msgs_sent, seqno, payload);
            senders[i].setName("invoker-" + i);
            senders[i].start();
        }
        try {
            System.out.println("-- invoking " + this.num_msgs + " msgs");
            barrier.await();
        }
        catch (Exception e) {
            System.err.println("failed triggering send threads: " + e);
        }
    }

    protected static String computeStats(long time, long msgs, int size) {
        StringBuilder sb = new StringBuilder();
        double throughput = 0.0;
        double msgs_sec = (double)msgs / ((double)time / 1000.0);
        throughput = (double)(msgs * (long)size) / ((double)time / 1000.0);
        sb.append(msgs).append(" msgs, ");
        sb.append(Util.printBytes(msgs * (long)size)).append(" received");
        sb.append(", time=").append(format.format(time)).append("ms");
        sb.append(", rpcs/sec=").append(format.format(msgs_sec));
        sb.append(", throughput=").append(Util.printBytes(throughput));
        return sb.toString();
    }

    public static void main(String[] args) {
        String props = null;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            System.out.println("MPerf [-props <stack config>] [-name <logical name>]");
            return;
        }
        final MPerfRpc test = new MPerfRpc();
        try {
            test.start(props, name);
            Thread thread = new Thread("MPerf runner"){

                @Override
                public void run() {
                    test.loop();
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(2);
        try {
            MPerfRpc.METHODS[0] = MPerfRpc.class.getMethod("handleData", Address.class, byte[].class, Long.TYPE, Boolean.TYPE);
            MPerfRpc.METHODS[1] = MPerfRpc.class.getMethod("startSending", Address.class);
            MPerfRpc.METHODS[2] = MPerfRpc.class.getMethod("sendingDone", Address.class);
            MPerfRpc.METHODS[3] = MPerfRpc.class.getMethod("result", Address.class, Result.class);
            MPerfRpc.METHODS[4] = MPerfRpc.class.getMethod("clearResults", new Class[0]);
            MPerfRpc.METHODS[5] = MPerfRpc.class.getMethod("configChange", ConfigChange.class);
            MPerfRpc.METHODS[6] = MPerfRpc.class.getMethod("configReq", Address.class);
            MPerfRpc.METHODS[7] = MPerfRpc.class.getMethod("configRsp", Configuration.class);
            MPerfRpc.METHODS[8] = MPerfRpc.class.getMethod("exit", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class Result
    implements Streamable {
        protected long time = 0L;
        protected long msgs = 0L;

        public Result() {
        }

        public Result(long time, long msgs) {
            this.time = time;
            this.msgs = msgs;
        }

        public int size() {
            return Bits.size(this.time) + Bits.size(this.msgs);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeLongCompressed(this.time, out);
            Bits.writeLongCompressed(this.msgs, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.time = Bits.readLongCompressed(in);
            this.msgs = Bits.readLongCompressed(in);
        }

        public String toString() {
            return this.msgs + " in " + this.time + " ms";
        }
    }

    protected class Stats {
        protected long start = 0L;
        protected long stop = 0L;
        protected long num_msgs_received = 0L;
        protected long seqno = 1L;

        protected Stats() {
        }

        public void reset() {
            this.num_msgs_received = 0L;
            this.stop = 0L;
            this.start = 0L;
            this.seqno = 1L;
        }

        public void stop() {
            this.stop = System.currentTimeMillis();
        }

        public boolean isDone() {
            return this.stop > 0L;
        }

        public void addMessage(long seqno, boolean check_order) {
            if (this.start == 0L) {
                this.start = System.currentTimeMillis();
            }
            if (seqno != this.seqno && check_order) {
                throw new IllegalStateException("expected seqno=" + this.seqno + ", but received " + seqno);
            }
            ++this.seqno;
            ++this.num_msgs_received;
        }

        public String toString() {
            return MPerfRpc.computeStats(this.stop - this.start, this.num_msgs_received, MPerfRpc.this.msg_size);
        }
    }

    protected static class Configuration
    implements Streamable {
        protected List<ConfigChange> changes = new ArrayList<ConfigChange>();

        public Configuration addChange(String key, Object val) throws Exception {
            if (key != null && val != null) {
                this.changes.add(new ConfigChange(key, val));
            }
            return this;
        }

        public int size() {
            int retval = 4;
            for (ConfigChange change : this.changes) {
                retval += change.size();
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeInt(this.changes.size());
            for (ConfigChange change : this.changes) {
                change.writeTo(out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            for (int i = 0; i < len; ++i) {
                ConfigChange change = new ConfigChange();
                change.readFrom(in);
                this.changes.add(change);
            }
        }
    }

    protected static class ConfigChange
    implements Streamable {
        protected String attr_name;
        protected byte[] attr_value;

        public ConfigChange() {
        }

        public ConfigChange(String attr_name, Object val) throws Exception {
            this.attr_name = attr_name;
            this.attr_value = Util.objectToByteBuffer(val);
        }

        public Object getValue() throws Exception {
            return Util.objectFromByteBuffer(this.attr_value);
        }

        public int size() {
            return Util.size(this.attr_name) + Util.size(this.attr_value);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeString(this.attr_name, out);
            Util.writeByteBuffer(this.attr_value, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.attr_name = Bits.readString(in);
            this.attr_value = Util.readByteBuffer(in);
        }
    }

    protected class Sender
    extends Thread {
        protected final CyclicBarrier barrier;
        protected final AtomicInteger num_msgs_sent;
        protected final AtomicLong seqno;
        protected final byte[] payload;

        protected Sender(CyclicBarrier barrier, AtomicInteger num_msgs_sent, AtomicLong seqno, byte[] payload) {
            this.barrier = barrier;
            this.num_msgs_sent = num_msgs_sent;
            this.seqno = seqno;
            this.payload = payload;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            while (true) {
                try {
                    int tmp;
                    while ((tmp = this.num_msgs_sent.incrementAndGet()) <= MPerfRpc.this.num_msgs) {
                        long new_seqno = this.seqno.getAndIncrement();
                        MPerfRpc.this.invokeRpc((short)0, MPerfRpc.this.send_options, MPerfRpc.this.local_addr, this.payload, new_seqno, MPerfRpc.this.num_threads == 1);
                        if (tmp % MPerfRpc.this.log_interval == 0) {
                            System.out.println("++ sent " + tmp);
                        }
                        if (tmp != MPerfRpc.this.num_msgs) continue;
                        RequestOptions opts = RequestOptions.ASYNC().flags(Message.Flag.RSVP);
                        MPerfRpc.this.invokeRpc((short)2, opts, MPerfRpc.this.local_addr);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

