/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.hawk;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.Nonce;

public class NonceHistory
implements Serializable {
    private static final long serialVersionUID = -6404833046910698956L;
    private final long requestTimeDelta;
    private final Set<Nonce> nonceList = Collections.synchronizedSet(new LinkedHashSet());

    public NonceHistory(long requestTimeDelta, Nonce nonce) {
        this.requestTimeDelta = requestTimeDelta;
        this.nonceList.add(nonce);
    }

    public boolean addNonce(Nonce nonce) {
        return this.nonceList.add(nonce);
    }

    public long getRequestTimeDelta() {
        return this.requestTimeDelta;
    }

    public Set<Nonce> getNonces() {
        return Collections.unmodifiableSet(this.nonceList);
    }
}

