/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.ref.SoftReference;
import org.apache.commons.pool2.impl.PooledSoftReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestPooledSoftReference {
    private static final String REFERENT = "test";
    private static final String REFERENT2 = "test2";
    PooledSoftReference<String> ref;

    TestPooledSoftReference() {
    }

    @BeforeEach
    public void setUp() {
        SoftReference<String> softRef = new SoftReference<String>(REFERENT);
        this.ref = new PooledSoftReference(softRef);
    }

    @Test
    void testPooledSoftReference() {
        Assertions.assertEquals((Object)REFERENT, (Object)this.ref.getObject());
        SoftReference softRef = this.ref.getReference();
        Assertions.assertEquals((Object)REFERENT, softRef.get());
        softRef.clear();
        softRef = new SoftReference(REFERENT2);
        this.ref.setReference(softRef);
        Assertions.assertEquals((Object)REFERENT2, (Object)this.ref.getObject());
        softRef = this.ref.getReference();
        Assertions.assertEquals((Object)REFERENT2, softRef.get());
        softRef.clear();
    }

    @Test
    void testToString() {
        String expected = "Referenced Object: test, State: IDLE";
        Assertions.assertEquals((Object)"Referenced Object: test, State: IDLE", (Object)this.ref.toString());
    }
}

