/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class GenericWithDefaultTest {
    private static final String RECORD_SCHEMA_WITH_DEFAULT = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" },\n{ \"name\": \"f7\", \"type\": \"string\", \"default\": \"undefined\" },\n{ \"name\": \"f8\", \"type\": \"string\",\"default\": \"undefined\" }\n] }";

    @Benchmark
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        GenericDatumWriter writer = new GenericDatumWriter(state.schema);
        for (GenericRecord rec : state.testData) {
            writer.write((Object)rec, e);
        }
    }

    @Benchmark
    public void decode(Blackhole blackhole, TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        GenericDatumReader reader = new GenericDatumReader(state.schema);
        for (int i = 0; i < state.getBatchSize(); ++i) {
            blackhole.consume(reader.read(null, d));
        }
    }

    private static String randomString(Random r) {
        char[] data = new char[r.nextInt(70)];
        for (int j = 0; j < data.length; ++j) {
            data[j] = (char)(97 + r.nextInt(25));
        }
        return new String(data);
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private final Schema schema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" },\n{ \"name\": \"f7\", \"type\": \"string\", \"default\": \"undefined\" },\n{ \"name\": \"f8\", \"type\": \"string\",\"default\": \"undefined\" }\n] }");
        private GenericRecord[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new GenericRecord[this.getBatchSize()];
            Random r = super.getRandom();
            for (int i = 0; i < this.testData.length; ++i) {
                GenericData.Record rec = new GenericData.Record(this.schema);
                rec.put(0, (Object)r.nextDouble());
                rec.put(1, (Object)r.nextDouble());
                rec.put(2, (Object)r.nextDouble());
                rec.put(3, (Object)r.nextInt());
                rec.put(4, (Object)r.nextInt());
                rec.put(5, (Object)r.nextInt());
                rec.put(6, (Object)GenericWithDefaultTest.randomString(r));
                rec.put(7, (Object)GenericWithDefaultTest.randomString(r));
                this.testData[i] = rec;
            }
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private final Schema schema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" },\n{ \"name\": \"f7\", \"type\": \"string\", \"default\": \"undefined\" },\n{ \"name\": \"f8\", \"type\": \"string\",\"default\": \"undefined\" }\n] }");
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            GenericDatumWriter writer = new GenericDatumWriter(this.schema);
            Random r = super.getRandom();
            for (int i = 0; i < this.getBatchSize(); ++i) {
                GenericData.Record rec = new GenericData.Record(this.schema);
                rec.put(0, (Object)r.nextDouble());
                rec.put(1, (Object)r.nextDouble());
                rec.put(2, (Object)r.nextDouble());
                rec.put(3, (Object)r.nextInt());
                rec.put(4, (Object)r.nextInt());
                rec.put(5, (Object)r.nextInt());
                rec.put(6, (Object)GenericWithDefaultTest.randomString(r));
                rec.put(7, (Object)GenericWithDefaultTest.randomString(r));
                writer.write((Object)rec, encoder);
            }
            encoder.flush();
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = DecoderFactory.get().validatingDecoder(this.schema, super.newDecoder(this.testData));
        }
    }
}

