/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.springmvc;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.springframework.web.filter.ServerHttpObservationFilter;

public final class SpringWebUtils {
    private static final boolean SPRING_WEB_DETECTED;

    private SpringWebUtils() {
    }

    public static void setHttpRequestURI(HttpServletRequest request, String uriTemplate) {
        request.setAttribute("org.springframework.web.servlet.HandlerMapping.bestMatchingPattern", (Object)uriTemplate);
        if (SPRING_WEB_DETECTED) {
            ServerHttpObservationFilter.findObservationContext((HttpServletRequest)request).ifPresent(context -> context.setPathPattern(uriTemplate));
        }
    }

    static {
        boolean springWebDetected = false;
        try {
            ClassLoaderUtils.loadClass("org.springframework.web.filter.ServerHttpObservationFilter", SpringWebUtils.class);
            springWebDetected = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SPRING_WEB_DETECTED = springWebDetected;
    }
}

