/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.ucar;

import java.util.logging.Level;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.CharSequences;

final class LogAdapter
implements Appendable {
    private final StringBuilder buffer = new StringBuilder();
    private final StoreListeners listeners;

    LogAdapter(StoreListeners listeners) {
        this.listeners = listeners;
    }

    @Override
    public Appendable append(CharSequence message) {
        if (message.length() != 0) {
            CharSequence[] sp = CharSequences.splitOnEOL((CharSequence)message);
            int count = sp.length;
            char c = message.charAt(message.length() - 1);
            if (c != '\r' && c != '\n') {
                --count;
            }
            for (int i = 0; i < count; ++i) {
                CharSequence line = sp[i];
                if (this.buffer.length() != 0) {
                    this.log(this.buffer.append(line));
                    this.buffer.setLength(0);
                    continue;
                }
                this.log(line);
            }
            if (count != sp.length) {
                this.buffer.append(sp[count]);
            }
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence message, int start, int end) {
        if (message == null) {
            message = "null";
        }
        return this.append(message.subSequence(start, end));
    }

    @Override
    public Appendable append(char c) {
        if (c != '\r' && c != '\n') {
            this.buffer.append(c);
        } else if (this.buffer.length() != 0) {
            this.log(this.buffer);
            this.buffer.setLength(0);
        }
        return this;
    }

    private void log(CharSequence message) {
        if ((message = CharSequences.trimWhitespaces((CharSequence)message)).length() != 0) {
            this.listeners.warning(Level.FINE, message.toString(), null);
        }
    }
}

