/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.EndTransactionRequest;
import apache.rocketmq.v2.EndTransactionResponse;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.RecoverOrphanedTransactionCommand;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.SendMessageResponse;
import apache.rocketmq.v2.Status;
import apache.rocketmq.v2.TransactionResolution;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.javacrumbs.futureconverter.java8guava.FutureConverter;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.apis.producer.Transaction;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;
import org.apache.rocketmq.client.java.exception.InternalErrorException;
import org.apache.rocketmq.client.java.exception.TooManyRequestsException;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContextImpl;
import org.apache.rocketmq.client.java.impl.ClientImpl;
import org.apache.rocketmq.client.java.impl.Settings;
import org.apache.rocketmq.client.java.impl.producer.PublishingLoadBalancer;
import org.apache.rocketmq.client.java.impl.producer.PublishingSettings;
import org.apache.rocketmq.client.java.impl.producer.SendReceiptImpl;
import org.apache.rocketmq.client.java.impl.producer.TransactionImpl;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.client.java.message.GeneralMessageImpl;
import org.apache.rocketmq.client.java.message.MessageImpl;
import org.apache.rocketmq.client.java.message.MessageType;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.message.PublishingMessageImpl;
import org.apache.rocketmq.client.java.retry.ExponentialBackoffRetryPolicy;
import org.apache.rocketmq.client.java.retry.RetryPolicy;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.route.TopicRouteData;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProducerImpl
extends ClientImpl
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(ProducerImpl.class);
    protected final PublishingSettings publishingSettings;
    final ConcurrentMap<String, PublishingLoadBalancer> publishingRouteDataCache;
    private final TransactionChecker checker;

    ProducerImpl(ClientConfiguration clientConfiguration, Set<String> topics, int maxAttempts, TransactionChecker checker) {
        super(clientConfiguration, topics);
        ExponentialBackoffRetryPolicy retryPolicy = ExponentialBackoffRetryPolicy.immediatelyRetryPolicy(maxAttempts);
        this.publishingSettings = new PublishingSettings(this.clientId, this.endpoints, retryPolicy, clientConfiguration.getRequestTimeout(), topics);
        this.checker = checker;
        this.publishingRouteDataCache = new ConcurrentHashMap<String, PublishingLoadBalancer>();
    }

    @Override
    protected void startUp() throws Exception {
        try {
            log.info("Begin to start the rocketmq producer, clientId={}", (Object)this.clientId);
            super.startUp();
            log.info("The rocketmq producer starts successfully, clientId={}", (Object)this.clientId);
        }
        catch (Throwable t) {
            log.error("Failed to start the rocketmq producer, try to shutdown it, clientId={}", (Object)this.clientId, (Object)t);
            this.shutDown();
            throw t;
        }
    }

    @Override
    protected void shutDown() throws InterruptedException {
        log.info("Begin to shutdown the rocketmq producer, clientId={}", (Object)this.clientId);
        super.shutDown();
        log.info("Shutdown the rocketmq producer successfully, clientId={}", (Object)this.clientId);
    }

    @Override
    public void onRecoverOrphanedTransactionCommand(final Endpoints endpoints, RecoverOrphanedTransactionCommand command) {
        SettableFuture future;
        MessageViewImpl messageView;
        final String transactionId = command.getTransactionId();
        final String messageId = command.getMessage().getSystemProperties().getMessageId();
        if (null == this.checker) {
            log.error("No transaction checker registered, ignore it, messageId={}, transactionId={}, endpoints={}, clientId={}", new Object[]{messageId, transactionId, endpoints, this.clientId});
            return;
        }
        try {
            messageView = MessageViewImpl.fromProtobuf(command.getMessage());
        }
        catch (Throwable t) {
            log.error("[Bug] Failed to decode message during orphaned transaction message recovery, messageId={}, transactionId={}, endpoints={}, clientId={}", new Object[]{messageId, transactionId, endpoints, this.clientId, t});
            return;
        }
        try {
            ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)this.telemetryCommandExecutor);
            Callable<org.apache.rocketmq.client.apis.producer.TransactionResolution> task = () -> this.checker.check((MessageView)messageView);
            future = service.submit(task);
        }
        catch (Throwable t) {
            SettableFuture future0 = SettableFuture.create();
            future0.setException(t);
            future = future0;
        }
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<org.apache.rocketmq.client.apis.producer.TransactionResolution>(){

            public void onSuccess(org.apache.rocketmq.client.apis.producer.TransactionResolution resolution) {
                try {
                    if (null == resolution || org.apache.rocketmq.client.apis.producer.TransactionResolution.UNKNOWN.equals((Object)resolution)) {
                        return;
                    }
                    GeneralMessageImpl generalMessage = new GeneralMessageImpl(messageView);
                    ProducerImpl.this.endTransaction(endpoints, generalMessage, messageView.getMessageId(), transactionId, resolution);
                }
                catch (Throwable t) {
                    log.error("Exception raised while ending the transaction, messageId={}, transactionId={}, endpoints={}, clientId={}", new Object[]{messageId, transactionId, endpoints, ProducerImpl.this.clientId, t});
                }
            }

            public void onFailure(Throwable t) {
                log.error("Exception raised while checking the transaction, messageId={}, transactionId={}, endpoints={}, clientId={}", new Object[]{messageId, transactionId, endpoints, ProducerImpl.this.clientId, t});
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public Settings getSettings() {
        return this.publishingSettings;
    }

    @Override
    public NotifyClientTerminationRequest wrapNotifyClientTerminationRequest() {
        return NotifyClientTerminationRequest.newBuilder().build();
    }

    @Override
    public HeartbeatRequest wrapHeartbeatRequest() {
        return HeartbeatRequest.newBuilder().build();
    }

    public SendReceipt send(Message message) throws ClientException {
        ListenableFuture future = Futures.transform(this.send(Collections.singletonList(message), false), sendReceipts -> (SendReceipt)sendReceipts.iterator().next(), (Executor)MoreExecutors.directExecutor());
        return (SendReceipt)this.handleClientFuture(future);
    }

    public SendReceipt send(Message message, Transaction transaction) throws ClientException {
        PublishingMessageImpl publishingMessage;
        if (!(transaction instanceof TransactionImpl)) {
            throw new IllegalArgumentException("Failed downcasting for transaction");
        }
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        try {
            publishingMessage = transactionImpl.tryAddMessage(message);
        }
        catch (Throwable t) {
            throw new ClientException(t);
        }
        ListenableFuture<List<SendReceiptImpl>> future = this.send(Collections.singletonList(publishingMessage), true);
        List<SendReceiptImpl> receipts = this.handleClientFuture(future);
        SendReceiptImpl sendReceipt = receipts.iterator().next();
        ((TransactionImpl)transaction).tryAddReceipt(publishingMessage, sendReceipt);
        return sendReceipt;
    }

    public CompletableFuture<SendReceipt> sendAsync(Message message) {
        ListenableFuture future = Futures.transform(this.send(Collections.singletonList(message), false), sendReceipts -> (SendReceipt)sendReceipts.iterator().next(), (Executor)MoreExecutors.directExecutor());
        return FutureConverter.toCompletableFuture((ListenableFuture)future);
    }

    public Transaction beginTransaction() {
        Preconditions.checkNotNull((Object)this.checker, (Object)"Transaction checker should not be null");
        if (!this.isRunning()) {
            log.error("Unable to begin a transaction because producer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            throw new IllegalStateException("Producer is not running now");
        }
        return new TransactionImpl(this);
    }

    public void close() {
        this.stopAsync().awaitTerminated();
    }

    public void endTransaction(Endpoints endpoints, GeneralMessage generalMessage, MessageId messageId, String transactionId, org.apache.rocketmq.client.apis.producer.TransactionResolution resolution) throws ClientException {
        EndTransactionRequest.Builder builder = EndTransactionRequest.newBuilder().setMessageId(messageId.toString()).setTransactionId(transactionId).setTopic(Resource.newBuilder().setName(generalMessage.getTopic()).build());
        switch (resolution) {
            case COMMIT: {
                builder.setResolution(TransactionResolution.COMMIT);
                break;
            }
            default: {
                builder.setResolution(TransactionResolution.ROLLBACK);
            }
        }
        Duration requestTimeout = this.clientConfiguration.getRequestTimeout();
        EndTransactionRequest request = builder.build();
        final List<GeneralMessage> generalMessages = Collections.singletonList(generalMessage);
        MessageHookPoints messageHookPoints = org.apache.rocketmq.client.apis.producer.TransactionResolution.COMMIT.equals((Object)resolution) ? MessageHookPoints.COMMIT_TRANSACTION : MessageHookPoints.ROLLBACK_TRANSACTION;
        final MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(messageHookPoints);
        this.doBefore(context, generalMessages);
        RpcFuture<EndTransactionRequest, EndTransactionResponse> future = this.getClientManager().endTransaction(endpoints, request, requestTimeout);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<EndTransactionResponse>(){

            public void onSuccess(EndTransactionResponse response) {
                Status status = response.getStatus();
                Code code = status.getCode();
                MessageHookPointsStatus hookPointsStatus = Code.OK.equals((Object)code) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, hookPointsStatus);
                ProducerImpl.this.doAfter(context0, generalMessages);
            }

            public void onFailure(Throwable t) {
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.ERROR);
                ProducerImpl.this.doAfter(context0, generalMessages);
            }
        }, (Executor)MoreExecutors.directExecutor());
        EndTransactionResponse response = (EndTransactionResponse)this.handleClientFuture(future);
        Status status = response.getStatus();
        Code code = status.getCode();
        if (!Code.OK.equals((Object)code)) {
            throw new ClientException(code.getNumber(), future.getContext().getRequestId(), status.getMessage());
        }
    }

    private void isolate(Endpoints endpoints) {
        this.isolated.add(endpoints);
    }

    private RetryPolicy getRetryPolicy() {
        return this.publishingSettings.getRetryPolicy();
    }

    private List<MessageQueueImpl> takeMessageQueues(PublishingLoadBalancer result) {
        return result.takeMessageQueues(this.isolated, this.getRetryPolicy().getMaxAttempts());
    }

    private ListenableFuture<List<SendReceiptImpl>> send(List<Message> messages, boolean txEnabled) {
        String messageGroup;
        SettableFuture future = SettableFuture.create();
        if (!this.isRunning()) {
            IllegalStateException e = new IllegalStateException("Producer is not running now");
            future.setException((Throwable)e);
            log.error("Unable to send message because producer is not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            return future;
        }
        ArrayList<PublishingMessageImpl> pubMessages = new ArrayList<PublishingMessageImpl>();
        for (Message message : messages) {
            try {
                PublishingMessageImpl pubMessage = new PublishingMessageImpl(message, this.publishingSettings, txEnabled);
                pubMessages.add(pubMessage);
            }
            catch (Throwable t) {
                log.error("Failed to refine message to send, clientId={}, message={}", new Object[]{this.clientId, message, t});
                future.setException(t);
                return future;
            }
        }
        Set topics = pubMessages.stream().map(Message::getTopic).collect(Collectors.toSet());
        if (1 < topics.size()) {
            IllegalArgumentException e = new IllegalArgumentException("Messages to send have different topics");
            future.setException((Throwable)e);
            log.error("Messages to be sent have different topics, no need to proceed, topic(s)={}, clientId={}", topics, (Object)this.clientId);
            return future;
        }
        String topic = (String)topics.iterator().next();
        Set messageTypes = pubMessages.stream().map(PublishingMessageImpl::getMessageType).collect(Collectors.toSet());
        if (1 < messageTypes.size()) {
            IllegalArgumentException e = new IllegalArgumentException("Messages to send have different types, please check");
            future.setException((Throwable)e);
            log.error("Messages to be sent have different message types, no need to proceed, topic={}, messageType(s)={}, clientId={}", new Object[]{topic, messageTypes, this.clientId, e});
            return future;
        }
        MessageType messageType = (MessageType)((Object)messageTypes.iterator().next());
        if (MessageType.FIFO.equals((Object)messageType)) {
            Set messageGroups = pubMessages.stream().map(MessageImpl::getMessageGroup).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            if (1 < messageGroups.size()) {
                IllegalArgumentException e = new IllegalArgumentException("FIFO messages to send have different message groups, messageGroups=" + messageGroups);
                future.setException((Throwable)e);
                log.error("FIFO messages to be sent have different message groups, no need to proceed, topic={}, messageGroups={}, clientId={}", new Object[]{topic, messageGroups, this.clientId, e});
                return future;
            }
            messageGroup = (String)messageGroups.iterator().next();
        } else {
            messageGroup = null;
        }
        this.topics.add(topic);
        ListenableFuture<PublishingLoadBalancer> routeFuture = this.getPublishingLoadBalancer(topic);
        return Futures.transformAsync(routeFuture, result -> {
            List<MessageQueueImpl> candidates = null == messageGroup ? this.takeMessageQueues((PublishingLoadBalancer)result) : Collections.singletonList(result.takeMessageQueueByMessageGroup(messageGroup));
            SettableFuture future0 = SettableFuture.create();
            this.send0((SettableFuture<List<SendReceiptImpl>>)future0, topic, messageType, candidates, pubMessages, 1);
            return future0;
        }, (Executor)MoreExecutors.directExecutor());
    }

    private SendMessageRequest wrapSendMessageRequest(List<PublishingMessageImpl> pubMessages, MessageQueueImpl mq) {
        List messages = pubMessages.stream().map(publishingMessage -> publishingMessage.toProtobuf(mq)).collect(Collectors.toList());
        return SendMessageRequest.newBuilder().addAllMessages(messages).build();
    }

    ListenableFuture<List<SendReceiptImpl>> send0(Endpoints endpoints, List<PublishingMessageImpl> pubMessages, MessageQueueImpl mq) {
        SendMessageRequest request = this.wrapSendMessageRequest(pubMessages, mq);
        RpcFuture<SendMessageRequest, SendMessageResponse> future0 = this.getClientManager().sendMessage(endpoints, request, this.clientConfiguration.getRequestTimeout());
        return Futures.transformAsync(future0, response -> Futures.immediateFuture(SendReceiptImpl.processResponseInvocation(mq, response, future0)), (Executor)MoreExecutors.directExecutor());
    }

    private void send0(final SettableFuture<List<SendReceiptImpl>> future0, final String topic, final MessageType messageType, final List<MessageQueueImpl> candidates, final List<PublishingMessageImpl> messages, final int attempt) {
        MessageQueueImpl mq = candidates.get(IntMath.mod((int)(attempt - 1), (int)candidates.size()));
        List<MessageType> acceptMessageTypes = mq.getAcceptMessageTypes();
        if (this.publishingSettings.isValidateMessageType() && !acceptMessageTypes.contains((Object)messageType)) {
            IllegalArgumentException e = new IllegalArgumentException("Current message type not match with topic accept message types, topic=" + topic + ", actualMessageType=" + (Object)((Object)messageType) + ", acceptMessageTypes=" + acceptMessageTypes);
            future0.setException((Throwable)e);
            return;
        }
        final Endpoints endpoints = mq.getBroker().getEndpoints();
        ListenableFuture<List<SendReceiptImpl>> future = this.send0(endpoints, messages, mq);
        final int maxAttempts = this.getRetryPolicy().getMaxAttempts();
        final List<GeneralMessage> generalMessages = messages.stream().map(GeneralMessageImpl::new).collect(Collectors.toList());
        final MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(MessageHookPoints.SEND);
        this.doBefore(context, generalMessages);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<List<SendReceiptImpl>>(){

            public void onSuccess(List<SendReceiptImpl> sendReceipts) {
                if (sendReceipts.size() != messages.size()) {
                    InternalErrorException e = new InternalErrorException("[Bug] due to an unknown reason from remote, received send receipt's quantity " + sendReceipts.size() + " is not equal to sent message's quantity " + messages.size());
                    future0.setException((Throwable)((Object)e));
                    MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.ERROR);
                    ProducerImpl.this.doAfter(context0, generalMessages);
                    return;
                }
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.OK);
                ProducerImpl.this.doAfter(context0, generalMessages);
                future0.set(sendReceipts);
                if (1 < attempt) {
                    ArrayList<MessageId> messageIds = new ArrayList<MessageId>();
                    for (SendReceipt sendReceipt : sendReceipts) {
                        messageIds.add(sendReceipt.getMessageId());
                    }
                    log.info("Resend message successfully, topic={}, messageId(s)={}, maxAttempts={}, attempt={}, endpoints={}, clientId={}", new Object[]{topic, messageIds, maxAttempts, attempt, endpoints, ProducerImpl.this.clientId});
                }
            }

            public void onFailure(Throwable t) {
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.ERROR);
                ProducerImpl.this.doAfter(context0, generalMessages);
                ArrayList<MessageId> messageIds = new ArrayList<MessageId>();
                for (PublishingMessageImpl message : messages) {
                    messageIds.add(message.getMessageId());
                }
                ProducerImpl.this.isolate(endpoints);
                if (attempt >= maxAttempts) {
                    future0.setException(t);
                    log.error("Failed to send message(s) finally, run out of attempt times, maxAttempts={}, attempt={}, topic={}, messageId(s)={}, endpoints={}, clientId={}", new Object[]{maxAttempts, attempt, topic, messageIds, endpoints, ProducerImpl.this.clientId, t});
                    return;
                }
                if (MessageType.TRANSACTION.equals((Object)messageType)) {
                    future0.setException(t);
                    log.error("Failed to send transactional message finally, maxAttempts=1, attempt={}, topic={}, messageId(s)={}, endpoints={}, clientId={}", new Object[]{attempt, topic, messageIds, endpoints, ProducerImpl.this.clientId, t});
                    return;
                }
                int nextAttempt = 1 + attempt;
                if (!(t instanceof TooManyRequestsException)) {
                    log.warn("Failed to send message, would attempt to resend right now, maxAttempts={}, attempt={}, topic={}, messageId(s)={}, endpoints={}, clientId={}", new Object[]{maxAttempts, attempt, topic, messageIds, endpoints, ProducerImpl.this.clientId, t});
                    ProducerImpl.this.send0((SettableFuture<List<SendReceiptImpl>>)future0, topic, messageType, candidates, messages, nextAttempt);
                    return;
                }
                Duration delay = ProducerImpl.this.getRetryPolicy().getNextAttemptDelay(nextAttempt);
                log.warn("Failed to send message due to too many requests, would attempt to resend after {}, maxAttempts={}, attempt={}, topic={}, messageId(s)={}, endpoints={}, clientId={}", new Object[]{delay, maxAttempts, attempt, topic, messageIds, endpoints, ProducerImpl.this.clientId, t});
                ProducerImpl.this.getClientManager().getScheduler().schedule(() -> ProducerImpl.this.send0((SettableFuture<List<SendReceiptImpl>>)future0, topic, messageType, candidates, messages, nextAttempt), delay.toNanos(), TimeUnit.NANOSECONDS);
            }
        }, (Executor)this.clientCallbackExecutor);
    }

    private PublishingLoadBalancer updatePublishingLoadBalancer(String topic, TopicRouteData topicRouteData) {
        PublishingLoadBalancer publishingLoadBalancer = (PublishingLoadBalancer)this.publishingRouteDataCache.get(topic);
        publishingLoadBalancer = null == publishingLoadBalancer ? new PublishingLoadBalancer(topicRouteData) : publishingLoadBalancer.update(topicRouteData);
        this.publishingRouteDataCache.put(topic, publishingLoadBalancer);
        return publishingLoadBalancer;
    }

    @Override
    public void onTopicRouteDataUpdate0(String topic, TopicRouteData topicRouteData) {
        this.updatePublishingLoadBalancer(topic, topicRouteData);
    }

    private ListenableFuture<PublishingLoadBalancer> getPublishingLoadBalancer(String topic) {
        PublishingLoadBalancer loadBalancer = (PublishingLoadBalancer)this.publishingRouteDataCache.get(topic);
        if (null != loadBalancer) {
            return Futures.immediateFuture((Object)loadBalancer);
        }
        return Futures.transform(this.getRouteData(topic), topicRouteData -> this.updatePublishingLoadBalancer(topic, (TopicRouteData)topicRouteData), (Executor)MoreExecutors.directExecutor());
    }
}

