/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.EndTransactionRequest;
import apache.rocketmq.v2.EndTransactionResponse;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.HeartbeatResponse;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.NotifyClientTerminationResponse;
import apache.rocketmq.v2.QueryAssignmentRequest;
import apache.rocketmq.v2.QueryAssignmentResponse;
import apache.rocketmq.v2.QueryRouteRequest;
import apache.rocketmq.v2.QueryRouteResponse;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.SendMessageResponse;
import apache.rocketmq.v2.TelemetryCommand;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.Metadata;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLException;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.java.impl.Client;
import org.apache.rocketmq.client.java.impl.ClientManager;
import org.apache.rocketmq.client.java.misc.ExecutorServices;
import org.apache.rocketmq.client.java.misc.ThreadFactoryImpl;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.rpc.RpcClient;
import org.apache.rocketmq.client.java.rpc.RpcClientImpl;
import org.apache.rocketmq.client.java.rpc.RpcInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManagerImpl
extends ClientManager {
    public static final Duration RPC_CLIENT_MAX_IDLE_DURATION = Duration.ofMinutes(30L);
    public static final Duration RPC_CLIENT_IDLE_CHECK_INITIAL_DELAY = Duration.ofSeconds(5L);
    public static final Duration RPC_CLIENT_IDLE_CHECK_PERIOD = Duration.ofMinutes(1L);
    public static final Duration HEART_BEAT_INITIAL_DELAY = Duration.ofSeconds(1L);
    public static final Duration HEART_BEAT_PERIOD = Duration.ofSeconds(10L);
    public static final Duration LOG_STATS_INITIAL_DELAY = Duration.ofSeconds(60L);
    public static final Duration LOG_STATS_PERIOD = Duration.ofSeconds(60L);
    public static final Duration SYNC_SETTINGS_DELAY = Duration.ofSeconds(1L);
    public static final Duration SYNC_SETTINGS_PERIOD = Duration.ofMinutes(5L);
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientManagerImpl.class);
    private final Client client;
    @GuardedBy(value="rpcClientTableLock")
    private final Map<Endpoints, RpcClient> rpcClientTable;
    private final ReadWriteLock rpcClientTableLock;
    private final ScheduledExecutorService scheduler;
    private final ExecutorService asyncWorker;

    public ClientManagerImpl(Client client) {
        this.client = client;
        this.rpcClientTable = new HashMap<Endpoints, RpcClient>();
        this.rpcClientTableLock = new ReentrantReadWriteLock();
        this.scheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new ThreadFactoryImpl("ClientScheduler"));
        this.asyncWorker = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("ClientAsyncWorker"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIdleRpcClients() throws InterruptedException {
        this.rpcClientTableLock.writeLock().lock();
        try {
            Iterator<Map.Entry<Endpoints, RpcClient>> it = this.rpcClientTable.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Endpoints, RpcClient> entry = it.next();
                Endpoints endpoints = entry.getKey();
                RpcClient client = entry.getValue();
                Duration idleDuration = client.idleDuration();
                if (idleDuration.compareTo(RPC_CLIENT_MAX_IDLE_DURATION) <= 0) continue;
                it.remove();
                client.shutdown();
                LOGGER.info("Rpc client has been idle for a long time, endpoints={}, idleDuration={}, rpcClientMaxIdleDuration={}", new Object[]{endpoints, idleDuration, RPC_CLIENT_MAX_IDLE_DURATION});
            }
        }
        finally {
            this.rpcClientTableLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcClient getRpcClient(Endpoints endpoints) throws ClientException {
        RpcClient rpcClient;
        this.rpcClientTableLock.readLock().lock();
        try {
            rpcClient = this.rpcClientTable.get(endpoints);
            if (null != rpcClient) {
                RpcClient rpcClient2 = rpcClient;
                return rpcClient2;
            }
        }
        finally {
            this.rpcClientTableLock.readLock().unlock();
        }
        this.rpcClientTableLock.writeLock().lock();
        try {
            rpcClient = this.rpcClientTable.get(endpoints);
            if (null != rpcClient) {
                RpcClient rpcClient3 = rpcClient;
                return rpcClient3;
            }
            try {
                rpcClient = new RpcClientImpl(endpoints);
            }
            catch (SSLException e) {
                LOGGER.error("Failed to get rpc client, endpoints={}", (Object)endpoints);
                throw new ClientException("Failed to generate RPC client", (Throwable)e);
            }
            this.rpcClientTable.put(endpoints, rpcClient);
            RpcClient rpcClient4 = rpcClient;
            return rpcClient4;
        }
        finally {
            this.rpcClientTableLock.writeLock().unlock();
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<QueryRouteResponse>> queryRoute(Endpoints endpoints, Metadata metadata, QueryRouteRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.queryRoute(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<HeartbeatResponse>> heartbeat(Endpoints endpoints, Metadata metadata, HeartbeatRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.heartbeat(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<SendMessageResponse>> sendMessage(Endpoints endpoints, Metadata metadata, SendMessageRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.sendMessage(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<QueryAssignmentResponse>> queryAssignment(Endpoints endpoints, Metadata metadata, QueryAssignmentRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.queryAssignment(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<Iterator<ReceiveMessageResponse>>> receiveMessage(Endpoints endpoints, Metadata metadata, ReceiveMessageRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.receiveMessage(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<AckMessageResponse>> ackMessage(Endpoints endpoints, Metadata metadata, AckMessageRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.ackMessage(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<ChangeInvisibleDurationResponse>> changeInvisibleDuration(Endpoints endpoints, Metadata metadata, ChangeInvisibleDurationRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.changeInvisibleDuration(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<ForwardMessageToDeadLetterQueueResponse>> forwardMessageToDeadLetterQueue(Endpoints endpoints, Metadata metadata, ForwardMessageToDeadLetterQueueRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.forwardMessageToDeadLetterQueue(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<EndTransactionResponse>> endTransaction(Endpoints endpoints, Metadata metadata, EndTransactionRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.endTransaction(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public ListenableFuture<RpcInvocation<NotifyClientTerminationResponse>> notifyClientTermination(Endpoints endpoints, Metadata metadata, NotifyClientTerminationRequest request, Duration duration) {
        try {
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.notifyClientTermination(metadata, request, this.asyncWorker, duration);
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    @Override
    public StreamObserver<TelemetryCommand> telemetry(Endpoints endpoints, Metadata metadata, Duration duration, StreamObserver<TelemetryCommand> responseObserver) throws ClientException {
        RpcClient rpcClient = this.getRpcClient(endpoints);
        return rpcClient.telemetry(metadata, this.asyncWorker, duration, responseObserver);
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    protected void startUp() {
        LOGGER.info("Begin to start the client manager");
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.clearIdleRpcClients();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised while clear idle rpc clients.", t);
            }
        }, RPC_CLIENT_IDLE_CHECK_INITIAL_DELAY.toNanos(), RPC_CLIENT_IDLE_CHECK_PERIOD.toNanos(), TimeUnit.NANOSECONDS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.client.doHeartbeat();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised while heartbeat.", t);
            }
        }, HEART_BEAT_INITIAL_DELAY.toNanos(), HEART_BEAT_PERIOD.toNanos(), TimeUnit.NANOSECONDS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.client.doStats();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised while log stats.", t);
            }
        }, LOG_STATS_INITIAL_DELAY.toNanos(), LOG_STATS_PERIOD.toNanos(), TimeUnit.NANOSECONDS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.client.syncSettings();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised during the setting synchronizing.", t);
            }
        }, SYNC_SETTINGS_DELAY.toNanos(), SYNC_SETTINGS_PERIOD.toNanos(), TimeUnit.NANOSECONDS);
        LOGGER.info("The client manager starts successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws IOException {
        LOGGER.info("Begin to shutdown the client manager");
        this.scheduler.shutdown();
        try {
            if (!ExecutorServices.awaitTerminated(this.scheduler)) {
                LOGGER.error("[Bug] Timeout to shutdown the client scheduler");
            } else {
                LOGGER.info("Shutdown the client scheduler successfully");
            }
            this.rpcClientTableLock.writeLock().lock();
            try {
                Iterator<Map.Entry<Endpoints, RpcClient>> it = this.rpcClientTable.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Endpoints, RpcClient> entry = it.next();
                    RpcClient rpcClient = entry.getValue();
                    it.remove();
                    rpcClient.shutdown();
                }
            }
            finally {
                this.rpcClientTableLock.writeLock().unlock();
            }
            LOGGER.info("Shutdown all rpc client(s) successfully");
            this.asyncWorker.shutdown();
            if (!ExecutorServices.awaitTerminated(this.asyncWorker)) {
                LOGGER.error("[Bug] Timeout to shutdown the client async worker");
            } else {
                LOGGER.info("Shutdown the client async worker successfully");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("[Bug] Unexpected exception raised while shutdown client manager", (Throwable)e);
            throw new IOException(e);
        }
        LOGGER.info("Shutdown the client manager successfully");
    }
}

