/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import java.util.function.Function;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.vocabulary.XSD;

public class NodeFunctions {
    private static Duration zeroDuration = NodeValue.xmlDatatypeFactory.newDuration(true, null, null, null, null, null, BigDecimal.ZERO);

    public static NodeValue sameTerm(NodeValue nv1, NodeValue nv2) {
        return NodeValue.booleanReturn(NodeFunctions.sameTerm(nv1.asNode(), nv2.asNode()));
    }

    public static boolean sameTerm(Node node1, Node node2) {
        return node1.sameTermAs(node2);
    }

    public static boolean sameValue(NodeValue nv1, NodeValue nv2) {
        return NodeValue.sameValueAs(nv1, nv2);
    }

    public static boolean sameValue(Node node1, Node node2) {
        NodeValue nv1 = NodeValue.makeNode(node1);
        NodeValue nv2 = NodeValue.makeNode(node2);
        return NodeValue.sameValueAs(nv1, nv2);
    }

    public static boolean notSameValue(NodeValue nv1, NodeValue nv2) {
        return NodeValue.notSameValueAs(nv1, nv2);
    }

    public static boolean notSameValue(Node node1, Node node2) {
        NodeValue nv1 = NodeValue.makeNode(node1);
        NodeValue nv2 = NodeValue.makeNode(node2);
        return NodeValue.notSameValueAs(nv1, nv2);
    }

    public static NodeValue sameValueFunction(NodeValue x, NodeValue y) {
        if (NodeFunctions.isNaN(x)) {
            return NodeValue.booleanReturn(NodeFunctions.isNaN(y));
        }
        if (NodeFunctions.isNaN(y)) {
            return NodeValue.FALSE;
        }
        boolean b = NodeValue.sameValueAs(x, y);
        return NodeValue.booleanReturn(b);
    }

    public static boolean isNaN(NodeValue nv) {
        return NodeFunctions.isDoubleNaN(nv) || NodeFunctions.isFloatNaN(nv);
    }

    public static boolean isDoubleNaN(NodeValue nv) {
        if (nv.isDouble()) {
            double d = nv.getDouble();
            return Double.isNaN(d);
        }
        return false;
    }

    public static boolean isFloatNaN(NodeValue nv) {
        if (nv.isFloat()) {
            float f = nv.getFloat();
            return Float.isNaN(f);
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public static boolean rdfTermEqual11_legacy(Node n1, Node n2) {
        if (n1.equals((Object)n2)) {
            return true;
        }
        if (n1.isLiteral() && n2.isLiteral()) {
            boolean b;
            String lang1 = n1.getLiteralLanguage();
            String lang2 = n2.getLiteralLanguage();
            if (StringUtils.isNotEmpty((CharSequence)lang1) && StringUtils.isNotEmpty((CharSequence)lang2) && lang1.equalsIgnoreCase(lang2) && (b = n1.getLiteralLexicalForm().equals(n2.getLiteralLexicalForm()))) {
                return true;
            }
            NodeValue.raise(new ExprEvalException("Mismatch in RDFterm-equals: " + String.valueOf(n1) + ", " + String.valueOf(n2)));
        }
        if (n1.isTripleTerm() && n2.isTripleTerm()) {
            Triple t1 = n1.getTriple();
            Triple t2 = n2.getTriple();
            return NodeFunctions.rdfTermEqual11_legacy(t1.getSubject(), t2.getSubject()) && NodeFunctions.rdfTermEqual11_legacy(t1.getPredicate(), t2.getPredicate()) && NodeFunctions.rdfTermEqual11_legacy(t1.getObject(), t2.getObject());
        }
        return false;
    }

    public static NodeValue str(NodeValue nv) {
        return NodeValue.makeString(NodeFunctions.str(nv.asNode()));
    }

    public static String str(Node node) {
        if (node.isLiteral()) {
            return node.getLiteral().getLexicalForm();
        }
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isBlank() && !ARQ.isTrue(ARQ.strictSPARQL)) {
            return RiotLib.blankNodeToIriString(node);
        }
        if (node.isTripleTerm() && !ARQ.isTrue(ARQ.strictSPARQL)) {
            Triple t = node.getTriple();
            Function<Node, String> f = NodeFmtLib::strTTL;
            return "<< " + f.apply(t.getSubject()) + " " + f.apply(t.getPredicate()) + " " + f.apply(t.getObject()) + " >>";
        }
        if (node.isBlank()) {
            NodeValue.raise(new ExprEvalException("Blank node: " + String.valueOf(node)));
        }
        if (node.isTripleTerm()) {
            NodeValue.raise(new ExprEvalException("Triple term: " + String.valueOf(node)));
        }
        NodeValue.raise(new ExprEvalException("Not valid for STR(): " + String.valueOf(node)));
        return "[undef]";
    }

    public static NodeValue sortKey(NodeValue nv, String collation2) {
        return NodeValue.makeSortKey(NodeFunctions.str(nv.asNode()), collation2);
    }

    public static NodeValue datatype(NodeValue nv) {
        return NodeValue.makeNode(NodeFunctions.datatype(nv.asNode()));
    }

    public static Node datatype(Node node) {
        boolean plainLiteral;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("datatype: Not a literal: " + String.valueOf(node)));
            return null;
        }
        String s = node.getLiteralDatatypeURI();
        boolean bl = plainLiteral = s == null || s.equals("");
        if (plainLiteral) {
            boolean simpleLiteral;
            boolean bl2 = simpleLiteral = node.getLiteralLanguage() == null || node.getLiteralLanguage().equals("");
            if (!simpleLiteral) {
                return NodeConst.rdfLangString;
            }
            return XSD.xstring.asNode();
        }
        return NodeFactory.createURI((String)s);
    }

    public static NodeValue isNumeric(NodeValue nv) {
        return NodeValue.booleanReturn(nv.isNumber());
    }

    public static NodeValue hasLang(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.hasLang(nv.asNode()));
    }

    public static boolean hasLang(Node node) {
        return NodeUtils.hasLang(node);
    }

    public static NodeValue hasLangDir(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.hasLangDir(nv.asNode()));
    }

    public static boolean hasLangDir(Node node) {
        return NodeUtils.hasLangDir(node);
    }

    public static NodeValue lang(NodeValue nv) {
        if (nv.isLangString()) {
            return NodeValue.makeString(nv.getLang());
        }
        if (nv.isLiteral()) {
            return NodeValue.nvEmptyString;
        }
        NodeValue.raise(new ExprTypeException("lang: Not a literal: " + nv.asQuotedString()));
        return null;
    }

    public static String lang(Node node) {
        String s;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("lang: Not a literal: " + FmtUtils.stringForNode(node)));
        }
        if ((s = node.getLiteralLanguage()) == null) {
            return "";
        }
        return s;
    }

    public static NodeValue langdir(NodeValue nv) {
        if (nv.isLangString()) {
            return NodeValue.makeString(nv.getLangDir());
        }
        if (nv.isLiteral()) {
            return NodeValue.nvEmptyString;
        }
        NodeValue.raise(new ExprTypeException("lang: Not a literal: " + nv.asQuotedString()));
        return null;
    }

    public static String langdir(Node node) {
        TextDirection textDir;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("lang: Not a literal: " + FmtUtils.stringForNode(node)));
        }
        if ((textDir = node.getLiteralBaseDirection()) == null) {
            return "";
        }
        return textDir.direction();
    }

    public static NodeValue langMatches(NodeValue nv, NodeValue nvPattern) {
        return NodeFunctions.langMatches(nv, nvPattern.getString());
    }

    public static NodeValue langMatches(NodeValue nv, String langPattern) {
        Node node = nv.asNode();
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("langMatches: not a literal: " + String.valueOf(node)));
            return null;
        }
        String langStr = node.getLiteralLexicalForm();
        return NodeValue.booleanReturn(NodeFunctions.langMatches(langStr, langPattern));
    }

    public static boolean langMatches(String langStr, String langPattern) {
        String range;
        if (langPattern.equals("*")) {
            return langStr != null && !langStr.equals("");
        }
        String[] langElts = langStr.split("-");
        String[] langRangeElts = langPattern.split("-");
        if (langRangeElts.length > langElts.length) {
            return false;
        }
        for (int i = 0; i < langRangeElts.length && (range = langRangeElts[i]) != null && i < langElts.length; ++i) {
            String lang = langElts[i];
            if (range.equals("*") || range.equalsIgnoreCase(lang)) continue;
            return false;
        }
        return true;
    }

    public static NodeValue isIRI(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isIRI(nv.asNode()));
    }

    public static boolean isIRI(Node node) {
        return node.isURI();
    }

    public static NodeValue isURI(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isIRI(nv.asNode()));
    }

    public static boolean isURI(Node node) {
        return NodeFunctions.isIRI(node);
    }

    public static NodeValue isBlank(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isBlank(nv.asNode()));
    }

    public static boolean isBlank(Node node) {
        return node.isBlank();
    }

    public static NodeValue isLiteral(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isLiteral(nv.asNode()));
    }

    public static boolean isLiteral(Node node) {
        return node.isLiteral();
    }

    public static NodeValue iri(NodeValue nv, String baseIRI) {
        if (NodeFunctions.isIRI(nv.asNode())) {
            return nv;
        }
        Node n2 = NodeFunctions.iri(nv.asNode(), baseIRI);
        return NodeValue.makeNode(n2);
    }

    public static Node iri(Node n, String baseIRI) {
        Node node = RiotLib.blankNodeToIri(n);
        if (node.isURI()) {
            return node;
        }
        String str2 = NodeFunctions.simpleLiteralOrXSDString(node);
        if (str2 == null) {
            throw new ExprEvalException("Can't make an IRI from " + String.valueOf(node));
        }
        String iriStr = node.getLiteralLexicalForm();
        if (RiotLib.isBNodeIRI(iriStr)) {
            return NodeFactory.createURI((String)iriStr);
        }
        String iri = NodeFunctions.resolveCheckIRI(baseIRI, iriStr);
        return NodeFactory.createURI((String)iri);
    }

    private static String resolveCheckIRI(String baseIRI, String iriStr) {
        try {
            IRIx base;
            IRIx iri = IRIx.create((String)iriStr);
            if (!iri.isRelative()) {
                return iriStr;
            }
            IRIx iRIx = base = baseIRI != null ? IRIx.create((String)baseIRI) : IRIs.getSystemBase();
            if (base.isRelative()) {
                throw new ExprEvalException("Relative IRI for base: " + iriStr);
            }
            IRIx result = base.resolve(iri);
            if (!result.isReference()) {
                throw new IRIException("Not suitable: " + result.str());
            }
            return result.str();
        }
        catch (IRIException ex) {
            throw new ExprEvalException("Bad IRI: " + iriStr);
        }
    }

    public static NodeValue struuid() {
        return NodeValue.makeString(NodeFunctions.uuidString());
    }

    public static NodeValue uuid() {
        String str2 = "urn:uuid:" + NodeFunctions.uuidString();
        Node n = NodeFactory.createURI((String)str2);
        return NodeValue.makeNode(n);
    }

    private static String uuidString() {
        return UUID.randomUUID().toString();
    }

    private static String simpleLiteralOrXSDString(Node n) {
        if (!n.isLiteral()) {
            return null;
        }
        if (n.getLiteralDatatype() == null ? n.getLiteralLanguage().equals("") : n.getLiteralDatatype().equals((Object)XSDDatatype.XSDstring)) {
            return n.getLiteralLexicalForm();
        }
        return null;
    }

    public static NodeValue strDatatype(NodeValue v1, NodeValue v2) {
        if (!v1.isString()) {
            throw new ExprEvalException("Not a string (arg 1): " + String.valueOf(v1));
        }
        if (!v2.isIRI()) {
            throw new ExprEvalException("Not an IRI (arg 2): " + String.valueOf(v2));
        }
        String lex = v1.asString();
        Node dt = v2.asNode();
        Node n = NodeFactory.createLiteralDT((String)lex, (RDFDatatype)NodeFactory.getType((String)dt.getURI()));
        return NodeValue.makeNode(n);
    }

    public static NodeValue strLang(NodeValue v1, NodeValue v2) {
        if (!v1.isString()) {
            throw new ExprEvalException("Not a string (arg 1): " + String.valueOf(v1));
        }
        if (!v2.isString()) {
            throw new ExprEvalException("Not a string (arg 2): " + String.valueOf(v2));
        }
        String lex = v1.asString();
        String lang = v2.asString();
        if (lang.isEmpty()) {
            throw new ExprEvalException("Empty lang tag");
        }
        return NodeValue.makeLangString(lex, lang);
    }

    public static NodeValue strLangDir(NodeValue v1, NodeValue v2, NodeValue v3) {
        if (!v1.isString()) {
            throw new ExprEvalException("Not a string (arg 1): " + String.valueOf(v1));
        }
        if (!v2.isString()) {
            throw new ExprEvalException("Not a string (arg 2): " + String.valueOf(v2));
        }
        if (!v2.isString()) {
            throw new ExprEvalException("Not a string (arg 3): " + String.valueOf(v2));
        }
        String lex = v1.asString();
        String lang = v2.asString();
        if (lang.isEmpty()) {
            throw new ExprEvalException("Empty lang tag");
        }
        String textDirStr = v3.asString();
        if (textDirStr.isEmpty()) {
            throw new ExprEvalException("Empty base direction");
        }
        TextDirection textDir = TextDirection.createOrNull((String)v3.asString());
        if (textDir == null) {
            throw new ExprEvalException("Invalid base direction: '" + textDirStr + "'");
        }
        return NodeValue.makeDirLangString(lex, lang, textDir);
    }

    public static Duration duration(int seconds) {
        if (seconds == 0) {
            return zeroDuration;
        }
        Duration dur = NodeValue.xmlDatatypeFactory.newDuration(1000L * (long)seconds);
        dur = NodeValue.xmlDatatypeFactory.newDuration(dur.getSign() >= 0, NodeFunctions.field(dur, DatatypeConstants.YEARS), NodeFunctions.field(dur, DatatypeConstants.MONTHS), NodeFunctions.field(dur, DatatypeConstants.DAYS), NodeFunctions.field(dur, DatatypeConstants.HOURS), NodeFunctions.field(dur, DatatypeConstants.MINUTES), NodeFunctions.field2(dur, DatatypeConstants.SECONDS));
        return dur;
    }

    private static BigInteger field(Duration dur, DatatypeConstants.Field field) {
        BigInteger i = (BigInteger)dur.getField(field);
        if (i == null || i.equals(BigInteger.ZERO)) {
            return null;
        }
        return i;
    }

    private static BigDecimal field2(Duration dur, DatatypeConstants.Field field) {
        BigDecimal x = (BigDecimal)dur.getField(field);
        if (x.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return x;
    }
}

