/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.linshare.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import feign.Feign;
import feign.Logger;
import feign.Param;
import feign.RequestInterceptor;
import feign.RequestLine;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.io.File;
import org.apache.james.linshare.LinshareConfiguration;
import org.apache.james.linshare.client.Document;
import org.apache.james.linshare.client.User;

public interface LinshareAPI {
    @VisibleForTesting
    public static LinshareAPI from(LinshareConfiguration configuration) {
        return (LinshareAPI)Feign.builder().requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(configuration.getUuid().toString(), configuration.getPassword())).logger((Logger)new Slf4jLogger(LinshareAPI.class)).logLevel(Logger.Level.FULL).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).decoder((Decoder)new JacksonDecoder()).target(LinshareAPI.class, configuration.getUrl().toString());
    }

    @RequestLine(value="GET /linshare/webservice/rest/delegation/v2/users/{targetUserMail}")
    @feign.Headers(value={"Accept: application/json", "Content-Type: application/json"})
    public User getUserByMail(@Param(value="targetUserMail") String var1);

    @RequestLine(value="POST linshare/webservice/rest/delegation/v2/{userUuid}/documents")
    @feign.Headers(value={"Accept: application/json", "Content-Type: multipart/form-data"})
    public Document uploadDocumentByDelegation(@Param(value="userUuid") String var1, @Param(value="file") File var2, @Param(value="filesize") long var3);

    default public Document uploadDocumentByDelegation(User targetUser, File file) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkArgument((boolean)file.exists(), (String)"File to upload does not exist: %s", (Object)file.getAbsolutePath());
        return this.uploadDocumentByDelegation(targetUser.getUuid(), file, file.length());
    }

    public static interface Headers {
        public static final String ACCEPT_APPLICATION_JSON = "Accept: application/json";
        public static final String CONTENT_TYPE_MULTIPART = "Content-Type: multipart/form-data";
        public static final String CONTENT_TYPE_APPLICATION_JSON = "Content-Type: application/json";
    }
}

