import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { DescriptionField, TextField, TextFieldType } from "../Fields";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { useDmnEditorStore } from "../../store/StoreContext";
export function DecisionTableRootCell(props) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    const cell = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: selectedObjectId }) }), _jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Hit Policy", isReadOnly: true, initialValue: (_b = cell["@_hitPolicy"]) !== null && _b !== void 0 ? _b : "" }), cell["@_hitPolicy"] === "COLLECT" && (_jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Aggregation", isReadOnly: true, initialValue: (_c = cell["@_aggregation"]) !== null && _c !== void 0 ? _c : "<None>" })), _jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Output Label", placeholder: "Enter a output label...", isReadOnly: props.isReadOnly, initialValue: (_d = cell["@_outputLabel"]) !== null && _d !== void 0 ? _d : "", onChange: (newOutputLabel) => updater((dmnObject) => {
                    dmnObject["@_outputLabel"] = newOutputLabel;
                }), expressionPath: (_e = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _e !== void 0 ? _e : [] }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_g = (_f = cell.description) === null || _f === void 0 ? void 0 : _f.__$$text) !== null && _g !== void 0 ? _g : "", expressionPath: (_h = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _h !== void 0 ? _h : [], onChange: (newDescription) => updater((dmnObject) => {
                    var _a;
                    (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                    dmnObject.description.__$$text = newDescription;
                }) })] }));
}
//# sourceMappingURL=DecisionTableRootCell.js.map