import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button/Button";
import { SearchInput } from "@patternfly/react-core/dist/js/components/SearchInput";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { useCallback, useMemo, useState } from "react";
import { DmnObjectListItem } from "../externalNodes/DmnObjectListItem";
import { DiagramLhsPanel } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { computeContainingDecisionServiceHrefsByDecisionHrefs } from "../store/computed/computeContainingDecisionServiceHrefsByDecisionHrefs.ts";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import CubesIcon from "@patternfly/react-icons/dist/js/icons/cubes-icon";
export const MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE = "kie-dmn-editor--drg-node";
export function DrgNodesPanel() {
    const thisDmnsDrgElements = useDmnEditorStore((s) => { var _a; return (_a = s.dmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []; });
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const dmnShapesByHref = useDmnEditorStore((s) => s.computed(s).indexedDrd().dmnShapesByHref);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const [filter, setFilter] = useState("");
    const namespaceForHref = "";
    const onDragStart = useCallback((event, drgElement) => {
        event.dataTransfer.setData(MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE, JSON.stringify(drgElement));
        event.dataTransfer.effectAllowed = "move";
    }, []);
    const containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn = useMemo(() => computeContainingDecisionServiceHrefsByDecisionHrefs({
        drgElementsByNamespace: new Map([[thisDmnsNamespace, thisDmnsDrgElements]]),
        thisDmnsNamespace: thisDmnsNamespace,
    }), [thisDmnsDrgElements, thisDmnsNamespace]);
    const nodes = thisDmnsDrgElements
        .filter((drgElement) => drgElement["@_name"].toLowerCase().includes(filter.toLowerCase()))
        .map((drgElement) => {
        var _a;
        const dmnObjectHref = buildXmlHref({ namespace: namespaceForHref, id: drgElement["@_id"] });
        const canBeIncluded = !dmnShapesByHref.has(dmnObjectHref) &&
            ((_a = containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn.get(dmnObjectHref)) !== null && _a !== void 0 ? _a : []).every((dsHref) => !dmnShapesByHref.has(dsHref));
        return (_jsx("div", { className: "kie-dmn-editor--external-nodes-list-item", draggable: canBeIncluded, style: {
                opacity: canBeIncluded ? undefined : 0.4,
                userSelect: "none",
            }, onDragStart: (event) => onDragStart(event, drgElement), children: _jsx(Flex, { alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentFlexStart" }, spaceItems: { default: "spaceItemsNone" }, children: _jsx(DmnObjectListItem, { dmnObjectHref: dmnObjectHref, dmnObject: drgElement, namespace: namespaceForHref, relativeToNamespace: namespaceForHref }) }) }, drgElement["@_id"]));
    });
    return (_jsx(_Fragment, { children: (nodes.length <= 0 && (_jsx(_Fragment, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, { size: "md", headingLevel: "h4", children: "No DRG nodes yet" }), _jsx(EmptyStateBody, { children: "Use the Palette on the left-hand-side to drag new nodes into the Diagram." })] }) }))) || (_jsxs(_Fragment, { children: [_jsxs("div", { className: "kie-dmn-editor--sticky-top-glass-header", style: { padding: "12px" }, children: [_jsxs(Flex, { justifyContent: { default: "justifyContentSpaceBetween" }, children: [_jsx(TextContent, { children: _jsx(Text, { component: "h3", children: "DRG Nodes" }) }), _jsx(Button, { title: "Close", variant: ButtonVariant.plain, onClick: () => dmnEditorStoreApi.setState((state) => {
                                        state.diagram.openLhsPanel = DiagramLhsPanel.NONE;
                                    }), children: _jsx(TimesIcon, {}) })] }), _jsx(Divider, { style: { marginBottom: "12px" } }), _jsx(SearchInput, { style: { marginBottom: "12px", height: "36px" }, onKeyDown: (e) => e.stopPropagation(), autoFocus: true, placeholder: "Filter...", value: filter, onChange: (_event, value) => setFilter(value), onClear: () => setFilter("") })] }), _jsx("div", { style: { padding: "12px" }, children: nodes })] })) }));
}
//# sourceMappingURL=DrgNodesPanel.js.map