import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import "./OutputFieldRow.scss";
import { OutputLabelsEditMode } from "../atoms";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import useOnclickOutside from "react-cool-onclickoutside";
import { Operation, useOperation } from "../../EditorScorecard";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
const dataTypes = [
    "string",
    "integer",
    "float",
    "double",
    "boolean",
    "date",
    "time",
    "dateTime",
    "dateDaysSince[0]",
    "dateDaysSince[1960]",
    "dateDaysSince[1970]",
    "dateDaysSince[1980]",
    "timeSeconds",
    "dateTimeSecondsSince[0]",
    "dateTimeSecondsSince[1960]",
    "dateTimeSecondsSince[1970]",
    "dateTimeSecondsSince[1980]",
];
const OutputFieldEditRow = (props) => {
    var _a, _b, _c;
    const { modelIndex, outputField, outputFieldIndex, validateOutputName, viewExtendedProperties, onCommitAndClose, onCommit, onCancel, } = props;
    const { activeOperation } = useOperation();
    const [name, setName] = useState({ value: "", valid: false });
    const [dataType, setDataType] = useState("boolean");
    const [optype, setOptype] = useState();
    const [targetField, setTargetField] = useState();
    const [feature, setFeature] = useState();
    const [value, setValue] = useState();
    const [rank, setRank] = useState();
    const [rankOrder, setRankOrder] = useState();
    const [segmentId, setSegmentId] = useState();
    const [isFinalResult, setIsFinalResult] = useState();
    useEffect(() => {
        if (outputField === undefined) {
            return;
        }
        setName({
            value: outputField.name,
            valid: validateOutputName(outputField.name),
        });
        setDataType(outputField.dataType);
        setOptype(outputField.optype);
        setTargetField(outputField.targetField);
        setFeature(outputField.feature);
        setValue(outputField.value);
        setRank(outputField.rank);
        setRankOrder(outputField.rankOrder);
        setSegmentId(outputField.segmentId);
        setIsFinalResult(outputField.isFinalResult);
    }, [props]);
    const [isTypeSelectOpen, setIsTypeSelectOpen] = useState(false);
    const typeToggle = (isOpen) => {
        setIsTypeSelectOpen(isOpen);
    };
    const ref = useOnclickOutside(() => {
        if (name === null || name === void 0 ? void 0 : name.valid) {
            onCommitAndClose();
        }
        else {
            onCancel();
        }
    }, {
        disabled: activeOperation !== Operation.UPDATE_OUTPUT,
        eventTypes: ["click"],
    });
    const { validationRegistry } = useValidationRegistry();
    const targetFieldValidation = useMemo(() => validationRegistry.get(Builder().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build()), [outputFieldIndex, modelIndex, outputField]);
    return (_jsx("section", { className: "editable-item__inner", ref: ref, tabIndex: 0, onKeyDown: (e) => {
            if (e.key === "Escape") {
                onCancel();
            }
        }, children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(FormGroup, { label: "Name", fieldId: "output-name-helper", isRequired: true, helperTextInvalid: "Name is mandatory and must be unique", helperTextInvalidIcon: _jsx(ExclamationCircleIcon, {}), validated: (name === null || name === void 0 ? void 0 : name.valid) ? "default" : "error", children: _jsx(TextInput, { type: "text", id: "output-name", name: "output-name", "aria-describedby": "output-name-helper", value: (_b = (_a = name === null || name === void 0 ? void 0 : name.value) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : "", placeholder: "Name", validated: (name === null || name === void 0 ? void 0 : name.valid) ? "default" : "error", autoFocus: true, onChange: (e) => {
                                            setName({
                                                value: e,
                                                valid: validateOutputName(e),
                                            });
                                        }, onBlur: (e) => {
                                            if (name === null || name === void 0 ? void 0 : name.valid) {
                                                onCommit({
                                                    name: name.value,
                                                });
                                            }
                                            else {
                                                setName({
                                                    value: outputField === null || outputField === void 0 ? void 0 : outputField.name,
                                                    valid: validateOutputName(outputField.name),
                                                });
                                            }
                                        }, ouiaId: "set-output-field-name" }) }) }), _jsx(SplitItem, { isFilled: true, children: _jsx(FormGroup, { label: "Data type", fieldId: "output-dataType-helper", style: { width: "12em" }, isRequired: true, "data-ouia-component-id": "select-output-field-type", children: _jsx(Select, { id: "output-dataType", name: "output-dataType", "aria-label": "Select Input", "aria-describedby": "output-dataType-helper", className: "ignore-onclickoutside", variant: SelectVariant.single, onToggle: typeToggle, onSelect: (event, selection, isPlaceholder) => {
                                            setIsTypeSelectOpen(false);
                                            setDataType(isPlaceholder ? undefined : selection);
                                            onCommit({
                                                dataType: isPlaceholder ? undefined : selection,
                                            });
                                        }, selections: dataType, isOpen: isTypeSelectOpen, placeholder: "Type", menuAppendTo: "parent", children: dataTypes.map((dt, _index) => (_jsx(SelectOption, { value: dt, "data-ouia-component-type": "select-option" }, _index))) }) }) })] }) }), _jsx(StackItem, { children: _jsx(Split, { children: _jsx(SplitItem, { children: _jsx(FormGroup, { label: "Properties", fieldId: "output-labels-helper", children: _jsx(OutputLabelsEditMode, { optype: optype, setOptype: setOptype, targetField: targetField, setTargetField: setTargetField, targetFieldValidation: targetFieldValidation, feature: feature, setFeature: setFeature, value: value, setValue: setValue, rank: rank, setRank: setRank, rankOrder: rankOrder, setRankOrder: setRankOrder, segmentId: segmentId, setSegmentId: setSegmentId, isFinalResult: isFinalResult, setIsFinalResult: setIsFinalResult, viewExtendedProperties: viewExtendedProperties, commit: onCommit, isDisabled: (_c = !(name === null || name === void 0 ? void 0 : name.valid)) !== null && _c !== void 0 ? _c : true }) }) }) }) })] }) }));
};
export default OutputFieldEditRow;
//# sourceMappingURL=OutputFieldEditRow.js.map