import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useContext, useEffect, useRef, useState } from "react";
import { SortableContainer, SortableElement } from "react-sortable-hoc";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { GripVerticalIcon } from "@patternfly/react-icons/dist/js/icons/grip-vertical-icon";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import "./ConstraintsEnumEdit.scss";
const ConstraintsEnumEdit = (props) => {
    const { dataFieldIndex, enumerations, onAdd, onChange, onDelete, onSort } = props;
    const [enums, setEnums] = useState(enumerations);
    const [addedEnum, setAddedEnum] = useState();
    const handleChange = (value, index) => {
        onChange(value, index);
    };
    const handleDelete = (index) => {
        onDelete(index);
    };
    const addOne = () => {
        onAdd();
        setAddedEnum(enums.length);
    };
    const handleTab = () => {
        console.log("tab detected");
    };
    const onSortEnd = ({ oldIndex, newIndex }) => {
        onSort(oldIndex, newIndex);
    };
    useEffect(() => {
        setEnums(enumerations);
    }, [enumerations]);
    return (_jsx(EnumConstraintsContext.Provider, { value: {
            addedEnum: addedEnum,
            updateAddedEnum: (position) => {
                setAddedEnum(position);
            },
            dataFieldIndex: dataFieldIndex,
        }, children: _jsx("section", { className: "constraints-enum", children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsx(TextContent, { children: _jsx(Text, { component: TextVariants.small, children: "Add constraints values to limit and define valid inputs for the data type." }) }) }), _jsx(StackItem, { children: _jsx(EnumsList, { items: enums, onUpdate: handleChange, onTab: handleTab, onDelete: handleDelete, onSortEnd: onSortEnd, lockAxis: "y", distance: 10 }) }), _jsx(StackItem, { children: _jsx(Button, { variant: ButtonVariant.secondary, onClick: addOne, ouiaId: "add-another-value", children: "Add another value" }) })] }) }) }));
};
export default ConstraintsEnumEdit;
const EnumsList = SortableContainer(({ items, onUpdate, onTab, onDelete, }) => {
    return (_jsx("ul", { className: "constraints-enum__list", "aria-label": "Compact data list example", children: items.map((item, index) => (_jsx(EnumItem, { enumValue: item, index: index, position: index, onUpdate: onUpdate, onTab: onTab, onDelete: onDelete, enumsCount: items.length, disabled: items.length === 1 }, index + item))) }));
});
const EnumItem = SortableElement(({ enumValue, enumsCount, position, onUpdate, onTab, onDelete }) => {
    const [enumeration, setEnumeration] = useState(enumValue);
    const { dataFieldIndex, addedEnum, updateAddedEnum } = useContext(EnumConstraintsContext);
    const handleChange = (value) => {
        setEnumeration(value);
    };
    const handleSave = () => {
        onUpdate(enumeration, position);
    };
    const handleDelete = () => {
        onDelete(position);
    };
    const handleTabNavigation = (event) => {
        if (event.key === "Tab") {
            onTab();
        }
    };
    const { validationRegistry } = useValidationRegistry();
    const validations = useRef(validationRegistry.get(Builder().forDataDictionary().forDataField(dataFieldIndex).forValue(position).build()));
    useEffect(() => {
        validations.current = validationRegistry.get(Builder().forDataDictionary().forDataField(dataFieldIndex).forValue(position).build());
    }, [position, enumValue]);
    const enumRef = useRef(null);
    useEffect(() => {
        if (enumRef.current && addedEnum === position) {
            const container = document.querySelector(".data-dictionary__properties-edit__form .constraints__form");
            container === null || container === void 0 ? void 0 : container.scroll({ top: container === null || container === void 0 ? void 0 : container.scrollHeight, behavior: "smooth" });
            updateAddedEnum(undefined);
        }
    }, [addedEnum, enumRef.current, position]);
    return (_jsx("li", { className: `constraints-enum__item ${enumsCount === 1 ? "constraints-enum__item--sort-disabled" : ""}`, tabIndex: 20 + position, ref: enumRef, "data-ouia-component-id": `val-${position}`, children: _jsxs(Flex, { children: [_jsx(FlexItem, { children: _jsx(Button, { variant: "plain", "aria-label": "Drag to sort", component: "span", isDisabled: enumsCount === 1, ouiaId: "drag-it", children: _jsx(GripVerticalIcon, {}) }) }), _jsx(FlexItem, { children: _jsx(TextInput, { className: "constraints-enum__field", type: "text", id: `enum-value-${position}`, name: `enum-value-${position}`, placeholder: "Please enter a value", value: enumeration, onChange: handleChange, onBlur: handleSave, onKeyDown: handleTabNavigation, autoComplete: "off", validated: validations.current.length > 0 ? "warning" : "default", "data-ouia-component-type": "value-name" }) }), _jsx(FlexItem, { align: { default: "alignRight" }, children: _jsx(Button, { variant: ButtonVariant.plain, onClick: handleDelete, isDisabled: enumsCount === 1, ouiaId: "delete-item", children: _jsx(TrashIcon, {}) }) })] }) }));
});
const EnumConstraintsContext = React.createContext({
    addedEnum: undefined,
    updateAddedEnum: () => null,
    dataFieldIndex: undefined,
});
//# sourceMappingURL=ConstraintsEnumEdit.js.map