import { MessageBusClientApi } from "@kie-tools-core/envelope-bus/dist/api";
import { Job, JobStatus, BulkCancel, JobCancel, JobsSortBy } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { JobsManagementChannelApi, JobsManagementDriver } from "../api";
export default class JobsManagementEnvelopeViewDriver implements JobsManagementDriver {
    private readonly channelApi;
    constructor(channelApi: MessageBusClientApi<JobsManagementChannelApi>);
    initialLoad(filter: JobStatus[], orderBy: JobsSortBy): Promise<void>;
    applyFilter(filter: JobStatus[]): Promise<void>;
    bulkCancel(jobsToBeActioned: Job[]): Promise<BulkCancel>;
    cancelJob(job: Pick<Job, "id" | "endpoint">): Promise<JobCancel>;
    rescheduleJob(job: any, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    sortBy(orderBy: JobsSortBy): Promise<void>;
    query(offset: number, limit: number): Promise<Job[]>;
}
//# sourceMappingURL=JobsManagementEnvelopeViewDriver.d.ts.map