import { CompletionItemKind, InsertTextFormat, Range } from "vscode-languageserver-types";
import { dashbuilderCompletion } from "../assets/code-completions/";
export const DashbuilderLanguageServiceCodeCompletion = {
    getEmptyFileCodeCompletions(args) {
        const kind = CompletionItemKind.Text;
        const label = "Create your first dashboard";
        return Promise.resolve([
            {
                kind,
                label,
                detail: "Start with a simple dashboard",
                sortText: `100_${label}`,
                textEdit: {
                    newText: args.codeCompletionStrategy.translate({
                        ...args,
                        completion: dashbuilderCompletion,
                        completionItemKind: kind,
                    }),
                    range: Range.create(args.cursorPosition, args.cursorPosition),
                },
                insertTextFormat: InsertTextFormat.Snippet,
            },
        ]);
    },
};
//# sourceMappingURL=DashbuilderLanguageServiceCodeCompletion.js.map