import { jsx as _jsx } from "react/jsx-runtime";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { ProcessInstanceIconCreator } from "../utils/ProcessListUtils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ErrorPopover = ({ processInstanceData, onSkipClick, onRetryClick, ouiaId, ouiaSafe, }) => {
    var _a;
    return (_jsx(Popover, { zIndex: 300, id: processInstanceData.id, headerContent: _jsx("div", { children: "Process error" }), bodyContent: _jsx("div", { children: processInstanceData.error ? processInstanceData.error.message : "No error message found" }), footerContent: ((_a = processInstanceData.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) &&
            processInstanceData.serviceUrl && [
            _jsx(Button, { id: "skip-button", "data-testid": "skip-button", variant: "secondary", onClick: () => onSkipClick(processInstanceData), className: "pf-u-mr-sm", children: "Skip" }, "confirm1"),
            _jsx(Button, { variant: "secondary", id: "retry-button", "data-testid": "retry-button", onClick: () => onRetryClick(processInstanceData), className: "pf-u-mr-sm", children: "Retry" }, "confirm2"),
        ], position: "auto", ...componentOuiaProps(ouiaId, "error-popover", ouiaSafe), children: _jsx(Button, { variant: "link", isInline: true, "data-testid": "error-state", children: ProcessInstanceIconCreator(processInstanceData.state) }) }));
};
export default ErrorPopover;
//# sourceMappingURL=ErrorPopover.js.map