import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useState } from "react";
import { DropdownItem, Dropdown, KebabToggle } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { handleJobRescheduleUtil, jobCancel } from "../../../utils/Utils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { JobsDetailsModal } from "../../../../jobsManagement/envelope/components/JobsDetailsModal";
import { JobsRescheduleModal } from "../../../../jobsManagement/envelope/components/JobsRescheduleModal";
import { JobsCancelModal } from "../../../../jobsManagement/envelope/components/JobsCancelModal";
const JobActionsKebab = ({ job, driver, ouiaId, ouiaSafe }) => {
    const [isKebabOpen, setIsKebabOpen] = useState(false);
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [rescheduleError, setRescheduleError] = useState("");
    const [isCancelModalOpen, setIsCancelModalOpen] = useState(false);
    const [isRescheduleModalOpen, setIsRescheduleModalOpen] = useState(false);
    const [modalTitle, setModalTitle] = useState();
    const [modalContent, setModalContent] = useState("");
    const RescheduleJobs = ["SCHEDULED", "ERROR"];
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const handleCancelModalToggle = () => {
        setIsCancelModalOpen(!isCancelModalOpen);
    };
    const onSelect = () => {
        setIsKebabOpen(!isKebabOpen);
    };
    const onToggle = (isOpen) => {
        setIsKebabOpen(isOpen);
    };
    const onDetailsClick = () => {
        handleModalToggle();
    };
    const handleRescheduleAction = () => {
        setIsRescheduleModalOpen(!isRescheduleModalOpen);
    };
    const handleJobReschedule = async (_job, repeatInterval, repeatLimit, scheduleDate) => {
        await handleJobRescheduleUtil(repeatInterval, repeatLimit, scheduleDate, job, handleRescheduleAction, driver, setRescheduleError);
    };
    const handleCancelAction = async () => {
        await jobCancel(driver, job, setModalTitle, setModalContent);
        handleCancelModalToggle();
    };
    const rescheduleActions = [
        _jsx(Button, { variant: "secondary", onClick: handleRescheduleAction, children: "Cancel" }, "cancel-reschedule"),
    ];
    const detailsAction = [
        _jsx(Button, { variant: "primary", onClick: handleModalToggle, children: "OK" }, "confirm-selection"),
    ];
    const dropdownItems = () => {
        if (job.endpoint !== null && RescheduleJobs.includes(job.status)) {
            return [
                _jsx(DropdownItem, { "data-testid": "job-details", component: "button", onClick: onDetailsClick, children: "Details" }, "details"),
                _jsx(DropdownItem, { "data-testid": "job-reschedule", component: "button", id: "reschedule-option", onClick: handleRescheduleAction, children: "Reschedule" }, "reschedule"),
                _jsx(DropdownItem, { "data-testid": "job-cancel", component: "button", id: "cancel-option", onClick: handleCancelAction, children: "Cancel" }, "cancel"),
            ];
        }
        else {
            return [
                _jsx(DropdownItem, { "data-testid": "job-details", component: "button", onClick: onDetailsClick, children: "Details" }, "details"),
            ];
        }
    };
    return (_jsxs(_Fragment, { children: [_jsx(JobsDetailsModal, { actionType: "Job Details", modalTitle: setTitle("success", "Job Details"), isModalOpen: isModalOpen, handleModalToggle: handleModalToggle, modalAction: detailsAction, job: job }), _jsx(JobsRescheduleModal, { actionType: "Job Reschedule", isModalOpen: isRescheduleModalOpen, handleModalToggle: handleRescheduleAction, modalAction: rescheduleActions, job: job, rescheduleError: rescheduleError, setRescheduleError: setRescheduleError, handleJobReschedule: handleJobReschedule }), _jsx(JobsCancelModal, { actionType: "Job Cancel", isModalOpen: isCancelModalOpen, handleModalToggle: handleCancelModalToggle, modalTitle: modalTitle, modalContent: modalContent }), _jsx(Dropdown, { onSelect: onSelect, toggle: _jsx(KebabToggle, { onToggle: onToggle, id: "kebab-toggle" }), isOpen: isKebabOpen, isPlain: true, position: "right", "aria-label": "Job actions dropdown", "aria-labelledby": "Job actions dropdown", dropdownItems: dropdownItems(), ...componentOuiaProps(ouiaId, "job-actions-kebab", ouiaSafe) })] }));
};
export default JobActionsKebab;
//# sourceMappingURL=JobActionsKebab.js.map