export class ProcessListGatewayApiImpl {
    constructor(queries) {
        this.onOpenProcessListeners = [];
        this.onUpdateProcessListStateListeners = [];
        this.openProcess = (process) => {
            this.onOpenProcessListeners.forEach((listener) => listener.onOpen(process));
            return Promise.resolve();
        };
        this.initialLoad = (filter, sortBy) => {
            this._ProcessListState.filters = filter;
            this._ProcessListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.applyFilter = (filter) => {
            this.processListState.filters = filter;
            this.onUpdateProcessListStateListeners.forEach((listener) => listener.onUpdate(this.processListState));
            return Promise.resolve();
        };
        this.applySorting = (sortBy) => {
            this._ProcessListState.sortBy = sortBy;
            this.onUpdateProcessListStateListeners.forEach((listener) => listener.onUpdate(this.processListState));
            return Promise.resolve();
        };
        this.handleProcessSkip = async (processInstance) => {
            return this.queries.handleProcessSkip(processInstance);
        };
        this.handleProcessRetry = async (processInstance) => {
            return this.queries.handleProcessRetry(processInstance);
        };
        this.handleProcessAbort = async (processInstance) => {
            return this.queries.handleProcessAbort(processInstance);
        };
        this.handleProcessMultipleAction = async (processInstances, operationType) => {
            return this.queries.handleProcessMultipleAction(processInstances, operationType);
        };
        this.queries = queries;
        this._ProcessListState = {
            filters: {
                status: [],
                businessKey: [],
            },
            sortBy: {},
        };
    }
    get processListState() {
        return this._ProcessListState;
    }
    query(offset, limit) {
        return new Promise((resolve, reject) => {
            this.queries
                .getProcessInstances(offset, limit, this._ProcessListState.filters, this._ProcessListState.sortBy)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    getChildProcessesQuery(rootProcessInstanceId) {
        return new Promise((resolve, reject) => {
            this.queries
                .getChildProcessInstances(rootProcessInstanceId)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    onOpenProcessListen(listener) {
        this.onOpenProcessListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onOpenProcessListeners.indexOf(listener);
            if (index > -1) {
                this.onOpenProcessListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    onUpdateProcessListState(listener) {
        this.onUpdateProcessListStateListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onUpdateProcessListStateListeners.indexOf(listener);
            if (index > -1) {
                this.onUpdateProcessListStateListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    openTriggerCloudEvent(processInstance) {
        console.info("not supported");
    }
}
//# sourceMappingURL=ProcessListGatewayApi.js.map