"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceService = void 0;
var EncoderDecoder_1 = require("../encoderdecoder/EncoderDecoder");
var client_zip_1 = require("client-zip");
var StorageService_1 = require("./StorageService");
var path_1 = require("path");
var minimatch_1 = require("minimatch");
var WorkspacesBroadcastEvents_1 = require("../worker/api/WorkspacesBroadcastEvents");
var WorkspaceFileRelativePathParser_1 = require("../relativePath/WorkspaceFileRelativePathParser");
var WorkspaceService = (function () {
    function WorkspaceService(storageService, descriptorsFsService, workspaceDescriptorService, fsService) {
        this.storageService = storageService;
        this.descriptorsFsService = descriptorsFsService;
        this.workspaceDescriptorService = workspaceDescriptorService;
        this.fsService = fsService;
    }
    WorkspaceService.prototype.create = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var workspace, e_1;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.descriptorsFsService.withReadWriteInMemoryFs(function (_a) {
                            var fs = _a.fs;
                            return _this.workspaceDescriptorService.create({
                                fs: fs,
                                origin: args.origin,
                                preferredName: args.preferredName,
                                gitAuthSessionId: args.gitAuthSessionId,
                                gitInsecurelyDisableTlsCertificateValidation: args.gitInsecurelyDisableTlsCertificateValidation,
                            });
                        })];
                    case 1:
                        workspace = _a.sent();
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 6]);
                        return [4, this.fsService.withReadWriteInMemoryFs(workspace.workspaceId, function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var files;
                                var _this = this;
                                var fs = _b.fs, schema = _b.schema, broadcaster = _b.broadcaster;
                                return __generator(this, function (_c) {
                                    switch (_c.label) {
                                        case 0: return [4, args.storeFiles(fs, schema, workspace)];
                                        case 1:
                                            files = _c.sent();
                                            broadcaster.broadcast({
                                                channel: WorkspacesBroadcastEvents_1.WORKSPACES_BROADCAST_CHANNEL,
                                                message: function () { return __awaiter(_this, void 0, void 0, function () {
                                                    return __generator(this, function (_a) {
                                                        return [2, ({
                                                                type: "WSS_ADD_WORKSPACE",
                                                                workspaceId: workspace.workspaceId,
                                                            })];
                                                    });
                                                }); },
                                            });
                                            broadcaster.broadcast({
                                                channel: workspace.workspaceId,
                                                message: function () { return __awaiter(_this, void 0, void 0, function () {
                                                    return __generator(this, function (_a) {
                                                        return [2, ({
                                                                type: "WS_ADD",
                                                                workspaceId: workspace.workspaceId,
                                                            })];
                                                    });
                                                }); },
                                            });
                                            return [2, { workspace: workspace, files: files }];
                                    }
                                });
                            }); })];
                    case 3: return [2, _a.sent()];
                    case 4:
                        e_1 = _a.sent();
                        return [4, this.delete(workspace.workspaceId)];
                    case 5:
                        _a.sent();
                        throw e_1;
                    case 6: return [2];
                }
            });
        });
    };
    WorkspaceService.prototype.getFilteredWorkspaceFileDescriptors = function (schema, workspaceId, globPattern) {
        return __awaiter(this, void 0, void 0, function () {
            var matcher, gitDirAbsolutePath;
            var _this = this;
            return __generator(this, function (_a) {
                matcher = globPattern ? new minimatch_1.Minimatch(globPattern, { dot: true }) : undefined;
                gitDirAbsolutePath = this.getAbsolutePath({ workspaceId: workspaceId, relativePath: ".git" });
                return [2, this.storageService.walk({
                        schema: schema,
                        baseAbsolutePath: this.getAbsolutePath({ workspaceId: workspaceId }),
                        shouldExcludeAbsolutePath: function (absolutePath) { return absolutePath.startsWith(gitDirAbsolutePath); },
                        onVisit: function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                            var relativePath = _b.relativePath;
                            return __generator(this, function (_c) {
                                if (matcher && !matcher.match((0, path_1.basename)(relativePath))) {
                                    return [2, undefined];
                                }
                                else {
                                    return [2, { workspaceId: workspaceId, relativePath: relativePath }];
                                }
                                return [2];
                            });
                        }); },
                    })];
            });
        });
    };
    WorkspaceService.prototype.delete = function (workspaceId) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.descriptorsFsService.withReadWriteInMemoryFs(function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                            var _this = this;
                            var fs = _b.fs, broadcaster = _b.broadcaster;
                            return __generator(this, function (_c) {
                                switch (_c.label) {
                                    case 0: return [4, this.workspaceDescriptorService.delete(fs, workspaceId)];
                                    case 1:
                                        _c.sent();
                                        indexedDB.deleteDatabase(this.fsService.getFsMountPoint(workspaceId));
                                        indexedDB.deleteDatabase(this.fsService.getFsSchemaMountPoint(workspaceId));
                                        broadcaster.broadcast({
                                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_BROADCAST_CHANNEL,
                                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                                return [2, ({ type: "WSS_DELETE_WORKSPACE", workspaceId: workspaceId })];
                                            }); }); },
                                        });
                                        broadcaster.broadcast({
                                            channel: workspaceId,
                                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                                return [2, ({ type: "WS_DELETE", workspaceId: workspaceId })];
                                            }); }); },
                                        });
                                        return [2];
                                }
                            });
                        }); })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    WorkspaceService.prototype.rename = function (workspaceId, newName) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.descriptorsFsService.withReadWriteInMemoryFs(function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                            var _this = this;
                            var fs = _b.fs, broadcaster = _b.broadcaster;
                            return __generator(this, function (_c) {
                                switch (_c.label) {
                                    case 0: return [4, this.workspaceDescriptorService.rename(fs, workspaceId, newName)];
                                    case 1:
                                        _c.sent();
                                        return [4, this.workspaceDescriptorService.bumpLastUpdatedDate(fs, workspaceId)];
                                    case 2:
                                        _c.sent();
                                        broadcaster.broadcast({
                                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_BROADCAST_CHANNEL,
                                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                                return [2, ({ type: "WSS_RENAME_WORKSPACE", workspaceId: workspaceId })];
                                            }); }); },
                                        });
                                        broadcaster.broadcast({
                                            channel: workspaceId,
                                            message: function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                                return [2, ({ type: "WS_RENAME", workspaceId: workspaceId })];
                                            }); }); },
                                        });
                                        return [2];
                                }
                            });
                        }); })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    WorkspaceService.prototype.prepareZip = function (fs, schema, workspaceId, onlyExtensions, globPattern) {
        return __awaiter(this, void 0, void 0, function () {
            var wwfds, filesToZip;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.getFilteredWorkspaceFileDescriptors(schema, workspaceId, globPattern)];
                    case 1:
                        wwfds = _a.sent();
                        return [4, Promise.all(wwfds
                                .filter(function (wwfd) { return !onlyExtensions || onlyExtensions.includes((0, WorkspaceFileRelativePathParser_1.extractExtension)(wwfd.relativePath)); })
                                .map(function (wwfd) { return __awaiter(_this, void 0, void 0, function () {
                                var _a;
                                return __generator(this, function (_b) {
                                    switch (_b.label) {
                                        case 0:
                                            _a = {
                                                relativePath: wwfd.relativePath
                                            };
                                            return [4, this.storageService.getFileContent(fs, this.getAbsolutePath(wwfd))];
                                        case 1: return [2, (_a.content = _b.sent(),
                                                _a)];
                                    }
                                });
                            }); }))];
                    case 2:
                        filesToZip = (_a.sent()).map(function (file) { return ({ name: file.relativePath, input: file.content }); });
                        return [2, (0, client_zip_1.downloadZip)(filesToZip, { length: (0, client_zip_1.predictLength)(filesToZip) }).blob()];
                }
            });
        });
    };
    WorkspaceService.prototype.createOrOverwriteFile = function (fs, file, broadcaster) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.createOrOverwriteFile(fs, this.toStorageFile(file, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                            return [2, file.content];
                        }); }); }))];
                    case 1:
                        _a.sent();
                        return [4, this.descriptorsFsService.withReadWriteInMemoryFs(function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var fs = _b.fs;
                                return __generator(this, function (_c) {
                                    switch (_c.label) {
                                        case 0: return [4, this.workspaceDescriptorService.bumpLastUpdatedDate(fs, file.workspaceId)];
                                        case 1:
                                            _c.sent();
                                            return [2];
                                    }
                                });
                            }); })];
                    case 2:
                        _a.sent();
                        broadcaster.broadcast({
                            channel: file.workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WS_ADD_FILE",
                                            relativePath: file.relativePath,
                                        })];
                                });
                            }); },
                        });
                        broadcaster.broadcast({
                            channel: this.getUniqueFileIdentifier(file),
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSF_ADD",
                                            relativePath: file.relativePath,
                                        })];
                                });
                            }); },
                        });
                        broadcaster.broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_FILES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSSFS_ADD",
                                            workspaceId: file.workspaceId,
                                            relativePath: file.relativePath,
                                        })];
                                });
                            }); },
                        });
                        return [2];
                }
            });
        });
    };
    WorkspaceService.prototype.getFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var absolutePath, storageFile;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        absolutePath = this.getAbsolutePath(args);
                        return [4, this.storageService.getFile(args.fs, absolutePath)];
                    case 1:
                        storageFile = _a.sent();
                        if (!storageFile) {
                            return [2];
                        }
                        return [2, this.toWorkspaceFile(args.workspaceId, storageFile)];
                }
            });
        });
    };
    WorkspaceService.prototype.updateFile = function (fs, wwfd, getNewContents, broadcaster) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.updateFile(fs, this.getAbsolutePath(wwfd), function () {
                            return getNewContents().then(function (c) { return EncoderDecoder_1.encoder.encode(c); });
                        })];
                    case 1:
                        _a.sent();
                        return [4, this.descriptorsFsService.withReadWriteInMemoryFs(function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var fs = _b.fs;
                                return __generator(this, function (_c) {
                                    switch (_c.label) {
                                        case 0: return [4, this.workspaceDescriptorService.bumpLastUpdatedDate(fs, wwfd.workspaceId)];
                                        case 1:
                                            _c.sent();
                                            return [2];
                                    }
                                });
                            }); })];
                    case 2:
                        _a.sent();
                        broadcaster.broadcast({
                            channel: this.getUniqueFileIdentifier(wwfd),
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSF_UPDATE",
                                            relativePath: wwfd.relativePath,
                                        })];
                                });
                            }); },
                        });
                        broadcaster.broadcast({
                            channel: wwfd.workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WS_UPDATE_FILE",
                                            relativePath: wwfd.relativePath,
                                        })];
                                });
                            }); },
                        });
                        broadcaster.broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_FILES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSSFS_UPDATE",
                                            workspaceId: wwfd.workspaceId,
                                            relativePath: wwfd.relativePath,
                                        })];
                                });
                            }); },
                        });
                        return [2];
                }
            });
        });
    };
    WorkspaceService.prototype.deleteFile = function (fs, wwfd, broadcaster) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.deleteFile(fs, this.toExistingStorageFile(fs, wwfd).path)];
                    case 1:
                        _a.sent();
                        return [4, this.descriptorsFsService.withReadWriteInMemoryFs(function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var fs = _b.fs;
                                return __generator(this, function (_c) {
                                    switch (_c.label) {
                                        case 0: return [4, this.workspaceDescriptorService.bumpLastUpdatedDate(fs, wwfd.workspaceId)];
                                        case 1:
                                            _c.sent();
                                            return [2];
                                    }
                                });
                            }); })];
                    case 2:
                        _a.sent();
                        broadcaster.broadcast({
                            channel: this.getUniqueFileIdentifier(wwfd),
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSF_DELETE",
                                            relativePath: wwfd.relativePath,
                                        })];
                                });
                            }); },
                        });
                        broadcaster.broadcast({
                            channel: wwfd.workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WS_DELETE_FILE",
                                            relativePath: wwfd.relativePath,
                                        })];
                                });
                            }); },
                        });
                        broadcaster.broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_FILES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSSFS_DELETE",
                                            workspaceId: wwfd.workspaceId,
                                            relativePath: wwfd.relativePath,
                                        })];
                                });
                            }); },
                        });
                        return [2];
                }
            });
        });
    };
    WorkspaceService.prototype.renameFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var renamedStorageFile, renamedWorkspaceFile;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.renameFile(args.fs, this.toExistingStorageFile(args.fs, args.wwfd), args.newFileNameWithoutExtension)];
                    case 1:
                        renamedStorageFile = _a.sent();
                        return [4, this.toWorkspaceFile(args.wwfd.workspaceId, renamedStorageFile)];
                    case 2:
                        renamedWorkspaceFile = _a.sent();
                        return [4, this.descriptorsFsService.withReadWriteInMemoryFs(function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var fs = _b.fs;
                                return __generator(this, function (_c) {
                                    switch (_c.label) {
                                        case 0: return [4, this.workspaceDescriptorService.bumpLastUpdatedDate(fs, args.wwfd.workspaceId)];
                                        case 1:
                                            _c.sent();
                                            return [2];
                                    }
                                });
                            }); })];
                    case 3:
                        _a.sent();
                        args.broadcaster.broadcast({
                            channel: this.getUniqueFileIdentifier(args.wwfd),
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSF_RENAME",
                                            oldRelativePath: args.wwfd.relativePath,
                                            newRelativePath: renamedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        args.broadcaster.broadcast({
                            channel: this.getUniqueFileIdentifier(renamedWorkspaceFile),
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSF_ADD",
                                            relativePath: renamedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        args.broadcaster.broadcast({
                            channel: args.wwfd.workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WS_RENAME_FILE",
                                            oldRelativePath: args.wwfd.relativePath,
                                            newRelativePath: renamedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        args.broadcaster.broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_FILES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSSFS_RENAME",
                                            workspaceId: args.wwfd.workspaceId,
                                            oldRelativePath: args.wwfd.relativePath,
                                            newRelativePath: renamedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        args.broadcaster.broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_FILES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSSFS_ADD",
                                            workspaceId: args.wwfd.workspaceId,
                                            relativePath: renamedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        return [2, renamedWorkspaceFile];
                }
            });
        });
    };
    WorkspaceService.prototype.moveFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var movedStorageFile, movedWorkspaceFile;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.storageService.moveFile(args.fs, this.toExistingStorageFile(args.fs, args.wwfd), this.getAbsolutePath({ workspaceId: args.wwfd.workspaceId, relativePath: args.newDirPath }))];
                    case 1:
                        movedStorageFile = _a.sent();
                        return [4, this.toWorkspaceFile(args.wwfd.workspaceId, movedStorageFile)];
                    case 2:
                        movedWorkspaceFile = _a.sent();
                        return [4, this.descriptorsFsService.withReadWriteInMemoryFs(function (_a) { return __awaiter(_this, [_a], void 0, function (_b) {
                                var fs = _b.fs;
                                return __generator(this, function (_c) {
                                    switch (_c.label) {
                                        case 0: return [4, this.workspaceDescriptorService.bumpLastUpdatedDate(fs, args.wwfd.workspaceId)];
                                        case 1:
                                            _c.sent();
                                            return [2];
                                    }
                                });
                            }); })];
                    case 3:
                        _a.sent();
                        args.broadcaster.broadcast({
                            channel: this.getUniqueFileIdentifier(args.wwfd),
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSF_MOVE",
                                            oldRelativePath: args.wwfd.relativePath,
                                            newRelativePath: movedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        args.broadcaster.broadcast({
                            channel: this.getUniqueFileIdentifier(movedWorkspaceFile),
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSF_ADD",
                                            relativePath: movedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        args.broadcaster.broadcast({
                            channel: args.wwfd.workspaceId,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WS_MOVE_FILE",
                                            oldRelativePath: args.wwfd.relativePath,
                                            newRelativePath: movedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        args.broadcaster.broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_FILES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSSFS_MOVE",
                                            workspaceId: args.wwfd.workspaceId,
                                            oldRelativePath: args.wwfd.relativePath,
                                            newRelativePath: movedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        args.broadcaster.broadcast({
                            channel: WorkspacesBroadcastEvents_1.WORKSPACES_FILES_BROADCAST_CHANNEL,
                            message: function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    return [2, ({
                                            type: "WSSFS_ADD",
                                            workspaceId: args.wwfd.workspaceId,
                                            relativePath: movedWorkspaceFile.relativePath,
                                        })];
                                });
                            }); },
                        });
                        return [2, movedWorkspaceFile];
                }
            });
        });
    };
    WorkspaceService.prototype.existsFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.storageService.exists(args.fs, this.getAbsolutePath(args))];
            });
        });
    };
    WorkspaceService.prototype.getAbsolutePath = function (args) {
        var _a;
        return (0, path_1.join)("/", this.fsService.getFsMountPoint(args.workspaceId), (_a = args.relativePath) !== null && _a !== void 0 ? _a : "");
    };
    WorkspaceService.prototype.toWorkspaceFile = function (workspaceId, storageFile) {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = {
                            workspaceId: workspaceId
                        };
                        return [4, storageFile.getFileContents()];
                    case 1: return [2, (_a.content = _b.sent(),
                            _a.relativePath = (0, path_1.relative)(this.getAbsolutePath({ workspaceId: workspaceId }), storageFile.path),
                            _a)];
                }
            });
        });
    };
    WorkspaceService.prototype.toStorageFile = function (wwfd, getFileContents) {
        return new StorageService_1.StorageFile({
            path: this.getAbsolutePath(wwfd),
            getFileContents: getFileContents,
        });
    };
    WorkspaceService.prototype.toExistingStorageFile = function (fs, wwfd) {
        var _this = this;
        return this.toStorageFile(wwfd, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, this.storageService.getFileContent(fs, this.getAbsolutePath(wwfd))];
        }); }); });
    };
    WorkspaceService.prototype.getUniqueFileIdentifier = function (args) {
        return "".concat(args.workspaceId, "__").concat(this.getAbsolutePath(args));
    };
    return WorkspaceService;
}());
exports.WorkspaceService = WorkspaceService;
//# sourceMappingURL=WorkspaceService.js.map