/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.AlterColumnEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateTable;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;

public class AlterColumnEntry
extends UpdateTable
implements Fireable {
    private final int tableId;
    private final CatalogTableColumnDescriptor column;

    public AlterColumnEntry(int tableId, CatalogTableColumnDescriptor column) {
        this.tableId = tableId;
        this.column = column;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public CatalogTableColumnDescriptor descriptor() {
        return this.column;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ALTER_COLUMN.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new AlterColumnEventParameters(causalityToken, catalogVersion, this.tableId, this.column);
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        List<CatalogTableColumnDescriptor> updatedTableColumns = table.columns().stream().map(source -> source.name().equals(this.column.name()) ? this.column : source).collect(Collectors.toList());
        return table.copyBuilder().latestSchemaVersion(AlterColumnEntry.newSchemaVersion(table)).columns(updatedTableColumns);
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

