/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.GroupFullInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class GroupsGetInfoItem {
    private Tag _tag;
    private String idNotFoundValue;
    private GroupFullInfo groupInfoValue;

    private GroupsGetInfoItem() {
    }

    private GroupsGetInfoItem withTag(Tag _tag) {
        GroupsGetInfoItem result = new GroupsGetInfoItem();
        result._tag = _tag;
        return result;
    }

    private GroupsGetInfoItem withTagAndIdNotFound(Tag _tag, String idNotFoundValue) {
        GroupsGetInfoItem result = new GroupsGetInfoItem();
        result._tag = _tag;
        result.idNotFoundValue = idNotFoundValue;
        return result;
    }

    private GroupsGetInfoItem withTagAndGroupInfo(Tag _tag, GroupFullInfo groupInfoValue) {
        GroupsGetInfoItem result = new GroupsGetInfoItem();
        result._tag = _tag;
        result.groupInfoValue = groupInfoValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isIdNotFound() {
        return this._tag == Tag.ID_NOT_FOUND;
    }

    public static GroupsGetInfoItem idNotFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GroupsGetInfoItem().withTagAndIdNotFound(Tag.ID_NOT_FOUND, value);
    }

    public String getIdNotFoundValue() {
        if (this._tag != Tag.ID_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.ID_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.idNotFoundValue;
    }

    public boolean isGroupInfo() {
        return this._tag == Tag.GROUP_INFO;
    }

    public static GroupsGetInfoItem groupInfo(GroupFullInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GroupsGetInfoItem().withTagAndGroupInfo(Tag.GROUP_INFO, value);
    }

    public GroupFullInfo getGroupInfoValue() {
        if (this._tag != Tag.GROUP_INFO) {
            throw new IllegalStateException("Invalid tag: required Tag.GROUP_INFO, but was Tag." + this._tag.name());
        }
        return this.groupInfoValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.idNotFoundValue, this.groupInfoValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GroupsGetInfoItem) {
            GroupsGetInfoItem other = (GroupsGetInfoItem)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ID_NOT_FOUND: {
                    return this.idNotFoundValue == other.idNotFoundValue || this.idNotFoundValue.equals(other.idNotFoundValue);
                }
                case GROUP_INFO: {
                    return this.groupInfoValue == other.groupInfoValue || this.groupInfoValue.equals(other.groupInfoValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<GroupsGetInfoItem> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupsGetInfoItem value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ID_NOT_FOUND: {
                    g.writeStartObject();
                    this.writeTag("id_not_found", g);
                    g.writeFieldName("id_not_found");
                    StoneSerializers.string().serialize(value.idNotFoundValue, g);
                    g.writeEndObject();
                    break;
                }
                case GROUP_INFO: {
                    g.writeStartObject();
                    this.writeTag("group_info", g);
                    GroupFullInfo.Serializer.INSTANCE.serialize(value.groupInfoValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public GroupsGetInfoItem deserialize(JsonParser p) throws IOException, JsonParseException {
            GroupsGetInfoItem value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("id_not_found".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("id_not_found", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = GroupsGetInfoItem.idNotFound(fieldValue);
            } else if ("group_info".equals(tag)) {
                GroupFullInfo fieldValue = null;
                fieldValue = GroupFullInfo.Serializer.INSTANCE.deserialize(p, true);
                value = GroupsGetInfoItem.groupInfo(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ID_NOT_FOUND,
        GROUP_INFO;

    }
}

