/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform.errorhandling;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.transform.errorhandling.IFileErrorHandler;

public class CompositeFileErrorHandler
implements IFileErrorHandler {
    private List<IFileErrorHandler> handlers;

    public CompositeFileErrorHandler(List<IFileErrorHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handleFile(FileObject file) throws HopException {
        for (IFileErrorHandler handler : this.handlers) {
            handler.handleFile(file);
        }
    }

    @Override
    public void handleLineError(long lineNr, String filePart) throws HopException {
        for (IFileErrorHandler handler : this.handlers) {
            handler.handleLineError(lineNr, filePart);
        }
    }

    @Override
    public void close() throws HopException {
        for (IFileErrorHandler handler : this.handlers) {
            handler.close();
        }
    }

    @Override
    public void handleNonExistantFile(FileObject file) throws HopException {
        for (IFileErrorHandler handler : this.handlers) {
            handler.handleNonExistantFile(file);
        }
    }

    @Override
    public void handleNonAccessibleFile(FileObject file) throws HopException {
        for (IFileErrorHandler handler : this.handlers) {
            handler.handleNonAccessibleFile(file);
        }
    }
}

