/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.hop.core.util.KeyValue;

public class KeyValueFactory<T> {
    public static final KeyValueFactory<String> STRING = new KeyValueFactory<String>("");
    public static final KeyValueFactory<Integer> INTEGER = new KeyValueFactory<Integer>(0);
    public static final KeyValueFactory<Integer> INTEGER_ONE = new KeyValueFactory<Integer>(1);
    public static final KeyValueFactory<Boolean> BOOLEAN = new KeyValueFactory<Boolean>(Boolean.FALSE);
    public static final KeyValueFactory<Boolean> BOOLEAN_TRUE = new KeyValueFactory<Boolean>(Boolean.TRUE);
    public static final KeyValueFactory<Float> FLOAT = new KeyValueFactory<Float>(Float.valueOf(0.0f));
    public static final KeyValueFactory<Float> FLOAT_ONE = new KeyValueFactory<Float>(Float.valueOf(1.0f));
    public static final KeyValueFactory<Double> DOUBLE = new KeyValueFactory<Double>(0.0);
    public static final KeyValueFactory<Double> DOUBLE_ONE = new KeyValueFactory<Double>(1.0);
    public static final KeyValueFactory<Long> LONG = new KeyValueFactory<Long>(0L);
    public static final KeyValueFactory<Long> LONG_ONE = new KeyValueFactory<Long>(1L);
    private final T defaultValue;

    public KeyValueFactory(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public KeyValue<T> create(String key) throws IllegalArgumentException {
        return new KeyValue<T>(key, this.defaultValue);
    }

    public List<KeyValue<T>> createAll(String ... keys) throws IllegalArgumentException {
        ArrayList<KeyValue<T>> instances = new ArrayList<KeyValue<T>>();
        for (String key : keys) {
            instances.add(this.create(key));
        }
        return instances;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("defaultValue", this.defaultValue);
        return builder.toString();
    }
}

