/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class BatchGroupedReduceOperator<IN, KEY>
extends AbstractUdfStreamOperator<IN, ReduceFunction<IN>>
implements OneInputStreamOperator<IN, IN>,
Triggerable<KEY, VoidNamespace> {
    private static final long serialVersionUID = 1L;
    private static final String STATE_NAME = "_op_state";
    private transient ValueState<IN> values;
    private final TypeSerializer<IN> serializer;
    private InternalTimerService<VoidNamespace> timerService;

    public BatchGroupedReduceOperator(ReduceFunction<IN> reducer, TypeSerializer<IN> serializer) {
        super(reducer);
        this.serializer = serializer;
    }

    @Override
    public void open() throws Exception {
        super.open();
        ValueStateDescriptor stateId = new ValueStateDescriptor(STATE_NAME, this.serializer);
        this.values = (ValueState)this.getPartitionedState(stateId);
        this.timerService = this.getInternalTimerService("end-key-timers", new VoidNamespaceSerializer(), this);
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        Object value = element.getValue();
        Object currentValue = this.values.value();
        if (currentValue == null) {
            this.timerService.registerEventTimeTimer(VoidNamespace.INSTANCE, Long.MAX_VALUE);
        } else {
            value = ((ReduceFunction)this.userFunction).reduce(currentValue, value);
        }
        this.values.update(value);
    }

    @Override
    public void onEventTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
        Object currentValue = this.values.value();
        if (currentValue != null) {
            this.output.collect(new StreamRecord<Object>(currentValue, Long.MAX_VALUE));
        }
    }

    @Override
    public void onProcessingTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
    }
}

