/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.azure.storage.file.datalake.implementation.models.LeaseAccessConditions;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathExpiryOptions;
import com.azure.storage.file.datalake.implementation.models.PathGetPropertiesAction;
import com.azure.storage.file.datalake.implementation.models.PathRenameMode;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathSetAccessControlRecursiveMode;
import com.azure.storage.file.datalake.implementation.models.PathsCreateHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsGetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlRecursiveHeaders;
import com.azure.storage.file.datalake.implementation.models.SetAccessControlRecursiveResponse;
import com.azure.storage.file.datalake.implementation.models.SourceModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.azure.storage.file.datalake.implementation.util.ModelHelper;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.azure.storage.file.datalake.models.AccessControlChangeCounters;
import com.azure.storage.file.datalake.models.AccessControlChangeFailure;
import com.azure.storage.file.datalake.models.AccessControlChangeResult;
import com.azure.storage.file.datalake.models.AccessControlChanges;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.PathAccessControl;
import com.azure.storage.file.datalake.models.PathAccessControlEntry;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathPermissions;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.models.PathRemoveAccessControlEntry;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import com.azure.storage.file.datalake.options.PathGetPropertiesOptions;
import com.azure.storage.file.datalake.options.PathRemoveAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.options.PathSetAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.options.PathUpdateAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

@ServiceClient(builder=DataLakePathClientBuilder.class, isAsync=true)
public class DataLakePathAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakePathAsyncClient.class);
    final AzureDataLakeStorageRestAPIImpl dataLakeStorage;
    final AzureDataLakeStorageRestAPIImpl fileSystemDataLakeStorage;
    final AzureDataLakeStorageRestAPIImpl blobDataLakeStorage;
    private final String accountName;
    private final String fileSystemName;
    final String pathName;
    private final String objectName;
    private final DataLakeServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    final PathResourceType pathResourceType;
    final BlockBlobAsyncClient blockBlobAsyncClient;
    private final AzureSasCredential sasToken;
    private final boolean isTokenCredentialAuthenticated;

    DataLakePathAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String pathName, PathResourceType pathResourceType, BlockBlobAsyncClient blockBlobAsyncClient, AzureSasCredential sasToken, CpkInfo customerProvidedKey, boolean isTokenCredentialAuthenticated) {
        this.accountName = accountName;
        this.fileSystemName = fileSystemName;
        this.pathName = pathName;
        this.pathResourceType = pathResourceType;
        this.blockBlobAsyncClient = blockBlobAsyncClient;
        this.sasToken = sasToken;
        this.dataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).path(this.pathName).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(url, "blob", "dfs");
        this.blobDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(blobUrl).fileSystem(fileSystemName).path(this.pathName).version(serviceVersion.getVersion()).buildClient();
        this.fileSystemDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        this.customerProvidedKey = customerProvidedKey;
        this.isTokenCredentialAuthenticated = isTokenCredentialAuthenticated;
        String[] pathParts = pathName.split("/");
        this.objectName = pathParts[pathParts.length - 1];
    }

    String getAccountUrl() {
        return this.dataLakeStorage.getUrl();
    }

    String getPathUrl() {
        return this.dataLakeStorage.getUrl() + "/" + this.fileSystemName + "/" + Utility.urlEncode((String)this.pathName);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    String getObjectPath() {
        return this.pathName;
    }

    String getObjectName() {
        return this.objectName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.dataLakeStorage.getHttpPipeline();
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    AzureSasCredential getSasToken() {
        return this.sasToken;
    }

    public CustomerProvidedKey getCustomerProvidedKey() {
        return new CustomerProvidedKey(this.customerProvidedKey.getEncryptionKey());
    }

    CpkInfo getCpkInfo() {
        return this.customerProvidedKey;
    }

    boolean isTokenCredentialAuthenticated() {
        return this.isTokenCredentialAuthenticated;
    }

    public DataLakePathAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new DataLakePathAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), this.getObjectPath(), this.pathResourceType, this.blockBlobAsyncClient, this.getSasToken(), finalCustomerProvidedKey, this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> create() {
        return this.create(false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> create(boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createWithResponse(new DataLakePathCreateOptions().setRequestConditions(requestConditions)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> createWithResponse(String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
            return FluxUtil.withContext(context -> this.createWithResponse(options));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> createWithResponse(DataLakePathCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<PathInfo>> createWithResponse(DataLakePathCreateOptions options, Context context) {
        options = options == null ? new DataLakePathCreateOptions() : options;
        DataLakeRequestConditions requestConditions = options.getRequestConditions() == null ? new DataLakeRequestConditions() : options.getRequestConditions();
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        String acl = options.getAccessControlList() != null ? PathAccessControlEntry.serializeList(options.getAccessControlList()) : null;
        PathExpiryOptions expiryOptions = ModelHelper.setFieldsIfNull(options, this.pathResourceType);
        String expiresOnString = null;
        if (options.getScheduleDeletionOptions() != null && options.getScheduleDeletionOptions().getExpiresOn() != null) {
            expiresOnString = DateTimeRfc1123.toRfc1123String((OffsetDateTime)options.getScheduleDeletionOptions().getExpiresOn());
        } else if (options.getScheduleDeletionOptions() != null && options.getScheduleDeletionOptions().getTimeToExpire() != null) {
            expiresOnString = Long.toString(options.getScheduleDeletionOptions().getTimeToExpire().toMillis());
        }
        Long leaseDuration = options.getLeaseDuration() != null ? Long.valueOf(options.getLeaseDuration().intValue()) : null;
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().createWithResponseAsync(null, null, this.pathResourceType, null, null, null, options.getSourceLeaseId(), ModelHelper.buildMetadataString(options.getMetadata()), options.getPermissions(), options.getUmask(), options.getOwner(), options.getGroup(), acl, options.getProposedLeaseId(), leaseDuration, expiryOptions, expiresOnString, options.getEncryptionContext(), options.getPathHttpHeaders(), lac, mac, null, this.customerProvidedKey, context).map(response -> new SimpleResponse((Response)response, (Object)new PathInfo(((PathsCreateHeaders)response.getDeserializedHeaders()).getETag(), ((PathsCreateHeaders)response.getDeserializedHeaders()).getLastModified(), ((PathsCreateHeaders)response.getDeserializedHeaders()).isXMsRequestServerEncrypted() != null, ((PathsCreateHeaders)response.getDeserializedHeaders()).getXMsEncryptionKeySha256())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> createIfNotExists() {
        return this.createIfNotExistsWithResponse(new DataLakePathCreateOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> createIfNotExistsWithResponse(DataLakePathCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createIfNotExistsWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<PathInfo>> createIfNotExistsWithResponse(DataLakePathCreateOptions options, Context context) {
        try {
            options = options == null ? new DataLakePathCreateOptions() : options;
            options.setRequestConditions(new DataLakeRequestConditions().setIfNoneMatch("*"));
            return this.createWithResponse(options, context).onErrorResume(t -> t instanceof DataLakeStorageException && ((DataLakeStorageException)((Object)((Object)t))).getStatusCode() == 409, t -> {
                HttpResponse response = ((DataLakeStorageException)((Object)((Object)t))).getResponse();
                return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(Boolean recursive, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        Boolean paginated = this.getServiceVersion().ordinal() >= DataLakeServiceVersion.V2023_08_03.ordinal() && Boolean.TRUE.equals(recursive) && this.isTokenCredentialAuthenticated() ? Boolean.valueOf(true) : null;
        Context finalContext = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().deleteNoCustomHeadersWithResponseAsync(null, null, recursive, null, paginated, lac, mac, context).expand(resp -> {
            String continuation = resp.getHeaders().getValue(Transforms.X_MS_CONTINUATION);
            if (continuation != null && !continuation.isEmpty()) {
                return this.dataLakeStorage.getPaths().deleteNoCustomHeadersWithResponseAsync(null, null, recursive, continuation, paginated, lac, mac, finalContext);
            }
            return Mono.empty();
        }).last();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteIfExistsWithResponse(DataLakePathDeleteOptions options) {
        try {
            return FluxUtil.withContext(context -> this.deleteIfExistsWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> deleteIfExistsWithResponse(DataLakePathDeleteOptions options, Context context) {
        try {
            options = options == null ? new DataLakePathDeleteOptions() : options;
            return this.deleteWithResponse(options.getIsRecursive(), options.getRequestConditions(), context).map(response -> new SimpleResponse(response, (Object)true)).onErrorResume(t -> t instanceof DataLakeStorageException && ((DataLakeStorageException)((Object)((Object)t))).getStatusCode() == 404, t -> {
                HttpResponse response = ((DataLakeStorageException)((Object)((Object)t))).getResponse();
                return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadata(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        return this.blockBlobAsyncClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setHttpHeaders(PathHttpHeaders headers) {
        return this.setHttpHeadersWithResponse(headers, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setHttpHeadersWithResponse(PathHttpHeaders headers, DataLakeRequestConditions requestConditions) {
        return this.blockBlobAsyncClient.setHttpHeadersWithResponse(Transforms.toBlobHttpHeaders(headers), Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathProperties> getProperties() {
        return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathProperties> getProperties(PathGetPropertiesOptions options) {
        return this.getPropertiesUsingOptionsWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathProperties>> getPropertiesWithResponse(DataLakeRequestConditions requestConditions) {
        return this.blockBlobAsyncClient.getPropertiesWithResponse(Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)Transforms.toPathProperties((BlobProperties)response.getValue(), response)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PathProperties>> getPropertiesUsingOptionsWithResponse(PathGetPropertiesOptions options) {
        Context context = BuilderHelper.addUpnHeader(() -> options == null ? null : options.isUserPrincipalName(), null);
        return this.blockBlobAsyncClient.getPropertiesWithResponse(Transforms.toBlobRequestConditions(options.getRequestConditions())).contextWrite((ContextView)FluxUtil.toReactorContext((Context)context)).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)Transforms.toPathProperties((BlobProperties)response.getValue(), response)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> existsWithResponse() {
        return this.blockBlobAsyncClient.existsWithResponse().onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> setAccessControlList(List<PathAccessControlEntry> accessControlList, String group, String owner) {
        return this.setAccessControlListWithResponse(accessControlList, group, owner, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> setAccessControlListWithResponse(List<PathAccessControlEntry> accessControlList, String group, String owner, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessControlWithResponse(accessControlList, null, group, owner, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> setPermissions(PathPermissions permissions, String group, String owner) {
        return this.setPermissionsWithResponse(permissions, group, owner, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> setPermissionsWithResponse(PathPermissions permissions, String group, String owner, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessControlWithResponse(null, permissions, group, owner, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<PathInfo>> setAccessControlWithResponse(List<PathAccessControlEntry> accessControlList, PathPermissions permissions, String group, String owner, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        String permissionsString = permissions == null ? null : permissions.toString();
        String accessControlListString = accessControlList == null ? null : PathAccessControlEntry.serializeList(accessControlList);
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().setAccessControlWithResponseAsync(null, owner, group, permissionsString, accessControlListString, null, lac, mac, context).map(response -> new SimpleResponse((Response)response, (Object)new PathInfo(((PathsSetAccessControlHeaders)response.getDeserializedHeaders()).getETag(), ((PathsSetAccessControlHeaders)response.getDeserializedHeaders()).getLastModified())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessControlChangeResult> setAccessControlRecursive(List<PathAccessControlEntry> accessControlList) {
        return this.setAccessControlRecursiveWithResponse(new PathSetAccessControlRecursiveOptions(accessControlList)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessControlChangeResult>> setAccessControlRecursiveWithResponse(PathSetAccessControlRecursiveOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return FluxUtil.withContext(context -> this.setAccessControlRecursiveWithResponse(PathAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.SET, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessControlChangeResult> updateAccessControlRecursive(List<PathAccessControlEntry> accessControlList) {
        return this.updateAccessControlRecursiveWithResponse(new PathUpdateAccessControlRecursiveOptions(accessControlList)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessControlChangeResult>> updateAccessControlRecursiveWithResponse(PathUpdateAccessControlRecursiveOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return FluxUtil.withContext(context -> this.setAccessControlRecursiveWithResponse(PathAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.MODIFY, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessControlChangeResult> removeAccessControlRecursive(List<PathRemoveAccessControlEntry> accessControlList) {
        return this.removeAccessControlRecursiveWithResponse(new PathRemoveAccessControlRecursiveOptions(accessControlList)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessControlChangeResult>> removeAccessControlRecursiveWithResponse(PathRemoveAccessControlRecursiveOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return FluxUtil.withContext(context -> this.setAccessControlRecursiveWithResponse(PathRemoveAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.REMOVE, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<AccessControlChangeResult>> setAccessControlRecursiveWithResponse(String accessControlList, Consumer<Response<AccessControlChanges>> progressHandler, PathSetAccessControlRecursiveMode mode, Integer batchSize, Integer maxBatches, Boolean continueOnFailure, String continuationToken, Context context) {
        StorageImplUtils.assertNotNull((String)"accessControlList", (Object)accessControlList);
        Context contextFinal = context = context == null ? Context.NONE : context;
        AtomicInteger directoriesSuccessfulCount = new AtomicInteger(0);
        AtomicInteger filesSuccessfulCount = new AtomicInteger(0);
        AtomicInteger failureCount = new AtomicInteger(0);
        AtomicInteger batchesCount = new AtomicInteger(0);
        return this.dataLakeStorage.getPaths().setAccessControlRecursiveWithResponseAsync(mode, null, continuationToken, continueOnFailure, batchSize, accessControlList, null, contextFinal).onErrorMap(e -> {
            if (e instanceof DataLakeStorageException) {
                return LOGGER.logExceptionAsError((RuntimeException)((Object)ModelHelper.changeAclRequestFailed((DataLakeStorageException)((Object)((Object)e)), continuationToken)));
            }
            if (e instanceof Exception) {
                return LOGGER.logExceptionAsError((RuntimeException)((Object)ModelHelper.changeAclFailed((Exception)e, continuationToken)));
            }
            return e;
        }).flatMap(response -> this.setAccessControlRecursiveWithResponseHelper((ResponseBase<PathsSetAccessControlRecursiveHeaders, SetAccessControlRecursiveResponse>)response, maxBatches, directoriesSuccessfulCount, filesSuccessfulCount, failureCount, batchesCount, progressHandler, accessControlList, mode, batchSize, continueOnFailure, continuationToken, null, contextFinal));
    }

    Mono<Response<AccessControlChangeResult>> setAccessControlRecursiveWithResponseHelper(ResponseBase<PathsSetAccessControlRecursiveHeaders, SetAccessControlRecursiveResponse> response, Integer maxBatches, AtomicInteger directoriesSuccessfulCount, AtomicInteger filesSuccessfulCount, AtomicInteger failureCount, AtomicInteger batchesCount, Consumer<Response<AccessControlChanges>> progressHandler, String accessControlStr, PathSetAccessControlRecursiveMode mode, Integer batchSize, Boolean continueOnFailure, String lastToken, List<AccessControlChangeFailure> batchFailures, Context context) {
        batchesCount.incrementAndGet();
        directoriesSuccessfulCount.addAndGet(((SetAccessControlRecursiveResponse)response.getValue()).getDirectoriesSuccessful());
        filesSuccessfulCount.addAndGet(((SetAccessControlRecursiveResponse)response.getValue()).getFilesSuccessful());
        failureCount.addAndGet(((SetAccessControlRecursiveResponse)response.getValue()).getFailureCount());
        if (failureCount.get() > 0 && batchFailures == null) {
            batchFailures = ((SetAccessControlRecursiveResponse)response.getValue()).getFailedEntries().stream().map(aclFailedEntry -> new AccessControlChangeFailure().setDirectory(aclFailedEntry.getType().equals("DIRECTORY")).setName(aclFailedEntry.getName()).setErrorMessage(aclFailedEntry.getErrorMessage())).collect(Collectors.toList());
        }
        List<AccessControlChangeFailure> finalBatchFailures = batchFailures;
        String newToken = ((PathsSetAccessControlRecursiveHeaders)response.getDeserializedHeaders()).getXMsContinuation();
        String effectiveNextToken = newToken != null && !newToken.isEmpty() ? newToken : (failureCount.get() == 0 || continueOnFailure == null || continueOnFailure != false ? newToken : lastToken);
        if (progressHandler != null) {
            AccessControlChanges changes = new AccessControlChanges();
            changes.setContinuationToken(effectiveNextToken);
            changes.setBatchFailures(((SetAccessControlRecursiveResponse)response.getValue()).getFailedEntries().stream().map(aclFailedEntry -> new AccessControlChangeFailure().setDirectory(aclFailedEntry.getType().equals("DIRECTORY")).setName(aclFailedEntry.getName()).setErrorMessage(aclFailedEntry.getErrorMessage())).collect(Collectors.toList()));
            changes.setBatchCounters(new AccessControlChangeCounters().setChangedDirectoriesCount(((SetAccessControlRecursiveResponse)response.getValue()).getDirectoriesSuccessful().intValue()).setChangedFilesCount(((SetAccessControlRecursiveResponse)response.getValue()).getFilesSuccessful().intValue()).setFailedChangesCount(((SetAccessControlRecursiveResponse)response.getValue()).getFailureCount().intValue()));
            changes.setAggregateCounters(new AccessControlChangeCounters().setChangedDirectoriesCount(directoriesSuccessfulCount.get()).setChangedFilesCount(filesSuccessfulCount.get()).setFailedChangesCount(failureCount.get()));
            progressHandler.accept((Response<AccessControlChanges>)new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)changes, (Object)((PathsSetAccessControlRecursiveHeaders)response.getDeserializedHeaders())));
        }
        if (newToken == null || newToken.isEmpty() || maxBatches != null && batchesCount.get() >= maxBatches) {
            AccessControlChangeResult result = new AccessControlChangeResult().setBatchFailures(batchFailures).setContinuationToken(effectiveNextToken).setCounters(new AccessControlChangeCounters().setChangedDirectoriesCount(directoriesSuccessfulCount.get()).setChangedFilesCount(filesSuccessfulCount.get()).setFailedChangesCount(failureCount.get()));
            return Mono.just((Object)new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result, (Object)((PathsSetAccessControlRecursiveHeaders)response.getDeserializedHeaders())));
        }
        return this.dataLakeStorage.getPaths().setAccessControlRecursiveWithResponseAsync(mode, null, effectiveNextToken, continueOnFailure, batchSize, accessControlStr, null, context).onErrorMap(e -> {
            if (e instanceof DataLakeStorageException) {
                return LOGGER.logExceptionAsError((RuntimeException)((Object)ModelHelper.changeAclRequestFailed((DataLakeStorageException)((Object)((Object)e)), effectiveNextToken)));
            }
            if (e instanceof Exception) {
                return LOGGER.logExceptionAsError((RuntimeException)((Object)ModelHelper.changeAclFailed((Exception)e, effectiveNextToken)));
            }
            return e;
        }).flatMap(response2 -> this.setAccessControlRecursiveWithResponseHelper((ResponseBase<PathsSetAccessControlRecursiveHeaders, SetAccessControlRecursiveResponse>)response2, maxBatches, directoriesSuccessfulCount, filesSuccessfulCount, failureCount, batchesCount, progressHandler, accessControlStr, mode, batchSize, continueOnFailure, effectiveNextToken, finalBatchFailures, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathAccessControl> getAccessControl() {
        return this.getAccessControlWithResponse(false, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathAccessControl>> getAccessControlWithResponse(boolean userPrincipalNameReturned, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getAccessControlWithResponse(userPrincipalNameReturned, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<PathAccessControl>> getAccessControlWithResponse(boolean userPrincipalNameReturned, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().getPropertiesWithResponseAsync(null, null, PathGetPropertiesAction.GET_ACCESS_CONTROL, userPrincipalNameReturned, lac, mac, context).map(response -> new SimpleResponse((Response)response, (Object)new PathAccessControl(PathAccessControlEntry.parseList(((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsAcl()), PathPermissions.parseSymbolic(((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsPermissions()), ((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsGroup(), ((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsOwner())));
    }

    Mono<Response<DataLakePathAsyncClient>> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Context context) {
        context = context == null ? Context.NONE : context;
        destinationRequestConditions = destinationRequestConditions == null ? new DataLakeRequestConditions() : destinationRequestConditions;
        sourceRequestConditions = sourceRequestConditions == null ? new DataLakeRequestConditions() : sourceRequestConditions;
        SourceModifiedAccessConditions sourceConditions = new SourceModifiedAccessConditions().setSourceIfModifiedSince(sourceRequestConditions.getIfModifiedSince()).setSourceIfUnmodifiedSince(sourceRequestConditions.getIfUnmodifiedSince()).setSourceIfMatch(sourceRequestConditions.getIfMatch()).setSourceIfNoneMatch(sourceRequestConditions.getIfNoneMatch());
        LeaseAccessConditions destLac = new LeaseAccessConditions().setLeaseId(destinationRequestConditions.getLeaseId());
        ModifiedAccessConditions destMac = new ModifiedAccessConditions().setIfMatch(destinationRequestConditions.getIfMatch()).setIfNoneMatch(destinationRequestConditions.getIfNoneMatch()).setIfModifiedSince(destinationRequestConditions.getIfModifiedSince()).setIfUnmodifiedSince(destinationRequestConditions.getIfUnmodifiedSince());
        DataLakePathAsyncClient dataLakePathAsyncClient = this.getPathAsyncClient(destinationFileSystem, destinationPath);
        String renameSource = "/" + this.fileSystemName + "/" + Utility.urlEncode((String)this.pathName);
        String signature = null;
        if (this.sasToken != null) {
            signature = this.sasToken.getSignature().startsWith("?") ? this.sasToken.getSignature().substring(1) : this.sasToken.getSignature();
        }
        renameSource = signature != null ? renameSource + "?" + signature : renameSource;
        return dataLakePathAsyncClient.dataLakeStorage.getPaths().createWithResponseAsync(null, null, null, null, PathRenameMode.LEGACY, renameSource, sourceRequestConditions.getLeaseId(), null, null, null, null, null, null, null, null, null, null, null, null, destLac, destMac, sourceConditions, null, context).map(response -> new SimpleResponse((Response)response, (Object)dataLakePathAsyncClient));
    }

    DataLakePathAsyncClient getPathAsyncClient(String destinationFileSystem, String destinationPath) {
        if (destinationFileSystem == null) {
            destinationFileSystem = this.getFileSystemName();
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)destinationPath)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        return new DataLakePathAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.serviceVersion, this.accountName, destinationFileSystem, destinationPath, this.pathResourceType, this.prepareBuilderReplacePath(destinationFileSystem, destinationPath).buildBlockBlobAsyncClient(), this.sasToken, this.customerProvidedKey, this.isTokenCredentialAuthenticated());
    }

    SpecializedBlobClientBuilder prepareBuilderReplacePath(String destinationFileSystem, String destinationPath) {
        if (destinationFileSystem == null) {
            destinationFileSystem = this.getFileSystemName();
        }
        String newBlobEndpoint = BlobUrlParts.parse((String)DataLakeImplUtils.endpointToDesiredEndpoint(this.getPathUrl(), "blob", "dfs")).setContainerName(destinationFileSystem).toUrl().toString();
        return new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).endpoint(newBlobEndpoint).blobName(destinationPath).serviceVersion(TransformUtils.toBlobServiceVersion(this.getServiceVersion()));
    }

    BlockBlobAsyncClient getBlockBlobAsyncClient() {
        return this.blockBlobAsyncClient;
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName(), this.getObjectPath(), PathResourceType.DIRECTORY.equals((Object)this.pathResourceType)).generateUserDelegationSas(userDelegationKey, accountName, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.generateSas(dataLakeServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName(), this.getObjectPath(), PathResourceType.DIRECTORY.equals((Object)this.pathResourceType)).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }
}

