/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import java.util.Objects;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class TokenSampleStream
extends FilterObjectStream<String, TokenSample> {
    private final String separatorChars;

    public TokenSampleStream(ObjectStream<String> sampleStrings, String separatorChars) {
        super(Objects.requireNonNull(sampleStrings, "sampleStrings must not be null"));
        this.separatorChars = Objects.requireNonNull(separatorChars, "separatorChars must not be null");
    }

    public TokenSampleStream(ObjectStream<String> sentences) {
        this(sentences, "<SPLIT>");
    }

    @Override
    public TokenSample read() throws IOException {
        String sampleString = (String)this.samples.read();
        if (sampleString != null) {
            return TokenSample.parse(sampleString, this.separatorChars);
        }
        return null;
    }
}

