/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cratedbbulkloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.CrateDBBulkLoaderField;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.CrateDBBulkLoaderMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CrateDBBulkLoaderDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = CrateDBBulkLoaderMeta.class;
    public static final String SYSTEM_DIALOG_ERROR_TITLE = "System.Dialog.Error.Title";
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private Label wlHttpEndpoint;
    private TextVar wHttpEndpoint;
    private Label wlBatchSize;
    private TextVar wBatchSize;
    private TextVar wTable;
    private Button wStreamToRemoteCsv;
    private TextVar wLocalRemoteVolumeMapping;
    private TextVar wReadFromFilename;
    private Button wUseHTTPEndpoint;
    private TableView wFields;
    private Button wGetFields;
    private Button wDoMapping;
    private CrateDBBulkLoaderMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciFields;
    private Label wlUseSystemVars;
    private Button wUseSystemVars;
    private Label wlAccessKeyId;
    private TextVar wAccessKeyId;
    private Label wlSecretAccessKey;
    private TextVar wSecretAccessKey;
    private Button wSpecifyFields;
    private TextVar wHttpLogin;
    private TextVar wHttpPassword;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private Label wlHttpLogin;
    private Label wlHttpPassword;
    private Label wlReadFromFile;
    private Label wlLocalRemoteVolumeMapping;
    private Label wlStreamToRemoteCsv;

    public CrateDBBulkLoaderDialog(Shell parent, IVariables variables, CrateDBBulkLoaderMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                CrateDBBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DialogTitle", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin * 2);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin * 2);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment((Control)lastControl, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString((String)"System.Button.Browse"));
        FormData fdbSchema = new FormData();
        fdbSchema.right = new FormAttachment(100, 0);
        fdbSchema.top = new FormAttachment((Control)lastControl, margin * 2);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment((Control)lastControl, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        lastControl = this.wSchema;
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)lastControl, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString((String)"System.Button.Browse"));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)lastControl, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        FormData fdTable = new FormData();
        fdTable.top = new FormAttachment((Control)lastControl, margin);
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        lastControl = wlTable;
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString((String)"System.Button.SQL"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.addGeneralTab(wTabFolder, margin, middle, lsMod, (FocusListener)lsFocusLost);
        this.addAwsAuthenticationTab(wTabFolder, margin, middle, lsMod, (FocusListener)lsFocusLost);
        this.addHttpAuthenticationTab(wTabFolder, margin, middle, lsMod, (FocusListener)lsFocusLost);
        this.addFieldsTab(wTabFolder, margin, lsMod);
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel, this.wCreate}, margin, null);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)lastControl, margin * 4);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTabFolder.setSelection(0);
        this.wOk.addListener(13, c -> this.ok());
        this.wCancel.addListener(13, c -> this.cancel());
        this.wCreate.addListener(13, c -> this.sql());
        this.wGetFields.addListener(13, c -> this.get());
        wbTable.addListener(13, c -> this.getTableName());
        wbSchema.addListener(13, c -> this.getSchemaName());
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.toggleHttpEndpointFlags();
        this.toggleSpecifyFieldsFlags();
        this.toggleKeysSelection();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void addFieldsTab(CTabFolder wTabFolder, int margin, ModifyListener lsMod) {
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.FieldsTab.TabItem.Label", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout fieldsCompLayout = new FormLayout();
        fieldsCompLayout.marginWidth = 5;
        fieldsCompLayout.marginHeight = 5;
        wFieldsComp.setLayout((Layout)fieldsCompLayout);
        Label wlFields = new Label(wFieldsComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.InsertFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(0, margin);
        wlFields.setLayoutData((Object)fdlUpIns);
        int tableCols = 2;
        int upInsRows = this.input.getFields() != null && !this.input.getFields().equals(Collections.emptyList()) ? this.input.getFields().size() : 1;
        this.ciFields = new ColumnInfo[tableCols];
        this.ciFields[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciFields[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciFields[0]);
        this.wFields = new TableView(this.variables, wFieldsComp, 68354, this.ciFields, upInsRows, lsMod, this.props);
        this.wGetFields = new Button(wFieldsComp, 8);
        this.wGetFields.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGetFields = new FormData();
        fdGetFields.top = new FormAttachment((Control)wlFields, margin);
        fdGetFields.right = new FormAttachment(100, 0);
        this.wGetFields.setLayoutData((Object)fdGetFields);
        this.wDoMapping = new Button(wFieldsComp, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.Button", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)this.wGetFields, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)fdDoMapping);
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                CrateDBBulkLoaderDialog.this.generateMappings();
            }
        });
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wDoMapping, -margin);
        fdFields.bottom = new FormAttachment(100, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        this.getFieldsFromPrevious();
    }

    private void getFieldsFromPrevious() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransformMeta transformMeta = CrateDBBulkLoaderDialog.this.pipelineMeta.findTransform(CrateDBBulkLoaderDialog.this.transformName);
                if (transformMeta != null) {
                    try {
                        IRowMeta row = CrateDBBulkLoaderDialog.this.pipelineMeta.getPrevTransformFields(CrateDBBulkLoaderDialog.this.variables, transformMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            CrateDBBulkLoaderDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        CrateDBBulkLoaderDialog.this.setComboBoxes();
                    }
                    catch (HopException e) {
                        CrateDBBulkLoaderDialog.this.log.logError(this.toString(), new Object[]{BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Message")});
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    private void addAwsAuthenticationTab(CTabFolder wTabFolder, int margin, int middle, ModifyListener lsMod, FocusListener lsFocusLost) {
        CTabItem wOptionsTab = new CTabItem(wTabFolder, 0);
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.AWSTab.TabItem.Label", (String[])new String[0]));
        FormLayout optionsLayout = new FormLayout();
        optionsLayout.marginWidth = 3;
        optionsLayout.marginHeight = 3;
        Composite wOptionsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wOptionsComp);
        wOptionsComp.setLayout((Layout)optionsLayout);
        this.wlUseSystemVars = new Label(wOptionsComp, 131072);
        this.wlUseSystemVars.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.Authenticate.UseSystemVars.Label", (String[])new String[0]));
        this.wlUseSystemVars.setToolTipText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.Authenticate.UseSystemVars.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUseSystemVars);
        FormData fdlUseSystemVars = new FormData();
        fdlUseSystemVars.top = new FormAttachment(0, margin);
        fdlUseSystemVars.left = new FormAttachment(0, 0);
        fdlUseSystemVars.right = new FormAttachment(middle, -margin);
        this.wlUseSystemVars.setLayoutData((Object)fdlUseSystemVars);
        this.wUseSystemVars = new Button(wOptionsComp, 32);
        this.wUseSystemVars.setSelection(true);
        PropsUi.setLook((Widget)this.wUseSystemVars);
        FormData fdUseSystemVars = new FormData();
        fdUseSystemVars.top = new FormAttachment(0, margin);
        fdUseSystemVars.left = new FormAttachment(middle, 0);
        fdUseSystemVars.right = new FormAttachment(100, 0);
        this.wUseSystemVars.setLayoutData((Object)fdUseSystemVars);
        Label lastControl = this.wlUseSystemVars;
        this.wUseSystemVars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrateDBBulkLoaderDialog.this.toggleKeysSelection();
            }
        });
        this.wlAccessKeyId = new Label(wOptionsComp, 131072);
        this.wlAccessKeyId.setText("AWS_ACCESS_KEY_ID");
        PropsUi.setLook((Widget)this.wlAccessKeyId);
        FormData fdlAccessKeyId = new FormData();
        fdlAccessKeyId.top = new FormAttachment((Control)lastControl, margin);
        fdlAccessKeyId.left = new FormAttachment(0, 0);
        fdlAccessKeyId.right = new FormAttachment(middle, -margin);
        this.wlAccessKeyId.setLayoutData((Object)fdlAccessKeyId);
        this.wAccessKeyId = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wAccessKeyId);
        FormData fdUseAccessKeyId = new FormData();
        fdUseAccessKeyId.top = new FormAttachment((Control)lastControl, margin);
        fdUseAccessKeyId.left = new FormAttachment(middle, 0);
        fdUseAccessKeyId.right = new FormAttachment(100, 0);
        this.wAccessKeyId.setLayoutData((Object)fdUseAccessKeyId);
        this.wAccessKeyId.addModifyListener(lsMod);
        lastControl = this.wAccessKeyId;
        this.wlSecretAccessKey = new Label(wOptionsComp, 131072);
        this.wlSecretAccessKey.setText("AWS_SECRET_ACCESS_KEY");
        PropsUi.setLook((Widget)this.wlSecretAccessKey);
        FormData fdlSecretAccessKey = new FormData();
        fdlSecretAccessKey.top = new FormAttachment((Control)lastControl, margin);
        fdlSecretAccessKey.left = new FormAttachment(0, 0);
        fdlSecretAccessKey.right = new FormAttachment(middle, -margin);
        this.wlSecretAccessKey.setLayoutData((Object)fdlSecretAccessKey);
        this.wSecretAccessKey = new TextVar(this.variables, wOptionsComp, 0x404804);
        PropsUi.setLook((Widget)this.wSecretAccessKey);
        FormData fdSecretAccessKey = new FormData();
        fdSecretAccessKey.top = new FormAttachment((Control)lastControl, margin);
        fdSecretAccessKey.left = new FormAttachment(middle, 0);
        fdSecretAccessKey.right = new FormAttachment(100, 0);
        this.wSecretAccessKey.setLayoutData((Object)fdSecretAccessKey);
        this.wSecretAccessKey.addModifyListener(lsMod);
        FormData fdOptionsComp = new FormData();
        fdOptionsComp.left = new FormAttachment(0, 0);
        fdOptionsComp.top = new FormAttachment(0, 0);
        fdOptionsComp.right = new FormAttachment(100, 0);
        fdOptionsComp.bottom = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)fdOptionsComp);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private void addHttpAuthenticationTab(CTabFolder wTabFolder, int margin, int middle, ModifyListener lsMod, FocusListener lsFocusLost) {
        CTabItem wHttpTab = new CTabItem(wTabFolder, 0);
        wHttpTab.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.HttpTab.TabItem.Label", (String[])new String[0]));
        FormLayout httpLayout = new FormLayout();
        httpLayout.marginWidth = 3;
        httpLayout.marginHeight = 3;
        Composite wHttpComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wHttpComp);
        wHttpComp.setLayout((Layout)httpLayout);
        this.wlHttpLogin = new Label(wHttpComp, 131072);
        this.wlHttpLogin.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.HttpLogin.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlHttpLogin);
        FormData fdlHttpLogin = new FormData();
        fdlHttpLogin.top = new FormAttachment(0, margin);
        fdlHttpLogin.left = new FormAttachment(0, 0);
        fdlHttpLogin.right = new FormAttachment(middle, -margin);
        this.wlHttpLogin.setLayoutData((Object)fdlHttpLogin);
        this.wHttpLogin = new TextVar(this.variables, wHttpComp, 18436);
        this.wHttpLogin.addModifyListener(lsMod);
        this.wHttpLogin.setToolTipText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.HttpLogin.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHttpLogin);
        FormData fdHttpLogin = new FormData();
        fdHttpLogin.top = new FormAttachment(0, margin);
        fdHttpLogin.left = new FormAttachment(middle, 0);
        fdHttpLogin.right = new FormAttachment(100, 0);
        this.wHttpLogin.setLayoutData((Object)fdHttpLogin);
        Label lastControl = this.wlHttpLogin;
        this.wlHttpPassword = new Label(wHttpComp, 131072);
        this.wlHttpPassword.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.HttpPassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlHttpPassword);
        FormData fdlHttpPassword = new FormData();
        fdlHttpPassword.top = new FormAttachment((Control)lastControl, margin);
        fdlHttpPassword.left = new FormAttachment(0, 0);
        fdlHttpPassword.right = new FormAttachment(middle, -margin);
        this.wlHttpPassword.setLayoutData((Object)fdlHttpPassword);
        this.wHttpPassword = new PasswordTextVar(this.variables, wHttpComp, 18436);
        this.wHttpPassword.addModifyListener(lsMod);
        this.wHttpPassword.setToolTipText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.HttpPassword.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHttpPassword);
        FormData fdHttpPassword = new FormData();
        fdHttpPassword.top = new FormAttachment((Control)lastControl, margin);
        fdHttpPassword.left = new FormAttachment(middle, 0);
        fdHttpPassword.right = new FormAttachment(100, 0);
        this.wHttpPassword.setLayoutData((Object)fdHttpPassword);
        FormData fdHttpComp = new FormData();
        fdHttpComp.left = new FormAttachment(0, 0);
        fdHttpComp.top = new FormAttachment(0, 0);
        fdHttpComp.right = new FormAttachment(100, 0);
        fdHttpComp.bottom = new FormAttachment(100, 0);
        wHttpComp.setLayoutData((Object)fdHttpComp);
        wHttpComp.layout();
        wHttpTab.setControl((Control)wHttpComp);
    }

    private void addGeneralTab(CTabFolder wTabFolder, int margin, int middle, ModifyListener lsMod, FocusListener lsFocusLost) {
        CTabItem wMainTab = new CTabItem(wTabFolder, 0);
        wMainTab.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.MainTab.TabItem.Label", (String[])new String[0]));
        FormLayout mainLayout = new FormLayout();
        mainLayout.marginWidth = 3;
        mainLayout.marginHeight = 3;
        Composite wMainComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wMainComp);
        wMainComp.setLayout((Layout)mainLayout);
        FormData fdMainComp = new FormData();
        fdMainComp.left = new FormAttachment(0, 0);
        fdMainComp.top = new FormAttachment(0, 0);
        fdMainComp.right = new FormAttachment(100, 0);
        fdMainComp.bottom = new FormAttachment(100, 0);
        wMainComp.setLayoutData((Object)fdMainComp);
        DatabaseMeta dbm = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine(wMainComp, (Control)this.wTransformName, this.input.getDatabaseMeta(), null);
        this.wConnection.addModifyListener(lsMod);
        Label lastControl = this.wConnection;
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CrateDBBulkLoaderDialog.this.input.setChanged();
            }
        };
        Label wlUseHTTPEndpoint = new Label(wMainComp, 131072);
        wlUseHTTPEndpoint.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.UseHTTPEndpoint.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseHTTPEndpoint);
        FormData fdlUseHttpEndpoint = new FormData();
        fdlUseHttpEndpoint.top = new FormAttachment(lastControl, margin);
        fdlUseHttpEndpoint.left = new FormAttachment(0, 0);
        fdlUseHttpEndpoint.right = new FormAttachment(middle, -margin);
        wlUseHTTPEndpoint.setLayoutData((Object)fdlUseHttpEndpoint);
        this.wUseHTTPEndpoint = new Button(wMainComp, 32);
        PropsUi.setLook((Widget)this.wUseHTTPEndpoint);
        FormData fdUseHTTPEndpoint = new FormData();
        fdUseHTTPEndpoint.top = new FormAttachment(lastControl, margin);
        fdUseHTTPEndpoint.left = new FormAttachment(middle, 0);
        fdUseHTTPEndpoint.right = new FormAttachment(100, 0);
        this.wUseHTTPEndpoint.setLayoutData((Object)fdUseHTTPEndpoint);
        this.wUseHTTPEndpoint.addSelectionListener((SelectionListener)lsSelMod);
        this.wUseHTTPEndpoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CrateDBBulkLoaderDialog.this.toggleHttpEndpointFlags();
            }
        });
        lastControl = wlUseHTTPEndpoint;
        this.wlHttpEndpoint = new Label(wMainComp, 131072);
        this.wlHttpEndpoint.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.HTTPEndpoint.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlHttpEndpoint);
        FormData fdlHttpEndpoint = new FormData();
        fdlHttpEndpoint.left = new FormAttachment(0, 0);
        fdlHttpEndpoint.right = new FormAttachment(middle, -margin);
        fdlHttpEndpoint.top = new FormAttachment((Control)lastControl, margin);
        this.wlHttpEndpoint.setLayoutData((Object)fdlHttpEndpoint);
        this.wHttpEndpoint = new TextVar(this.variables, wMainComp, 18436);
        PropsUi.setLook((Widget)this.wHttpEndpoint);
        FormData fdHttpEndpoint = new FormData();
        fdHttpEndpoint.left = new FormAttachment(middle, 0);
        fdHttpEndpoint.top = new FormAttachment((Control)lastControl, margin);
        fdHttpEndpoint.right = new FormAttachment(100, 0);
        this.wHttpEndpoint.addModifyListener(lsMod);
        this.wHttpEndpoint.addFocusListener(lsFocusLost);
        this.wHttpEndpoint.setLayoutData((Object)fdHttpEndpoint);
        lastControl = this.wHttpEndpoint;
        this.wlBatchSize = new Label(wMainComp, 131072);
        this.wlBatchSize.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.HTTPEndpointBatchSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        fdlBatchSize.top = new FormAttachment((Control)lastControl, margin);
        this.wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, wMainComp, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        this.wBatchSize.addModifyListener(lsMod);
        this.wBatchSize.addFocusListener(lsFocusLost);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.top = new FormAttachment((Control)lastControl, margin);
        fdBatchSize.right = new FormAttachment(100, 0);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        lastControl = this.wBatchSize;
        Label wlSpecifyFields = new Label(wMainComp, 131072);
        wlSpecifyFields.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.SpecifyFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSpecifyFields);
        FormData fdlSpecifyFields = new FormData();
        fdlSpecifyFields.top = new FormAttachment((Control)lastControl, margin);
        fdlSpecifyFields.left = new FormAttachment(0, 0);
        fdlSpecifyFields.right = new FormAttachment(middle, -margin);
        wlSpecifyFields.setLayoutData((Object)fdlSpecifyFields);
        this.wSpecifyFields = new Button(wMainComp, 32);
        PropsUi.setLook((Widget)this.wSpecifyFields);
        FormData fdSpecifyFields = new FormData();
        fdSpecifyFields.top = new FormAttachment((Control)lastControl, margin);
        fdSpecifyFields.left = new FormAttachment(middle, 0);
        fdSpecifyFields.right = new FormAttachment(100, 0);
        this.wSpecifyFields.setLayoutData((Object)fdSpecifyFields);
        this.wSpecifyFields.addSelectionListener((SelectionListener)lsSelMod);
        this.wSpecifyFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CrateDBBulkLoaderDialog.this.toggleSpecifyFieldsFlags();
            }
        });
        lastControl = this.wSpecifyFields;
        this.wlStreamToRemoteCsv = new Label(wMainComp, 131072);
        this.wlStreamToRemoteCsv.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.StreamCsvToRemote.Label", (String[])new String[0]));
        this.wlStreamToRemoteCsv.setToolTipText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.StreamCsvToRemote.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlStreamToRemoteCsv);
        FormData fdlStreamCsvToRemote = new FormData();
        fdlStreamCsvToRemote.top = new FormAttachment((Control)lastControl, margin);
        fdlStreamCsvToRemote.left = new FormAttachment(0, 0);
        fdlStreamCsvToRemote.right = new FormAttachment(middle, -margin);
        this.wlStreamToRemoteCsv.setLayoutData((Object)fdlStreamCsvToRemote);
        this.wStreamToRemoteCsv = new Button(wMainComp, 32);
        this.wStreamToRemoteCsv.setToolTipText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.StreamCsvToRemote.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wStreamToRemoteCsv);
        FormData fdStreamCsvToRemote = new FormData();
        fdStreamCsvToRemote.top = new FormAttachment((Control)lastControl, margin);
        fdStreamCsvToRemote.left = new FormAttachment(middle, 0);
        fdStreamCsvToRemote.right = new FormAttachment(100, 0);
        this.wStreamToRemoteCsv.setLayoutData((Object)fdStreamCsvToRemote);
        this.wStreamToRemoteCsv.setSelection(true);
        lastControl = this.wStreamToRemoteCsv;
        this.wlLocalRemoteVolumeMapping = new Label(wMainComp, 131072);
        this.wlLocalRemoteVolumeMapping.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.LocalRemoteVolumeMapping.Label", (String[])new String[0]));
        this.wlLocalRemoteVolumeMapping.setToolTipText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.LocalRemoteVolumeMapping.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLocalRemoteVolumeMapping);
        FormData fdlLocalRemoteVolumeMapping = new FormData();
        fdlLocalRemoteVolumeMapping.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlLocalRemoteVolumeMapping.left = new FormAttachment(0, 0);
        fdlLocalRemoteVolumeMapping.right = new FormAttachment(middle, -margin);
        this.wlLocalRemoteVolumeMapping.setLayoutData((Object)fdlLocalRemoteVolumeMapping);
        this.wLocalRemoteVolumeMapping = new TextVar(this.variables, wMainComp, 18436);
        PropsUi.setLook((Widget)this.wLocalRemoteVolumeMapping);
        this.wLocalRemoteVolumeMapping.getTextWidget().setMessage(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.LocalRemoteVolumeMapping.Message", (String[])new String[0]));
        FormData fdLocalRemoteVolumeMapping = new FormData();
        fdLocalRemoteVolumeMapping.top = new FormAttachment((Control)lastControl, margin * 2);
        fdLocalRemoteVolumeMapping.left = new FormAttachment(middle, 0);
        fdLocalRemoteVolumeMapping.right = new FormAttachment(100, -margin);
        this.wLocalRemoteVolumeMapping.setLayoutData((Object)fdLocalRemoteVolumeMapping);
        lastControl = this.wLocalRemoteVolumeMapping;
        this.wlReadFromFile = new Label(wMainComp, 131072);
        this.wlReadFromFile.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.ReadFromFile.Label", (String[])new String[0]));
        this.wlReadFromFile.setToolTipText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.ReadFromFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlReadFromFile);
        FormData fdlReadFromFile = new FormData();
        fdlReadFromFile.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlReadFromFile.left = new FormAttachment(0, 0);
        fdlReadFromFile.right = new FormAttachment(middle, -margin);
        this.wlReadFromFile.setLayoutData((Object)fdlReadFromFile);
        this.wReadFromFilename = new TextVar(this.variables, wMainComp, 18436);
        PropsUi.setLook((Widget)this.wReadFromFilename);
        this.wReadFromFilename.addModifyListener(lsMod);
        this.wReadFromFilename.addFocusListener(lsFocusLost);
        this.wReadFromFilename.getTextWidget().setMessage(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.ReadFromFile.Message", (String[])new String[0]));
        FormData fdReadFromFile = new FormData();
        fdReadFromFile.top = new FormAttachment((Control)lastControl, margin * 2);
        fdReadFromFile.left = new FormAttachment(middle, 0);
        fdReadFromFile.right = new FormAttachment(100, -margin);
        this.wReadFromFilename.setLayoutData((Object)fdReadFromFile);
        wMainComp.layout();
        wMainTab.setControl((Control)wMainComp);
    }

    public void toggleHttpEndpointFlags() {
        boolean useHTTPEndpoint = this.wUseHTTPEndpoint.getSelection();
        this.wlHttpEndpoint.setEnabled(useHTTPEndpoint);
        this.wHttpEndpoint.setEnabled(useHTTPEndpoint);
        this.wlBatchSize.setEnabled(useHTTPEndpoint);
        this.wBatchSize.setEnabled(useHTTPEndpoint);
        this.wlHttpLogin.setEnabled(useHTTPEndpoint);
        this.wHttpLogin.setEnabled(useHTTPEndpoint);
        this.wlHttpPassword.setEnabled(useHTTPEndpoint);
        this.wHttpPassword.setEnabled(useHTTPEndpoint);
        this.wlStreamToRemoteCsv.setVisible(!useHTTPEndpoint);
        this.wStreamToRemoteCsv.setVisible(!useHTTPEndpoint);
        this.wlLocalRemoteVolumeMapping.setVisible(!useHTTPEndpoint);
        this.wLocalRemoteVolumeMapping.setVisible(!useHTTPEndpoint);
        this.wlReadFromFile.setVisible(!useHTTPEndpoint);
        this.wReadFromFilename.setVisible(!useHTTPEndpoint);
    }

    public void toggleSpecifyFieldsFlags() {
        boolean specifyFields = this.wSpecifyFields.getSelection();
        this.wFields.setEnabled(specifyFields);
        this.wGetFields.setEnabled(specifyFields);
        this.wDoMapping.setEnabled(specifyFields);
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setTablename(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMeta = this.transformMeta.getTransform();
        if (StringUtils.isEmpty((String)this.input.getConnection())) {
            this.input.setConnection(this.wConnection.getText());
        }
        try {
            targetFields = transformMeta.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wFields.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)196);
            boolean bl = goOn = (answer & 0x40) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            block11: {
                DatabaseMeta databaseMeta;
                for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                    ColumnInfo colInfo = this.tableFieldColumns.get(i);
                    colInfo.setComboValues(new String[0]);
                }
                if (!StringUtil.isEmpty((String)this.wTable.getText()) && (databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables)) != null) {
                    try (Database db = new Database(loggingObject, this.variables, databaseMeta);){
                        String[] fieldNames;
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, this.variables.resolve(this.wSchema.getText()), this.variables.resolve(this.wTable.getText()));
                        IRowMeta r = db.getTableFields(schemaTable);
                        if (null == r || null == (fieldNames = r.getFieldNames())) break block11;
                        for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                            ColumnInfo colInfo = this.tableFieldColumns.get(i);
                            colInfo.setComboValues(fieldNames);
                        }
                    }
                    catch (Exception e) {
                        for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                            ColumnInfo colInfo = this.tableFieldColumns.get(i);
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        if (PropsUi.getInstance().isSortFieldByName()) {
            Const.sortStrings((String[])fieldNames);
        }
        this.ciFields[1].setComboValues(fieldNames);
    }

    public void getData() {
        if (!StringUtils.isEmpty((String)this.input.getConnection())) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (!StringUtils.isEmpty((String)this.input.getSchemaName())) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (!StringUtils.isEmpty((String)this.input.getTableName())) {
            this.wTable.setText(this.input.getTableName());
        }
        this.wUseHTTPEndpoint.setSelection(this.input.isUseHttpEndpoint());
        if (this.input.isUseHttpEndpoint()) {
            this.wHttpEndpoint.setText(this.input.getHttpEndpoint());
            this.wBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
            this.wHttpLogin.setText(Const.NVL((String)this.input.getHttpLogin(), (String)""));
            this.wHttpPassword.setText(Const.NVL((String)this.input.getHttpPassword(), (String)""));
        }
        this.wUseSystemVars.setSelection(this.input.isUseSystemEnvVars());
        if (!this.input.isUseSystemEnvVars()) {
            if (!StringUtil.isEmpty((String)this.input.getAwsAccessKeyId())) {
                this.wAccessKeyId.setText(this.input.getAwsAccessKeyId());
            }
            if (!StringUtils.isEmpty((String)this.input.getAwsSecretAccessKey())) {
                this.wSecretAccessKey.setText(this.input.getAwsSecretAccessKey());
            }
        }
        this.wStreamToRemoteCsv.setSelection(this.input.isStreamToS3Csv());
        if (!StringUtils.isEmpty((String)this.input.getReadFromFilename())) {
            this.wReadFromFilename.setText(this.input.getReadFromFilename());
        }
        if (!StringUtils.isEmpty((String)this.input.getVolumeMapping())) {
            this.wLocalRemoteVolumeMapping.setText(this.input.getVolumeMapping());
        }
        this.wSpecifyFields.setSelection(this.input.specifyFields());
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            CrateDBBulkLoaderField vbf = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            if (vbf.getDatabaseField() != null) {
                item.setText(1, vbf.getDatabaseField());
            }
            if (vbf.getStreamField() == null) continue;
            item.setText(2, vbf.getStreamField());
        }
        this.wTransformName.selectAll();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(CrateDBBulkLoaderMeta info) {
        if (!StringUtils.isEmpty((String)this.wConnection.getText())) {
            info.setConnection(this.wConnection.getText());
        }
        if (!StringUtils.isEmpty((String)this.wSchema.getText())) {
            info.setSchemaName(this.wSchema.getText());
        }
        if (!StringUtils.isEmpty((String)this.wTable.getText())) {
            info.setTablename(this.wTable.getText());
        }
        info.setUseHttpEndpoint(this.wUseHTTPEndpoint.getSelection());
        if (this.wUseHTTPEndpoint.getSelection()) {
            info.setHttpEndpoint(this.wHttpEndpoint.getText());
            info.setBatchSize(this.wBatchSize.getText());
            info.setHttpLogin(this.wHttpLogin.getText());
            info.setHttpPassword(this.wHttpPassword.getText());
        }
        if (this.wUseSystemVars.getSelection()) {
            info.setUseSystemEnvVars(this.wUseSystemVars.getSelection());
        } else {
            info.setUseSystemEnvVars(this.wUseSystemVars.getSelection());
            if (!StringUtils.isEmpty((String)this.wAccessKeyId.getText())) {
                info.setAwsAccessKeyId(this.wAccessKeyId.getText());
            }
            if (!StringUtil.isEmpty((String)this.wSecretAccessKey.getText())) {
                info.setAwsSecretAccessKey(this.wSecretAccessKey.getText());
            }
        }
        info.setStreamToS3Csv(this.wStreamToRemoteCsv.getSelection());
        if (!StringUtils.isEmpty((String)this.wReadFromFilename.getText())) {
            info.setReadFromFilename(this.wReadFromFilename.getText());
        }
        info.setSpecifyFields(this.wSpecifyFields.getSelection());
        info.setVolumeMapping(this.wLocalRemoteVolumeMapping.getText());
        int nrRows = this.wFields.nrNonEmpty();
        info.getFields().clear();
        for (int i = 0; i < nrRows; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            CrateDBBulkLoaderField vbf = new CrateDBBulkLoaderField(Const.NVL((String)item.getText(1), (String)""), Const.NVL((String)item.getText(2), (String)""));
            info.getFields().add(vbf);
        }
    }

    private void ok() {
        if (StringUtil.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        if (Utils.isEmpty((CharSequence)this.input.getConnection())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.ConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString((String)SYSTEM_DIALOG_ERROR_TITLE));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void getSchemaName() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    org.apache.hop.ui.core.dialog.MessageBox mb = new org.apache.hop.ui.core.dialog.MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)SYSTEM_DIALOG_ERROR_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
        }
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtil.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[]{databaseMeta.toString()})});
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString((String)SYSTEM_DIALOG_ERROR_TITLE));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void sql() {
        try {
            SqlStatement sql;
            CrateDBBulkLoaderMeta info = new CrateDBBulkLoaderMeta();
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
            this.getInfo(info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (info.specifyFields()) {
                RowMeta prevNew = new RowMeta();
                for (int i = 0; i < info.getFields().size(); ++i) {
                    CrateDBBulkLoaderField vbf = info.getFields().get(i);
                    IValueMeta insValue = prev.searchValueMeta(vbf.getStreamField());
                    if (insValue == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.FailedToFindField.Message", (String[])new String[]{vbf.getStreamField()}));
                    }
                    IValueMeta insertValue = insValue.clone();
                    insertValue.setName(vbf.getDatabaseField());
                    prevNew.addValueMeta(insertValue);
                }
                prev = prevNew;
            }
            if (!(sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider)).hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.NoSQL.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.NoSQL.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString((String)SYSTEM_DIALOG_ERROR_TITLE));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void toggleKeysSelection() {
        this.wlAccessKeyId.setEnabled(!this.wUseSystemVars.getSelection());
        this.wAccessKeyId.setEnabled(!this.wUseSystemVars.getSelection());
        this.wlSecretAccessKey.setEnabled(!this.wUseSystemVars.getSelection());
        this.wSecretAccessKey.setEnabled(!this.wUseSystemVars.getSelection());
    }
}

