/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.flattener;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.flattener.Flattener;
import org.apache.hop.pipeline.transforms.flattener.FlattenerData;

@Transform(id="Flattener,Flatterner", image="flattener.svg", name="i18n::RowFlattener.Name", description="i18n::RowFlattener.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::FlattenerMeta.keyword"}, documentationUrl="/pipeline/transforms/rowflattener.html")
public class FlattenerMeta
extends BaseTransformMeta<Flattener, FlattenerData> {
    private static final Class<?> PKG = FlattenerMeta.class;
    @HopMetadataProperty(key="field_name")
    private String fieldName;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<FField> targetFields = new ArrayList<FField>();

    public FlattenerMeta() {
    }

    public FlattenerMeta(FlattenerMeta m) {
        this();
        this.fieldName = m.fieldName;
        m.targetFields.forEach(f -> this.targetFields.add(new FField((FField)f)));
    }

    public FlattenerMeta clone() {
        return new FlattenerMeta(this);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.fieldName != null && this.fieldName.length() > 0) {
            int idx = row.indexOfValue(this.fieldName);
            if (idx < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"FlattenerMeta.Exception.UnableToLocateFieldInInputFields", (String[])new String[]{this.fieldName}));
            }
            IValueMeta v = row.getValueMeta(idx);
            row.removeValueMeta(idx);
            for (FField targetField : this.targetFields) {
                IValueMeta value = v.clone();
                value.setName(targetField.getName());
                value.setOrigin(name);
                row.addValueMeta(value);
            }
        } else {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"FlattenerMeta.Exception.FlattenFieldRequired", (String[])new String[0]));
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FlattenerMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FlattenerMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<FField> getTargetFields() {
        return this.targetFields;
    }

    public void setTargetFields(List<FField> targetFields) {
        this.targetFields = targetFields;
    }

    public static final class FField {
        @HopMetadataProperty(key="name")
        private String name;

        public FField() {
        }

        public FField(FField f) {
            this.name = f.name;
        }

        public FField(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

