/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonScope;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import okio.BufferedSink;

final class BufferedSinkJsonWriter
extends JsonWriter {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private final BufferedSink sink;
    private final int[] stack = new int[32];
    private int stackSize = 0;
    private final String[] pathNames;
    private final int[] pathIndices;
    private String indent;
    private String separator;
    private boolean lenient;
    private String deferredName;
    private boolean serializeNulls;
    private boolean promoteNameToValue;

    BufferedSinkJsonWriter(BufferedSink sink) {
        this.push(6);
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        this.separator = ":";
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        this.sink = sink;
    }

    @Override
    public final void setIndent(String indent) {
        if (indent.length() == 0) {
            this.indent = null;
            this.separator = ":";
        } else {
            this.indent = indent;
            this.separator = ": ";
        }
    }

    @Override
    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public boolean isLenient() {
        return this.lenient;
    }

    @Override
    public final void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    @Override
    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    @Override
    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, "[");
    }

    @Override
    public JsonWriter endArray() throws IOException {
        return this.close(1, 2, "]");
    }

    @Override
    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, "{");
    }

    @Override
    public JsonWriter endObject() throws IOException {
        this.promoteNameToValue = false;
        return this.close(3, 5, "}");
    }

    private JsonWriter open(int empty, String openBracket) throws IOException {
        this.beforeValue();
        this.push(empty);
        this.pathIndices[this.stackSize - 1] = 0;
        this.sink.writeUtf8(openBracket);
        return this;
    }

    private JsonWriter close(int empty, int nonempty, String closeBracket) throws IOException {
        int context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        this.pathNames[this.stackSize] = null;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        if (context == nonempty) {
            this.newline();
        }
        this.sink.writeUtf8(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            throw new JsonDataException("Nesting too deep at " + this.getPath() + ": circular reference?");
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    @Override
    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        this.deferredName = name;
        this.pathNames[this.stackSize - 1] = name;
        this.promoteNameToValue = false;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            BufferedSinkJsonWriter.string(this.sink, this.deferredName);
            this.deferredName = null;
        }
    }

    @Override
    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        if (this.promoteNameToValue) {
            return this.name(value);
        }
        this.writeDeferredName();
        this.beforeValue();
        BufferedSinkJsonWriter.string(this.sink, value);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.sink.writeUtf8("null");
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(boolean value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.sink.writeUtf8(value ? "true" : "false");
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(Boolean value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((boolean)value);
    }

    @Override
    public JsonWriter value(double value) throws IOException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        if (this.promoteNameToValue) {
            return this.name(Double.toString(value));
        }
        this.writeDeferredName();
        this.beforeValue();
        this.sink.writeUtf8(Double.toString(value));
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(long value) throws IOException {
        if (this.promoteNameToValue) {
            return this.name(Long.toString(value));
        }
        this.writeDeferredName();
        this.beforeValue();
        this.sink.writeUtf8(Long.toString(value));
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        String string = value.toString();
        if (!this.lenient && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        if (this.promoteNameToValue) {
            return this.name(string);
        }
        this.writeDeferredName();
        this.beforeValue();
        this.sink.writeUtf8(string);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.sink.flush();
    }

    @Override
    public void close() throws IOException {
        this.sink.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    static void string(BufferedSink sink, String value) throws IOException {
        String[] replacements = REPLACEMENT_CHARS;
        sink.writeByte(34);
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = replacements[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                sink.writeUtf8(value, last, i);
            }
            sink.writeUtf8(replacement);
            last = i + 1;
        }
        if (last < length) {
            sink.writeUtf8(value, last, length);
        }
        sink.writeByte(34);
    }

    private void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.sink.writeByte(10);
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.sink.writeUtf8(this.indent);
        }
    }

    private void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.sink.writeByte(44);
        } else if (context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.sink.writeByte(44);
                this.newline();
                break;
            }
            case 4: {
                this.sink.writeUtf8(this.separator);
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    @Override
    void promoteNameToValue() throws IOException {
        int context = this.peek();
        if (context != 5 && context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.promoteNameToValue = true;
    }

    @Override
    public String getPath() {
        return JsonScope.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            BufferedSinkJsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        BufferedSinkJsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        BufferedSinkJsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        BufferedSinkJsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        BufferedSinkJsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        BufferedSinkJsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        BufferedSinkJsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        BufferedSinkJsonWriter.REPLACEMENT_CHARS[12] = "\\f";
    }
}

