/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.internal;

import com.amazonaws.services.dynamodbv2.document.Page;
import com.amazonaws.services.dynamodbv2.document.internal.PageIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorSupport<T, R>
implements Iterator<T> {
    final PageIterator<T, R> resourcePageIterator;
    private Iterator<T> localResourceIterator;
    private T resource;

    IteratorSupport(PageIterator<T, R> resourcePageIterator) {
        this.resourcePageIterator = resourcePageIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.resource != null) {
            return true;
        }
        this.resource = this.nextResource();
        return this.resource != null;
    }

    @Override
    public T next() {
        T rval = this.resource;
        if (rval == null) {
            rval = this.nextResource();
            if (rval == null) {
                throw new NoSuchElementException("No more elements");
            }
        } else {
            this.resource = null;
        }
        return rval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Collection is read-only");
    }

    private T nextResource() {
        while (this.localResourceIterator == null || !this.localResourceIterator.hasNext()) {
            if (!this.resourcePageIterator.hasNext()) {
                return null;
            }
            Object resourcePage = this.resourcePageIterator.next();
            this.localResourceIterator = ((Page)resourcePage).iterator();
        }
        return this.localResourceIterator.next();
    }
}

