/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git.info;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.git.GitGuiPlugin;
import org.apache.hop.git.HopDiff;
import org.apache.hop.git.model.UIFile;
import org.apache.hop.git.model.UIGit;
import org.apache.hop.git.model.revision.ObjectRevision;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.apache.hop.workflow.WorkflowMeta;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GitInfoExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler
implements IExplorerFileTypeHandler,
Listener {
    public static final String CONST_GIT = "git: ";
    public static final String CONST_S_S_S = "%s (%s -> %s)";
    private String id = UUID.randomUUID().toString();
    private Composite parentComposite;
    private Text wFile;
    private Text wStatus;
    private Text wBranch;
    private TableView wFiles;
    private TableView wRevisions;
    private Composite wDiffComposite;
    private Text wDiff;
    private Button wbDiff;

    public GitInfoExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GitInfoExplorerFileTypeHandler that = (GitInfoExplorerFileTypeHandler)((Object)o);
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public void renderFile(Composite composite) {
        this.parentComposite = composite;
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        Label wlFile = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlFile);
        wlFile.setText("File or folder");
        FormData fdlFile = new FormData();
        fdlFile.left = new FormAttachment(0, 0);
        fdlFile.top = new FormAttachment(0, 0);
        wlFile.setLayoutData((Object)fdlFile);
        this.wFile = new Text(composite, 18436);
        this.wFile.setEditable(false);
        PropsUi.setLook((Widget)this.wFile);
        FormData fdFile = new FormData();
        fdFile.left = new FormAttachment((Control)wlFile, 2 * margin);
        fdFile.top = new FormAttachment((Control)wlFile, 0, 0x1000000);
        fdFile.right = new FormAttachment(100, 0);
        this.wFile.setLayoutData((Object)fdFile);
        Text lastControl = this.wFile;
        Label wlStatus = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlStatus);
        wlStatus.setText("Status");
        FormData fdlStatus = new FormData();
        fdlStatus.left = new FormAttachment(0, 0);
        fdlStatus.top = new FormAttachment((Control)lastControl, margin);
        wlStatus.setLayoutData((Object)fdlStatus);
        this.wStatus = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wStatus);
        this.wStatus.setEditable(false);
        FormData fdStatus = new FormData();
        fdStatus.left = new FormAttachment((Control)wlFile, 2 * margin);
        fdStatus.top = new FormAttachment((Control)wlStatus, 0, 0x1000000);
        fdStatus.right = new FormAttachment(100, 0);
        this.wStatus.setLayoutData((Object)fdStatus);
        lastControl = this.wStatus;
        Label wlBranch = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlBranch);
        wlBranch.setText("Branch");
        FormData fdlBranch = new FormData();
        fdlBranch.left = new FormAttachment(0, 0);
        fdlBranch.top = new FormAttachment((Control)lastControl, margin);
        wlBranch.setLayoutData((Object)fdlBranch);
        this.wBranch = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wBranch);
        this.wBranch.setEditable(false);
        FormData fdBranch = new FormData();
        fdBranch.left = new FormAttachment((Control)wlFile, 2 * margin);
        fdBranch.top = new FormAttachment((Control)wlBranch, 0, 0x1000000);
        fdBranch.right = new FormAttachment(100, 0);
        this.wBranch.setLayoutData((Object)fdBranch);
        lastControl = this.wBranch;
        Label wlRevisions = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlRevisions);
        wlRevisions.setText("Revisions");
        FormData fdlRevisions = new FormData();
        fdlRevisions.left = new FormAttachment(0, 0);
        fdlRevisions.top = new FormAttachment((Control)lastControl, margin);
        fdlRevisions.right = new FormAttachment(100, 0);
        wlRevisions.setLayoutData((Object)fdlRevisions);
        lastControl = wlRevisions;
        ColumnInfo[] revisionColumns = new ColumnInfo[]{new ColumnInfo("RevisionId", 1), new ColumnInfo("Creation", 1), new ColumnInfo("Login", 1), new ColumnInfo("Comment", 1)};
        this.wRevisions = new TableView(this.hopGui.getVariables(), composite, 2048, revisionColumns, 1, null, props);
        this.wRevisions.setReadonly(true);
        PropsUi.setLook((Widget)this.wRevisions);
        FormData fdRevisions = new FormData();
        fdRevisions.left = new FormAttachment(0, 0);
        fdRevisions.top = new FormAttachment((Control)lastControl, margin);
        fdRevisions.right = new FormAttachment(100, 0);
        fdRevisions.bottom = new FormAttachment(40, 0);
        this.wRevisions.setLayoutData((Object)fdRevisions);
        this.wRevisions.table.addListener(13, e -> this.refreshChangedFiles());
        lastControl = this.wRevisions;
        Label wlFiles = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlFiles);
        wlFiles.setText("Changed files");
        FormData fdlFiles = new FormData();
        fdlFiles.left = new FormAttachment(0, 0);
        fdlFiles.right = new FormAttachment(100, 0);
        fdlFiles.top = new FormAttachment((Control)lastControl, margin);
        wlFiles.setLayoutData((Object)fdlFiles);
        lastControl = wlFiles;
        SashForm sashForm = new SashForm(composite, 256);
        PropsUi.setLook((Widget)sashForm);
        FormData fdSashForm = new FormData();
        fdSashForm.left = new FormAttachment(0, 0);
        fdSashForm.right = new FormAttachment(100, 0);
        fdSashForm.top = new FormAttachment((Control)lastControl, margin);
        fdSashForm.bottom = new FormAttachment(100, 0);
        sashForm.setLayoutData((Object)fdSashForm);
        ColumnInfo[] filesColumns = new ColumnInfo[]{new ColumnInfo("Filename", 1), new ColumnInfo("Status", 1), new ColumnInfo("Staged", 2, new String[]{"Y", "N"})};
        this.wFiles = new TableView(this.hopGui.getVariables(), (Composite)sashForm, 2048, filesColumns, 1, null, props);
        this.wFiles.setReadonly(true);
        PropsUi.setLook((Widget)this.wFiles);
        this.wFiles.table.addListener(13, e -> this.fileSelected());
        this.wDiffComposite = new Composite((Composite)sashForm, 0);
        this.wDiffComposite.setLayout((Layout)new FormLayout());
        this.wbDiff = new Button(this.wDiffComposite, 8);
        PropsUi.setLook((Widget)this.wbDiff);
        this.wbDiff.setEnabled(false);
        this.wbDiff.setText("Visual diff");
        this.wbDiff.addListener(13, e -> this.showHopFileDiff());
        FormData fdbDiff = new FormData();
        fdbDiff.right = new FormAttachment(100, 0);
        fdbDiff.top = new FormAttachment(0, 0);
        this.wbDiff.setLayoutData((Object)fdbDiff);
        Label wlDiff = new Label(this.wDiffComposite, 16388);
        PropsUi.setLook((Widget)wlDiff);
        wlDiff.setText("Select a file to see the text diff below:");
        FormData fdlDiff = new FormData();
        fdlDiff.left = new FormAttachment(0, 0);
        fdlDiff.right = new FormAttachment((Control)this.wbDiff, -margin);
        fdlDiff.top = new FormAttachment((Control)this.wbDiff, 0, 0x1000000);
        wlDiff.setLayoutData((Object)fdlDiff);
        this.wDiff = new Text(this.wDiffComposite, 2818);
        PropsUi.setLook((Widget)this.wDiff);
        FormData fdDiff = new FormData();
        fdDiff.left = new FormAttachment(0, 0);
        fdDiff.right = new FormAttachment(100, 0);
        fdDiff.top = new FormAttachment((Control)this.wbDiff, margin);
        fdDiff.bottom = new FormAttachment(100, 0);
        this.wDiff.setLayoutData((Object)fdDiff);
        sashForm.setWeights(new int[]{40, 60});
        this.refresh();
        this.perspective.getTree().addListener(13, (Listener)this);
    }

    public void showHopFileDiff() {
        if (this.wFiles.getSelectionIndices().length == 0) {
            return;
        }
        TableItem fileItem = this.wFiles.table.getSelection()[0];
        String filename = fileItem.getText(1);
        if (StringUtils.isEmpty((String)filename)) {
            return;
        }
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        try {
            String commitIdOld;
            String commitIdNew;
            TableItem revisionItem = this.wRevisions.table.getSelection()[0];
            String revisionId = revisionItem.getText(1);
            boolean workingTree = "WORKINGTREE".equals(revisionId);
            boolean staged = "Y".equalsIgnoreCase(fileItem.getText(3));
            if (workingTree) {
                commitIdNew = "WORKINGTREE";
                commitIdOld = "HEAD";
            } else {
                commitIdNew = revisionId;
                commitIdOld = git.getParentCommitId(revisionId);
                if (commitIdOld == null) {
                    return;
                }
            }
            if (commitIdNew.equals(commitIdOld)) {
                return;
            }
            HopDataOrchestrationPerspective dop = HopGui.getDataOrchestrationPerspective();
            if (dop.getPipelineFileType().isHandledBy(filename, false)) {
                this.showPipelineFileDiff(filename, commitIdNew, commitIdOld);
            } else if (dop.getWorkflowFileType().isHandledBy(filename, false)) {
                this.showWorkflowFileDiff(filename, commitIdNew, commitIdOld);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error while doing visual diff on file : " + filename, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPipelineFileDiff(String filename, String commitIdNew, String commitIdOld) throws HopException {
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        InputStream xmlStreamOld = null;
        InputStream xmlStreamNew = null;
        try {
            xmlStreamOld = git.open(filename, commitIdOld);
            xmlStreamNew = git.open(filename, commitIdNew);
            PipelineMeta pipelineMetaOld = new PipelineMeta(xmlStreamOld, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            PipelineMeta pipelineMetaNew = new PipelineMeta(xmlStreamNew, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            pipelineMetaOld = HopDiff.compareTransforms(pipelineMetaOld, pipelineMetaNew, true);
            pipelineMetaOld = HopDiff.comparePipelineHops(pipelineMetaOld, pipelineMetaNew, true);
            pipelineMetaNew = HopDiff.compareTransforms(pipelineMetaNew, pipelineMetaOld, false);
            pipelineMetaNew = HopDiff.comparePipelineHops(pipelineMetaNew, pipelineMetaOld, false);
            pipelineMetaOld.setPipelineVersion(CONST_GIT + commitIdOld);
            pipelineMetaNew.setPipelineVersion(CONST_GIT + commitIdNew);
            pipelineMetaOld.setName(String.format(CONST_S_S_S, pipelineMetaOld.getName(), git.getShortenedName(commitIdOld), git.getShortenedName(commitIdNew)));
            pipelineMetaOld.setNameSynchronizedWithFilename(false);
            pipelineMetaNew.setName(String.format(CONST_S_S_S, pipelineMetaNew.getName(), git.getShortenedName(commitIdNew), git.getShortenedName(commitIdOld)));
            pipelineMetaNew.setNameSynchronizedWithFilename(false);
            HopDataOrchestrationPerspective dop = HopGui.getDataOrchestrationPerspective();
            dop.addPipeline(this.hopGui, pipelineMetaOld, dop.getPipelineFileType());
            dop.addPipeline(this.hopGui, pipelineMetaNew, dop.getPipelineFileType());
            dop.activate();
        }
        finally {
            try {
                if (xmlStreamOld != null) {
                    xmlStreamOld.close();
                }
                if (xmlStreamNew != null) {
                    xmlStreamNew.close();
                }
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error closing XML file after reading", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showWorkflowFileDiff(String filename, String commitIdNew, String commitIdOld) throws HopException {
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        InputStream xmlStreamOld = null;
        InputStream xmlStreamNew = null;
        try {
            xmlStreamOld = git.open(filename, commitIdOld);
            xmlStreamNew = git.open(filename, commitIdNew);
            WorkflowMeta workflowMetaOld = new WorkflowMeta(xmlStreamOld, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            WorkflowMeta workflowMetaNew = new WorkflowMeta(xmlStreamNew, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            workflowMetaOld = HopDiff.compareActions(workflowMetaOld, workflowMetaNew, true);
            workflowMetaOld = HopDiff.compareWorkflowHops(workflowMetaOld, workflowMetaNew, true);
            workflowMetaNew = HopDiff.compareActions(workflowMetaNew, workflowMetaOld, false);
            workflowMetaNew = HopDiff.compareWorkflowHops(workflowMetaNew, workflowMetaOld, false);
            workflowMetaOld.setWorkflowVersion(CONST_GIT + commitIdOld);
            workflowMetaNew.setWorkflowVersion(CONST_GIT + commitIdNew);
            workflowMetaOld.setName(String.format(CONST_S_S_S, workflowMetaOld.getName(), git.getShortenedName(commitIdOld), git.getShortenedName(commitIdNew)));
            workflowMetaOld.setNameSynchronizedWithFilename(false);
            workflowMetaNew.setName(String.format(CONST_S_S_S, workflowMetaNew.getName(), git.getShortenedName(commitIdNew), git.getShortenedName(commitIdOld)));
            workflowMetaNew.setNameSynchronizedWithFilename(false);
            HopDataOrchestrationPerspective dop = HopGui.getDataOrchestrationPerspective();
            dop.addWorkflow(this.hopGui, workflowMetaOld, dop.getWorkflowFileType());
            dop.addWorkflow(this.hopGui, workflowMetaNew, dop.getWorkflowFileType());
            dop.activate();
        }
        finally {
            try {
                if (xmlStreamOld != null) {
                    xmlStreamOld.close();
                }
                if (xmlStreamNew != null) {
                    xmlStreamNew.close();
                }
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error closing XML file after reading", (Throwable)e);
            }
        }
    }

    public void close() {
        this.perspective.getTree().removeListener(13, (Listener)this);
        super.close();
    }

    public void handleEvent(Event event) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || !this.parentComposite.isVisible()) {
            return;
        }
        ExplorerFile file = this.perspective.getSelectedFile();
        if (file == null) {
            return;
        }
        if (file.getFilename().equals(this.wFile.getText())) {
            this.refresh();
            return;
        }
        try {
            String relativePath = this.calculateRelativePath(this.perspective.getRootFolder(), file.getFilename());
            if (".".equals(relativePath)) {
                relativePath = "Git project root";
            }
            MessageBox box = new MessageBox(this.hopGui.getShell(), 196);
            box.setText("Change location?");
            box.setMessage("Do you want to change the location of the current git info view?" + Const.CR + Const.CR + relativePath);
            int answer = box.open();
            if ((answer & 0x40) != 0) {
                this.explorerFile = file;
                this.refresh();
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error calculating relative path to change git info view", (Throwable)e);
        }
    }

    public void refresh() {
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        List<Object> revisions = new ArrayList();
        try {
            String relativePath = this.calculateRelativePath(this.perspective.getRootFolder(), this.explorerFile.getFilename());
            revisions = git.getRevisions(relativePath);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting git object revisions for path: " + this.explorerFile.getFilename(), (Throwable)e);
        }
        this.wFile.setText(Const.NVL((String)this.explorerFile.getFilename(), (String)""));
        this.wStatus.setText(this.getStatusDescription(guiPlugin));
        this.wBranch.setText(Const.NVL((String)git.getBranch(), (String)""));
        this.wRevisions.removeAll();
        for (ObjectRevision objectRevision : revisions) {
            TableItem item = new TableItem(this.wRevisions.table, 0);
            item.setText(1, Const.NVL((String)objectRevision.getRevisionId(), (String)""));
            item.setText(2, this.getDateString(objectRevision.getCreationDate()));
            item.setText(3, Const.NVL((String)objectRevision.getLogin(), (String)""));
            item.setText(4, Const.NVL((String)objectRevision.getComment(), (String)""));
        }
        this.wRevisions.optimizeTableView();
        if (!revisions.isEmpty()) {
            this.wRevisions.setSelection(new int[]{0});
        }
        this.refreshChangedFiles();
    }

    private String calculateRelativePath(String rootFolder, String filename) throws HopFileException, FileSystemException {
        FileObject root = HopVfs.getFileObject((String)rootFolder);
        FileObject file = HopVfs.getFileObject((String)filename);
        return root.getName().getRelativeName(file.getName());
    }

    private void fileSelected() {
        String filename = this.showFileDiff();
        this.wbDiff.setEnabled(false);
        if (filename != null) {
            if (this.wRevisions.getSelectionIndex() == this.wRevisions.table.getItemCount() - 1) {
                return;
            }
            try {
                if (HopGui.getDataOrchestrationPerspective().getPipelineFileType().isHandledBy(filename, false)) {
                    this.wbDiff.setEnabled(true);
                }
                if (HopGui.getDataOrchestrationPerspective().getWorkflowFileType().isHandledBy(filename, false)) {
                    this.wbDiff.setEnabled(true);
                }
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error checking if this file is a pipeline or workflow: " + filename, (Throwable)e);
            }
        }
    }

    private String showFileDiff() {
        String diff;
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        if (this.wRevisions.getSelectionIndices().length == 0) {
            return null;
        }
        if (this.wFiles.getSelectionIndices().length == 0) {
            return null;
        }
        TableItem revisionItem = this.wRevisions.table.getSelection()[0];
        String revisionId = revisionItem.getText(1);
        boolean workingTree = "WORKINGTREE".equals(revisionId);
        TableItem fileItem = this.wFiles.table.getSelection()[0];
        String filename = fileItem.getText(1);
        boolean staged = "Y".equalsIgnoreCase(fileItem.getText(3));
        if (workingTree) {
            diff = staged ? git.diff("HEAD", "INDEX", filename) : git.diff("INDEX", "WORKINGTREE", filename);
        } else {
            String parentCommitId = git.getParentCommitId(revisionId);
            diff = git.diff(parentCommitId, revisionId, filename);
        }
        this.wDiff.setText(Const.NVL((String)diff, (String)""));
        return filename;
    }

    private void refreshChangedFiles() {
        ArrayList<UIFile> changedFiles;
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        String selectedFile = this.wFile.getText();
        String rootFolder = git.getDirectory();
        boolean showStaged = true;
        if (this.wRevisions.table.getSelectionCount() == 0) {
            changedFiles = new ArrayList<UIFile>(guiPlugin.getChangedFiles().values());
        } else {
            String revisionId = this.wRevisions.table.getSelection()[0].getText(1);
            if ("WORKINGTREE".equals(revisionId)) {
                changedFiles = new ArrayList();
                for (UIFile changedFile : guiPlugin.getChangedFiles().values()) {
                    if (!this.isFilteredPath(rootFolder, changedFile.getName(), selectedFile)) continue;
                    changedFiles.add(changedFile);
                }
            } else {
                showStaged = false;
                changedFiles = new ArrayList();
                try {
                    RevCommit commit = git.resolve(revisionId);
                    RevTree tree = commit.getTree();
                    try (TreeWalk treeWalk = new TreeWalk(git.getGit().getRepository());){
                        treeWalk.setRecursive(true);
                        treeWalk.reset((AnyObjectId)tree);
                        while (treeWalk.next()) {
                            String path = treeWalk.getPathString();
                            if (!this.isFilteredPath(rootFolder, path, selectedFile)) continue;
                            changedFiles.add(new UIFile(path, DiffEntry.ChangeType.MODIFY, false));
                        }
                    }
                }
                catch (Exception e) {
                    LogChannel.UI.logError("Error getting changed file in revision " + revisionId, (Throwable)e);
                }
            }
        }
        this.wFiles.removeAll();
        for (UIFile file : changedFiles) {
            TableItem item = new TableItem(this.wFiles.table, 0);
            item.setText(1, Const.NVL((String)file.getName(), (String)""));
            if (!showStaged) continue;
            item.setText(2, Const.NVL((String)file.getChangeType().name(), (String)""));
            item.setText(3, file.getIsStaged() != false ? "Y" : "N");
        }
        this.wFiles.optimizeTableView();
    }

    private boolean isFilteredPath(String root, String path, String selectedFile) {
        try {
            String relativeSelected = this.calculateRelativePath(root, selectedFile);
            if (".".equals(relativeSelected)) {
                return true;
            }
            return path.startsWith(relativeSelected);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getStatusDescription(GitGuiPlugin guiPlugin) {
        Map<String, UIFile> changedFiles = guiPlugin.getChangedFiles();
        Map<String, String> ignoredFiles = guiPlugin.getIgnoredFiles();
        UIFile file = changedFiles.get(this.explorerFile.getFilename());
        if (file == null) {
            String ignored = ignoredFiles.get(this.explorerFile.getFilename());
            if (ignored == null) {
                return "Not changed";
            }
            return "Ignored";
        }
        switch (file.getChangeType()) {
            case ADD: {
                return "Not added";
            }
            case COPY: {
                return "Copied";
            }
            case MODIFY: {
                return "Modified";
            }
            case DELETE: {
                return "Deleted";
            }
            case RENAME: {
                return "Renamed";
            }
        }
        return "Changed";
    }

    private String getDateString(Date date) {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date);
    }
}

