/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToHopFn
extends DoFn<String, HopRow> {
    private final String transformName;
    private final String rowMetaJson;
    private final String separator;
    private transient Counter inputCounter;
    private transient Counter writtenCounter;
    private static final Logger LOG = LoggerFactory.getLogger(StringToHopFn.class);
    private transient IRowMeta rowMeta;

    public StringToHopFn(String transformName, String rowMetaJson, String separator) {
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.separator = separator;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
            this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
            BeamHop.init();
            this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            Metrics.counter((String)"init", (String)this.transformName).inc();
        }
        catch (Exception e) {
            Metrics.counter((String)"error", (String)this.transformName).inc();
            LOG.error("Error in setup of converting input data into Hop rows : " + e.getMessage());
            throw new RuntimeException("Error in setup of converting input data into Hop rows", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            String inputString = (String)processContext.element();
            this.inputCounter.inc();
            String[] components = inputString.split(this.separator, -1);
            Object[] row = new Object[this.rowMeta.size()];
            for (int index = 0; index < this.rowMeta.size() && index < components.length; ++index) {
                String sourceString = components[index];
                IValueMeta valueMeta = this.rowMeta.getValueMeta(index);
                ValueMetaString stringMeta = new ValueMetaString("SourceString");
                stringMeta.setConversionMask(valueMeta.getConversionMask());
                try {
                    row[index] = valueMeta.convertDataFromString(sourceString, (IValueMeta)stringMeta, null, null, 0);
                    continue;
                }
                catch (HopValueException ve) {
                    throw new HopException("Unable to convert value '" + sourceString + "' to value : " + valueMeta.toStringMeta(), (Throwable)ve);
                }
            }
            processContext.output((Object)new HopRow(row));
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            Metrics.counter((String)"error", (String)this.transformName).inc();
            LOG.error("Error converting input data into Hop rows " + (String)processContext.element() + ", " + e.getMessage());
            throw new RuntimeException("Error converting input data into Hop rows", e);
        }
    }
}

