/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.persistence;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.persistence.PossibleInconsistentStateException;
import org.apache.flink.runtime.persistence.ResourceVersion;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.util.FlinkException;

public interface StateHandleStore<T extends Serializable, R extends ResourceVersion<R>> {
    public RetrievableStateHandle<T> addAndLock(String var1, T var2) throws PossibleInconsistentStateException, Exception;

    public void replace(String var1, R var2, T var3) throws PossibleInconsistentStateException, Exception;

    public R exists(String var1) throws Exception;

    public RetrievableStateHandle<T> getAndLock(String var1) throws Exception;

    public List<Tuple2<RetrievableStateHandle<T>, String>> getAllAndLock() throws Exception;

    public Collection<String> getAllHandles() throws Exception;

    public boolean releaseAndTryRemove(String var1) throws Exception;

    public void clearEntries() throws Exception;

    public void release(String var1) throws Exception;

    public void releaseAll() throws Exception;

    public static class AlreadyExistException
    extends FlinkException {
        private static final long serialVersionUID = 1L;

        public AlreadyExistException(String message, Throwable cause) {
            super(message, cause);
        }

        public AlreadyExistException(String message) {
            super(message);
        }
    }

    public static class NotExistException
    extends FlinkException {
        private static final long serialVersionUID = 1L;

        public NotExistException(String message, Throwable cause) {
            super(message, cause);
        }

        public NotExistException(String message) {
            super(message);
        }
    }
}

