/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.compression;

import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.io.compression.AirCompressorFactory;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.compression.Lz4BlockCompressionFactory;
import org.apache.flink.shaded.io.airlift.compress.lzo.LzoCompressor;
import org.apache.flink.shaded.io.airlift.compress.lzo.LzoDecompressor;
import org.apache.flink.shaded.io.airlift.compress.zstd.ZstdCompressor;
import org.apache.flink.shaded.io.airlift.compress.zstd.ZstdDecompressor;
import org.apache.flink.util.Preconditions;

public interface BlockCompressionFactory {
    public BlockCompressor getCompressor();

    public BlockDecompressor getDecompressor();

    public static BlockCompressionFactory createBlockCompressionFactory(String compressionFactoryName) {
        BlockCompressionFactory blockCompressionFactory;
        block13: {
            Object factoryObj;
            block12: {
                CompressionFactoryName compressionName;
                Preconditions.checkNotNull((Object)compressionFactoryName);
                try {
                    compressionName = CompressionFactoryName.valueOf(compressionFactoryName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    compressionName = null;
                }
                if (compressionName == null) break block12;
                switch (compressionName) {
                    case LZ4: {
                        blockCompressionFactory = new Lz4BlockCompressionFactory();
                        break block13;
                    }
                    case LZO: {
                        blockCompressionFactory = new AirCompressorFactory(new LzoCompressor(), new LzoDecompressor());
                        break block13;
                    }
                    case ZSTD: {
                        blockCompressionFactory = new AirCompressorFactory(new ZstdCompressor(), new ZstdDecompressor());
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException("Unknown CompressionMethod " + (Object)((Object)compressionName));
                    }
                }
            }
            try {
                factoryObj = Class.forName(compressionFactoryName).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalConfigurationException("Cannot load class " + compressionFactoryName, (Throwable)e);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Cannot create object for class " + compressionFactoryName, (Throwable)e);
            }
            if (factoryObj instanceof BlockCompressionFactory) {
                blockCompressionFactory = (BlockCompressionFactory)factoryObj;
            } else {
                throw new IllegalArgumentException("CompressionFactoryName should inherit from interface BlockCompressionFactory, or use the default compression codec.");
            }
        }
        Preconditions.checkNotNull((Object)blockCompressionFactory);
        return blockCompressionFactory;
    }

    public static enum CompressionFactoryName {
        LZ4,
        LZO,
        ZSTD;

    }
}

