/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.types;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.model.Record;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class ProcessRecordsInput {
    private Instant cacheEntryTime;
    private Instant cacheExitTime;
    private List<Record> records;
    private IRecordProcessorCheckpointer checkpointer;
    private Long millisBehindLatest;

    public List<Record> getRecords() {
        return this.records;
    }

    public ProcessRecordsInput withRecords(List<Record> records) {
        this.records = records;
        return this;
    }

    public IRecordProcessorCheckpointer getCheckpointer() {
        return this.checkpointer;
    }

    public ProcessRecordsInput withCheckpointer(IRecordProcessorCheckpointer checkpointer) {
        this.checkpointer = checkpointer;
        return this;
    }

    public Long getMillisBehindLatest() {
        return this.millisBehindLatest;
    }

    public ProcessRecordsInput withMillisBehindLatest(Long millisBehindLatest) {
        this.millisBehindLatest = millisBehindLatest;
        return this;
    }

    public ProcessRecordsInput withCacheEntryTime(Instant cacheEntryTime) {
        this.cacheEntryTime = cacheEntryTime;
        return this;
    }

    public ProcessRecordsInput withCacheExitTime(Instant cacheExitTime) {
        this.cacheExitTime = cacheExitTime;
        return this;
    }

    public Duration getTimeSpentInCache() {
        if (this.cacheEntryTime == null || this.cacheExitTime == null) {
            return Duration.ZERO;
        }
        return Duration.between(this.cacheEntryTime, this.cacheExitTime);
    }

    public Instant getCacheEntryTime() {
        return this.cacheEntryTime;
    }

    public Instant getCacheExitTime() {
        return this.cacheExitTime;
    }
}

