/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import java.awt.BorderLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

class DoubleClickList
extends JComponent
implements ItemSelectable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    JList list_;
    JScrollPane scrollPane_;
    transient Vector itemListeners_;

    public DoubleClickList(String[] items) {
        this.list_ = new JList<String>(items);
        this.list_.setSelectionMode(0);
        this.scrollPane_ = new JScrollPane(this.list_);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane_);
        this.initializeTransient();
    }

    public DoubleClickList(ListModel listModel) {
        this.list_ = new JList(listModel);
        this.list_.setSelectionMode(0);
        this.scrollPane_ = new JScrollPane(this.list_);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane_);
        this.initializeTransient();
    }

    @Override
    public void addItemListener(ItemListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.itemListeners_.addElement(listener);
    }

    public int getSelectedIndex() {
        return this.list_.getSelectedIndex();
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.list_.getSelectedValues();
    }

    private void initializeTransient() {
        this.itemListeners_ = new Vector();
        this.list_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object value;
                if (event.getClickCount() > 1 && (value = DoubleClickList.this.list_.getSelectedValue()) != null && DoubleClickList.this.list_.isEnabled()) {
                    ItemEvent event2 = new ItemEvent(DoubleClickList.this, 701, value, 1);
                    Enumeration list = DoubleClickList.this.itemListeners_.elements();
                    while (list.hasMoreElements()) {
                        ((ItemListener)list.nextElement()).itemStateChanged(event2);
                    }
                }
            }
        });
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.itemListeners_.removeElement(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.list_.setEnabled(enabled);
    }

    public void setListData(Object[] listData) {
        this.list_.setListData(listData);
    }

    public void setSelectedIndex(int selectedIndex) {
        this.list_.setSelectedIndex(selectedIndex);
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.list_.setVisibleRowCount(visibleRowCount);
    }
}

