/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import java.util.StringTokenizer;

abstract class Formatter {
    private static final String CLASS = "Formatter";

    Formatter() {
    }

    public static void jprintf(String fmt, Object[] args) {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "Formatterjprintf() " + Formatter.jsprintf(fmt, args));
        }
    }

    public static String jsnprintf(int maxlen, String fmt, Object[] args) {
        StringBuffer out = new StringBuffer(maxlen);
        StringTokenizer t = new StringTokenizer(fmt, "{}", true);
        boolean s = false;
        try {
            while (true) {
                String token;
                if (!(token = t.nextToken()).equals("{")) {
                    out.append(token);
                    continue;
                }
                token = t.nextToken();
                if (token.equals("{")) {
                    out.append(token);
                    continue;
                }
                StringBuffer varspec = new StringBuffer(20);
                while (!token.equals("}")) {
                    varspec.append(token);
                    token = t.nextToken();
                }
                StringTokenizer vars = new StringTokenizer(varspec.toString(), ", ", false);
                int n = Integer.decode(vars.nextToken());
                if (!vars.hasMoreElements()) {
                    out.append(args[n]);
                    continue;
                }
                int w = Integer.decode(vars.nextToken());
                if (w < 0) {
                    w = -w;
                }
                String j = vars.nextToken();
                String x = args[n].toString();
                int l = x.length();
                if (j.equalsIgnoreCase("r")) {
                    if (l < w) {
                        out.append(Formatter.repeater(" ", w - l)).append(x);
                        continue;
                    }
                    if (j.equals("r")) {
                        out.append(x);
                        continue;
                    }
                    out.append(x.substring(l - w));
                    continue;
                }
                if (j.equalsIgnoreCase("l")) {
                    if (l < w) {
                        out.append(x).append(Formatter.repeater(" ", w - l));
                        continue;
                    }
                    if (j.equals("l")) {
                        out.append(x);
                        continue;
                    }
                    out.append(x.substring(0, w));
                    continue;
                }
                out.append(args[n]);
            }
        }
        catch (Throwable throwable) {
            if (maxlen > 0 && out.length() > maxlen) {
                out.setLength(maxlen);
            }
            return out.toString();
        }
    }

    public static String jsprintf(String fmt, Object[] args) {
        return Formatter.jsnprintf(0, fmt, args);
    }

    public static String repeater(String s, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(s.length() * n);
        while (n-- > 0) {
            out.append(s);
        }
        return out.toString();
    }
}

