/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnectionPoolDataSource;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.ConnectionPool;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.PoolConnectionEventListener;
import com.ibm.as400.access.PoolMaintenance;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public class AS400JDBCConnectionPool
extends ConnectionPool
implements Serializable {
    static final long serialVersionUID = 4L;
    private boolean closed_;
    private AS400JDBCConnectionPoolDataSource dataSource_;
    transient long lastSingleThreadRun_;
    transient Vector activePool_;
    transient Vector availablePool_;
    transient Vector deadPool_;
    private transient PoolConnectionEventListener eventListener_;

    public AS400JDBCConnectionPool() {
        this.initializeTransient();
    }

    public AS400JDBCConnectionPool(AS400JDBCConnectionPoolDataSource dataSource) {
        this();
        try {
            this.setDataSource(dataSource);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void cleanupConnections() {
        Vector vector;
        boolean trace = JDTrace.isTraceOn();
        if (trace) {
            JDTrace.logInformation(this, "ConnectionPool cleanup...");
            JDTrace.logInformation(this, "   MaxLifeTime: " + this.getMaxLifetime());
            JDTrace.logInformation(this, "   MaxUseTime: " + this.getMaxUseTime());
            JDTrace.logInformation(this, "   MaxInactivity: " + this.getMaxInactivity());
            JDTrace.logInformation(this, "   PretestConnections: " + this.isPretestConnections());
            JDTrace.logInformation(this, "Idle Connections: " + this.availablePool_.size());
            JDTrace.logInformation(this, "Active Connections: " + this.activePool_.size());
            JDTrace.logInformation(this, "Dead Connections: " + this.deadPool_.size());
        }
        Vector vector2 = this.availablePool_;
        synchronized (vector2) {
            vector = this.activePool_;
            synchronized (vector) {
                Iterator[] connections = new Iterator[]{this.availablePool_.iterator(), this.activePool_.iterator()};
                for (int i = 0; i < connections.length; ++i) {
                    while (connections[i].hasNext()) {
                        ConnectionPoolEvent poolEvent;
                        AS400JDBCPooledConnection poolConnection = (AS400JDBCPooledConnection)connections[i].next();
                        if (trace) {
                            JDTrace.logInformation(this, poolConnection.toString());
                        }
                        if (!poolConnection.isInUse() && this.getMaxLifetime() != -1L && poolConnection.getLifeSpan() > this.getMaxLifetime() || !poolConnection.isInUse() && this.getMaxInactivity() != -1L && poolConnection.getInactivityTime() > this.getMaxInactivity()) {
                            if (trace) {
                                JDTrace.logInformation(this, "Removing expired connection from the pool.");
                            }
                            connections[i].remove();
                            Vector vector3 = this.deadPool_;
                            synchronized (vector3) {
                                this.deadPool_.addElement(poolConnection);
                            }
                            if (this.poolListeners_ == null) continue;
                            poolEvent = new ConnectionPoolEvent(poolConnection, 4);
                            this.poolListeners_.fireConnectionExpiredEvent(poolEvent);
                            continue;
                        }
                        if (this.getMaxUseTime() <= 0L || poolConnection.getInUseTime() <= this.getMaxUseTime()) continue;
                        if (trace) {
                            JDTrace.logInformation(this, "Returning active connection to the pool.");
                        }
                        poolConnection.returned();
                        this.availablePool_.add(poolConnection);
                        connections[i].remove();
                        if (this.poolListeners_ == null) continue;
                        poolEvent = new ConnectionPoolEvent(poolConnection, 4);
                        this.poolListeners_.fireConnectionExpiredEvent(poolEvent);
                    }
                }
            }
        }
        vector2 = this.deadPool_;
        synchronized (vector2) {
            Iterator connections = this.deadPool_.iterator();
            while (connections.hasNext()) {
                AS400JDBCPooledConnection poolConnection = (AS400JDBCPooledConnection)connections.next();
                if (trace) {
                    JDTrace.logInformation(this, poolConnection.toString());
                }
                if (trace) {
                    JDTrace.logInformation(this, "Removing dead connection from the pool.");
                }
                this.closePooledConnection(poolConnection);
                connections.remove();
            }
        }
        if (this.poolListeners_ != null) {
            ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 5);
            this.poolListeners_.fireMaintenanceThreadRun(poolEvent);
        }
        vector2 = this.availablePool_;
        synchronized (vector2) {
            vector = this.activePool_;
            synchronized (vector) {
                if (this.activePool_.isEmpty() && this.availablePool_.isEmpty()) {
                    if (this.maintenance_ != null) {
                        this.maintenance_.setRunning(false);
                    }
                    this.setInUse(false);
                }
            }
        }
        if (!this.isThreadUsed()) {
            this.lastSingleThreadRun_ = System.currentTimeMillis();
        }
        if (trace) {
            JDTrace.logInformation(this, "ConnectionPool cleanup finished.");
            JDTrace.logInformation(this, "   Idle Connections: " + this.availablePool_.size());
            JDTrace.logInformation(this, "   Active Connections: " + this.activePool_.size());
            JDTrace.logInformation(this, "   Dead Connections: " + this.deadPool_.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Closing the JDBC connection pool.");
            JDTrace.logInformation(this, "Available: " + this.availablePool_.size());
            JDTrace.logInformation(this, "Active: " + this.activePool_.size());
        }
        Serializable serializable = this.availablePool_;
        synchronized (serializable) {
            Vector vector = this.activePool_;
            synchronized (vector) {
                Vector vector2 = this.deadPool_;
                synchronized (vector2) {
                    Iterator[] connections = new Iterator[]{this.availablePool_.iterator(), this.activePool_.iterator(), this.deadPool_.iterator()};
                    for (int i = 0; i < connections.length; ++i) {
                        while (connections[i].hasNext()) {
                            AS400JDBCPooledConnection pooledConnection = (AS400JDBCPooledConnection)connections[i].next();
                            this.closePooledConnection(pooledConnection);
                            connections[i].remove();
                        }
                    }
                }
            }
        }
        if (this.maintenance_ != null && this.maintenance_.isAlive()) {
            this.maintenance_.shutdown();
        }
        serializable = this;
        synchronized (serializable) {
            if (this.isInUse()) {
                this.setInUse(false);
            }
        }
        if (this.poolListeners_ != null) {
            ConnectionPoolEvent event = new ConnectionPoolEvent(this, 0);
            this.poolListeners_.fireClosedEvent(event);
        }
        this.closed_ = true;
    }

    void closePooledConnection(AS400JDBCPooledConnection pooledConnection) {
        try {
            pooledConnection.close();
        }
        catch (SQLException e) {
            JDTrace.logInformation(this, e.getMessage());
        }
    }

    private AS400JDBCPooledConnection createPooledConnection() throws SQLException {
        if (this.dataSource_ == null) {
            throw new ExtendedIllegalStateException("dataSource", 4);
        }
        AS400JDBCPooledConnection pooledConnection = new AS400JDBCPooledConnection(this.dataSource_.getConnection());
        pooledConnection.addConnectionEventListener(this.eventListener_);
        this.dataSource_.log("PooledConnection created");
        return pooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(int numberOfConnections) throws ConnectionPoolException {
        Serializable serializable;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Filling the pool with " + numberOfConnections + " connections.");
        }
        if (numberOfConnections < 1) {
            throw new ExtendedIllegalArgumentException("numberOfConnections", 4);
        }
        int maxConnections = this.getMaxConnections();
        if (maxConnections != -1 && numberOfConnections + this.getActiveConnectionCount() + this.getAvailableConnectionCount() > maxConnections) {
            throw new ConnectionPoolException(1);
        }
        try {
            serializable = this.availablePool_;
            synchronized (serializable) {
                for (int i = 0; i < numberOfConnections; ++i) {
                    AS400JDBCPooledConnection poolConnection = this.createPooledConnection();
                    this.availablePool_.addElement(poolConnection);
                    if (this.poolListeners_ == null) continue;
                    ConnectionPoolEvent event = new ConnectionPoolEvent(poolConnection, 1);
                    this.poolListeners_.fireConnectionCreatedEvent(event);
                }
            }
        }
        catch (SQLException e) {
            if (this.isRunMaintenance() && this.maintenance_ != null) {
                this.cleanupConnections();
            }
            throw new ConnectionPoolException(e);
        }
        serializable = this;
        synchronized (serializable) {
            if (!this.isInUse()) {
                this.setInUse(true);
                if (this.isClosed()) {
                    this.closed_ = false;
                }
            }
        }
        if (this.isRunMaintenance() && this.isThreadUsed()) {
            if (this.maintenance_ == null) {
                serializable = this;
                synchronized (serializable) {
                    if (this.maintenance_ == null) {
                        this.maintenance_ = new PoolMaintenance(this);
                        this.maintenance_.start();
                    }
                }
            }
            if (!this.maintenance_.isRunning()) {
                this.maintenance_.setRunning(true);
            }
        } else if (this.isRunMaintenance() && !this.isThreadUsed()) {
            this.lastSingleThreadRun_ = System.currentTimeMillis();
        }
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.close();
        }
        super.finalize();
    }

    public int getActiveConnectionCount() {
        return this.activePool_.size();
    }

    public int getAvailableConnectionCount() {
        return this.availablePool_.size();
    }

    public Connection getConnection() throws ConnectionPoolException {
        AS400JDBCPooledConnection pooledConnection = this.getPooledConnection();
        Connection connection = null;
        try {
            connection = pooledConnection.getConnection();
        }
        catch (SQLException sql) {
            throw new ConnectionPoolException(sql);
        }
        return connection;
    }

    public AS400JDBCConnectionPoolDataSource getDataSource() {
        return this.dataSource_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AS400JDBCPooledConnection getPooledConnection() throws ConnectionPoolException {
        AS400JDBCPooledConnection pooledConnection = null;
        int maxTries = Math.max(this.getMaxConnections(), 1 + this.availablePool_.size());
        int numTries = 0;
        while (pooledConnection == null && ++numTries <= maxTries) {
            block16: {
                Vector vector = this.availablePool_;
                synchronized (vector) {
                    if (this.availablePool_.isEmpty()) {
                        this.fill(1);
                    }
                    pooledConnection = (AS400JDBCPooledConnection)this.availablePool_.lastElement();
                    this.availablePool_.removeElement(pooledConnection);
                }
                try {
                    if (!this.isPretestConnections() || pooledConnection.isConnectionAlive()) break block16;
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Connection failed a pretest.");
                    }
                    vector = this.deadPool_;
                    synchronized (vector) {
                        this.deadPool_.addElement(pooledConnection);
                    }
                    pooledConnection = null;
                }
                catch (SQLException sql) {
                    throw new ConnectionPoolException(sql);
                }
            }
            if (pooledConnection == null) continue;
            Vector sql = this.activePool_;
            synchronized (sql) {
                this.activePool_.addElement(pooledConnection);
            }
        }
        if (pooledConnection == null) {
            JDTrace.logInformation(this, "Exceeded maximum attempts to get a valid connection: " + numTries);
            throw new ConnectionPoolException(2);
        }
        if (this.poolListeners_ != null) {
            ConnectionPoolEvent event = new ConnectionPoolEvent(pooledConnection, 2);
            this.poolListeners_.fireConnectionReleasedEvent(event);
        }
        return pooledConnection;
    }

    private void initializeTransient() {
        this.eventListener_ = new PoolConnectionEventListener(this);
        this.activePool_ = new Vector();
        this.availablePool_ = new Vector();
        this.deadPool_ = new Vector();
        this.closed_ = true;
    }

    public boolean isClosed() {
        return this.closed_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reduceConnectionCount() {
        Vector vector = this.availablePool_;
        synchronized (vector) {
            Vector vector2 = this.activePool_;
            synchronized (vector2) {
                int current = this.availablePool_.size() + this.activePool_.size();
                int required = this.getMaxConnections();
                if (current > required) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Reducing number of connections... Current: " + current + "(" + this.availablePool_.size() + ")  Max: " + required);
                    }
                    int reduceBy = current - required;
                    for (int removed = 0; removed < reduceBy && this.availablePool_.size() != 0; ++removed) {
                        AS400JDBCPooledConnection poolConnection = (AS400JDBCPooledConnection)this.availablePool_.remove(0);
                        Vector vector3 = this.deadPool_;
                        synchronized (vector3) {
                            this.deadPool_.addElement(poolConnection);
                            continue;
                        }
                    }
                }
            }
        }
        vector = this.deadPool_;
        synchronized (vector) {
            Iterator deadConnections = this.deadPool_.iterator();
            while (deadConnections.hasNext()) {
                AS400JDBCPooledConnection poolConnection = (AS400JDBCPooledConnection)deadConnections.next();
                this.closePooledConnection(poolConnection);
                deadConnections.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runMaintenance(boolean reduced) {
        if (this.maintenance_ != null && this.maintenance_.isRunning()) {
            PoolMaintenance poolMaintenance = this.maintenance_;
            synchronized (poolMaintenance) {
                if (reduced) {
                    this.reduceConnectionCount();
                }
                this.maintenance_.notify();
            }
        }
    }

    public void setDataSource(AS400JDBCConnectionPoolDataSource dataSource) throws PropertyVetoException {
        String property = "dataSource";
        if (dataSource == null) {
            throw new NullPointerException(property);
        }
        if (this.isInUse()) {
            JDTrace.logInformation(this, "Connection pool data source is already in use.");
            throw new ExtendedIllegalStateException(property, 5);
        }
        AS400JDBCConnectionPoolDataSource old = this.dataSource_;
        this.dataSource_ = dataSource;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(property, old, dataSource);
        }
    }
}

