/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@VisibleForTesting
class BigQueryQuerySource<@UnknownKeyFor T>
extends BigQuerySourceBase<T> {
    private final @UnknownKeyFor @NonNull @Initialized BigQueryQuerySourceDef queryDef;

    static <T> @UnknownKeyFor @NonNull @Initialized BigQueryQuerySource<T> create(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized BigQueryQuerySourceDef queryDef, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T>> readerFactory, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        return new BigQueryQuerySource<T>(stepUuid, queryDef, bqServices, coder, readerFactory, useAvroLogicalTypes);
    }

    private BigQueryQuerySource(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized BigQueryQuerySourceDef queryDef, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T>> readerFactory, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        super(stepUuid, bqServices, coder, readerFactory, useAvroLogicalTypes);
        this.queryDef = queryDef;
    }

    public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.queryDef.getEstimatedSizeBytes((BigQueryOptions)options.as(BigQueryOptions.class));
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TableReference getTableToExtract(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.queryDef.getTableReference(bqOptions, this.stepUuid);
    }

    @Override
    protected void cleanupTempResource(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.queryDef.cleanupTempResource(bqOptions, this.stepUuid);
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"query", this.queryDef.getQuery()));
        builder.add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
    }
}

