/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsView;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.common.base.MoreObjects;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import java.io.IOException;
import javax.annotation.Nullable;

public final class DefaultMetricsProvider
implements MetricsProvider {
    public static DefaultMetricsProvider INSTANCE = new DefaultMetricsProvider();
    private OpenTelemetry openTelemetry;
    private String projectId;

    private DefaultMetricsProvider() {
    }

    @InternalApi
    public OpenTelemetry getOpenTelemetry(String projectId, String metricsEndpoint, @Nullable Credentials credentials) throws IOException {
        this.projectId = projectId;
        if (this.openTelemetry == null) {
            SdkMeterProviderBuilder meterProvider = SdkMeterProvider.builder();
            BuiltinMetricsView.registerBuiltinMetrics(projectId, credentials, meterProvider, metricsEndpoint);
            this.openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(meterProvider.build()).build();
        }
        return this.openTelemetry;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectId", (Object)this.projectId).add("openTelemetry", (Object)this.openTelemetry).toString();
    }
}

