/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models.sql;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ArrayValue;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.Type;
import com.google.bigtable.v2.Value;
import com.google.cloud.Date;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

@BetaApi
public class Statement {
    private static final Type STRING_TYPE = Type.newBuilder().setStringType(Type.String.getDefaultInstance()).build();
    private static final Type BYTES_TYPE = Type.newBuilder().setBytesType(Type.Bytes.getDefaultInstance()).build();
    private static final Type INT64_TYPE = Type.newBuilder().setInt64Type(Type.Int64.getDefaultInstance()).build();
    private static final Type FLOAT32_TYPE = Type.newBuilder().setFloat32Type(Type.Float32.getDefaultInstance()).build();
    private static final Type FLOAT64_TYPE = Type.newBuilder().setFloat64Type(Type.Float64.getDefaultInstance()).build();
    private static final Type BOOL_TYPE = Type.newBuilder().setBoolType(Type.Bool.getDefaultInstance()).build();
    private static final Type TIMESTAMP_TYPE = Type.newBuilder().setTimestampType(Type.Timestamp.getDefaultInstance()).build();
    private static final Type DATE_TYPE = Type.newBuilder().setDateType(Type.Date.getDefaultInstance()).build();
    private final String sql;
    private final Map<String, Value> params;

    private Statement(String sql, Map<String, Value> params) {
        this.sql = sql;
        this.params = params;
    }

    public static Statement of(String sql) {
        return Statement.newBuilder(sql).build();
    }

    public static Builder newBuilder(String sql) {
        return new Builder(sql);
    }

    @InternalApi(value="For internal use only")
    public ExecuteQueryRequest toProto(RequestContext requestContext) {
        return ExecuteQueryRequest.newBuilder().setInstanceName(NameUtil.formatInstanceName(requestContext.getProjectId(), requestContext.getInstanceId())).setAppProfileId(requestContext.getAppProfileId()).setQuery(this.sql).putAllParams(this.params).build();
    }

    public static class Builder {
        private final String sql;
        private final Map<String, Value> params;

        private Builder(String sql) {
            this.sql = sql;
            this.params = new HashMap<String, Value>();
        }

        public Statement build() {
            return new Statement(this.sql, (Map)ImmutableMap.copyOf(this.params));
        }

        public Builder setStringParam(String paramName, @Nullable String value) {
            this.params.put(paramName, Builder.stringParamOf(value));
            return this;
        }

        public Builder setBytesParam(String paramName, @Nullable ByteString value) {
            this.params.put(paramName, Builder.bytesParamOf(value));
            return this;
        }

        public Builder setLongParam(String paramName, @Nullable Long value) {
            this.params.put(paramName, Builder.int64ParamOf(value));
            return this;
        }

        public Builder setFloatParam(String paramName, @Nullable Float value) {
            this.params.put(paramName, Builder.float32ParamOf(value));
            return this;
        }

        public Builder setDoubleParam(String paramName, @Nullable Double value) {
            this.params.put(paramName, Builder.float64ParamOf(value));
            return this;
        }

        public Builder setBooleanParam(String paramName, @Nullable Boolean value) {
            this.params.put(paramName, Builder.booleanParamOf(value));
            return this;
        }

        public Builder setTimestampParam(String paramName, @Nullable Instant value) {
            this.params.put(paramName, Builder.timestampParamOf(value));
            return this;
        }

        public Builder setDateParam(String paramName, @Nullable Date value) {
            this.params.put(paramName, Builder.dateParamOf(value));
            return this;
        }

        public <T> Builder setListParam(String paramName, @Nullable List<T> value, SqlType.Array<T> arrayType) {
            this.params.put(paramName, Builder.arrayParamOf(value, arrayType));
            return this;
        }

        private static Value stringParamOf(@Nullable String value) {
            Value.Builder builder = Builder.nullValueWithType(STRING_TYPE);
            if (value != null) {
                builder.setStringValue(value);
            }
            return builder.build();
        }

        private static Value bytesParamOf(@Nullable ByteString value) {
            Value.Builder builder = Builder.nullValueWithType(BYTES_TYPE);
            if (value != null) {
                builder.setBytesValue(value);
            }
            return builder.build();
        }

        private static Value int64ParamOf(@Nullable Long value) {
            Value.Builder builder = Builder.nullValueWithType(INT64_TYPE);
            if (value != null) {
                builder.setIntValue(value.longValue());
            }
            return builder.build();
        }

        private static Value float32ParamOf(@Nullable Float value) {
            Value.Builder builder = Builder.nullValueWithType(FLOAT32_TYPE);
            if (value != null) {
                builder.setFloatValue((double)value.floatValue());
            }
            return builder.build();
        }

        private static Value float64ParamOf(@Nullable Double value) {
            Value.Builder builder = Builder.nullValueWithType(FLOAT64_TYPE);
            if (value != null) {
                builder.setFloatValue(value.doubleValue());
            }
            return builder.build();
        }

        private static Value booleanParamOf(@Nullable Boolean value) {
            Value.Builder builder = Builder.nullValueWithType(BOOL_TYPE);
            if (value != null) {
                builder.setBoolValue(value.booleanValue());
            }
            return builder.build();
        }

        private static Value timestampParamOf(@Nullable Instant value) {
            Value.Builder builder = Builder.nullValueWithType(TIMESTAMP_TYPE);
            if (value != null) {
                builder.setTimestampValue(Builder.toTimestamp(value));
            }
            return builder.build();
        }

        private static Value dateParamOf(@Nullable Date value) {
            Value.Builder builder = Builder.nullValueWithType(DATE_TYPE);
            if (value != null) {
                builder.setDateValue(Builder.toProtoDate(value));
            }
            return builder.build();
        }

        private static <T> Value arrayParamOf(@Nullable List<T> value, SqlType.Array<T> arrayType) {
            Type type = Type.newBuilder().setArrayType(Type.Array.newBuilder().setElementType(Builder.getElementType(arrayType)).build()).build();
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setArrayValue(Builder.arrayValueOf(value, arrayType));
            }
            return builder.build();
        }

        private static Type getElementType(SqlType.Array<?> arrayType) {
            switch (arrayType.getElementType().getCode()) {
                case BYTES: {
                    return BYTES_TYPE;
                }
                case STRING: {
                    return STRING_TYPE;
                }
                case INT64: {
                    return INT64_TYPE;
                }
                case FLOAT32: {
                    return FLOAT32_TYPE;
                }
                case FLOAT64: {
                    return FLOAT64_TYPE;
                }
                case BOOL: {
                    return BOOL_TYPE;
                }
                case TIMESTAMP: {
                    return TIMESTAMP_TYPE;
                }
                case DATE: {
                    return DATE_TYPE;
                }
            }
            throw new IllegalArgumentException("Unsupported query parameter Array element type: " + arrayType.getElementType());
        }

        private static ArrayValue arrayValueOf(List<?> value, SqlType.Array<?> arrayType) {
            ArrayValue.Builder valueBuilder = ArrayValue.newBuilder();
            block10: for (Object element : value) {
                if (element == null) {
                    valueBuilder.addValues(Value.getDefaultInstance());
                    continue;
                }
                switch (arrayType.getElementType().getCode()) {
                    case BYTES: {
                        ByteString bytesElem = (ByteString)element;
                        valueBuilder.addValues(Value.newBuilder().setBytesValue(bytesElem).build());
                        continue block10;
                    }
                    case STRING: {
                        String stringElem = (String)element;
                        valueBuilder.addValues(Value.newBuilder().setStringValue(stringElem).build());
                        continue block10;
                    }
                    case INT64: {
                        Long longElem = (Long)element;
                        valueBuilder.addValues(Value.newBuilder().setIntValue(longElem.longValue()).build());
                        continue block10;
                    }
                    case FLOAT32: {
                        Float floatElem = (Float)element;
                        valueBuilder.addValues(Value.newBuilder().setFloatValue((double)floatElem.floatValue()).build());
                        continue block10;
                    }
                    case FLOAT64: {
                        Double doubleElem = (Double)element;
                        valueBuilder.addValues(Value.newBuilder().setFloatValue(doubleElem.doubleValue()).build());
                        continue block10;
                    }
                    case BOOL: {
                        Boolean boolElem = (Boolean)element;
                        valueBuilder.addValues(Value.newBuilder().setBoolValue(boolElem.booleanValue()).build());
                        continue block10;
                    }
                    case TIMESTAMP: {
                        Instant timestampElem = (Instant)element;
                        valueBuilder.addValues(Value.newBuilder().setTimestampValue(Builder.toTimestamp(timestampElem)).build());
                        continue block10;
                    }
                    case DATE: {
                        Date dateElem = (Date)element;
                        valueBuilder.addValues(Value.newBuilder().setDateValue(Builder.toProtoDate(dateElem)).build());
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("Unsupported query parameter Array element type: " + arrayType.getElementType());
            }
            return valueBuilder.build();
        }

        private static Timestamp toTimestamp(Instant instant) {
            return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
        }

        private static com.google.type.Date toProtoDate(Date date) {
            return com.google.type.Date.newBuilder().setYear(date.getYear()).setMonth(date.getMonth()).setDay(date.getDayOfMonth()).build();
        }

        private static Value.Builder nullValueWithType(Type type) {
            return Value.newBuilder().setType(type);
        }
    }
}

