/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.threeten.bp.Duration;

public final class Table {
    private final String id;
    private final String instanceId;
    private final Map<String, ReplicationState> replicationStatesByClusterId;
    private final List<ColumnFamily> columnFamilies;
    private final Duration changeStreamRetention;

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public static Table fromProto(@Nonnull com.google.bigtable.admin.v2.Table proto) {
        void var3_7;
        ImmutableMap.Builder replicationStates = ImmutableMap.builder();
        for (Map.Entry entry : proto.getClusterStatesMap().entrySet()) {
            replicationStates.put((Object)((String)entry.getKey()), (Object)ReplicationState.fromProto(((Table.ClusterState)entry.getValue()).getReplicationState()));
        }
        ImmutableList.Builder columnFamilies = ImmutableList.builder();
        for (Map.Entry entry : proto.getColumnFamiliesMap().entrySet()) {
            columnFamilies.add((Object)ColumnFamily.fromProto((String)entry.getKey(), (com.google.bigtable.admin.v2.ColumnFamily)entry.getValue()));
        }
        Object var3_5 = null;
        if (proto.hasChangeStreamConfig()) {
            Duration duration = Duration.ofSeconds((long)proto.getChangeStreamConfig().getRetentionPeriod().getSeconds(), (long)proto.getChangeStreamConfig().getRetentionPeriod().getNanos());
        }
        return new Table(TableName.parse((String)proto.getName()), (Map<String, ReplicationState>)replicationStates.build(), (List<ColumnFamily>)columnFamilies.build(), (Duration)var3_7);
    }

    private Table(TableName tableName, Map<String, ReplicationState> replicationStatesByClusterId, List<ColumnFamily> columnFamilies, Duration changeStreamRetention) {
        this.instanceId = tableName.getInstance();
        this.id = tableName.getTable();
        this.replicationStatesByClusterId = replicationStatesByClusterId;
        this.columnFamilies = columnFamilies;
        this.changeStreamRetention = changeStreamRetention;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Map<String, ReplicationState> getReplicationStatesByClusterId() {
        return this.replicationStatesByClusterId;
    }

    public List<ColumnFamily> getColumnFamilies() {
        return this.columnFamilies;
    }

    public Duration getChangeStreamRetention() {
        return this.changeStreamRetention;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equal((Object)this.id, (Object)table.id) && Objects.equal((Object)this.instanceId, (Object)table.instanceId) && Objects.equal(this.replicationStatesByClusterId, table.replicationStatesByClusterId) && Objects.equal(this.columnFamilies, table.columnFamilies) && Objects.equal((Object)this.changeStreamRetention, (Object)table.changeStreamRetention);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.instanceId, this.replicationStatesByClusterId, this.columnFamilies, this.changeStreamRetention});
    }

    public static enum ReplicationState {
        NOT_KNOWN(Table.ClusterState.ReplicationState.STATE_NOT_KNOWN),
        INITIALIZING(Table.ClusterState.ReplicationState.INITIALIZING),
        PLANNED_MAINTENANCE(Table.ClusterState.ReplicationState.PLANNED_MAINTENANCE),
        UNPLANNED_MAINTENANCE(Table.ClusterState.ReplicationState.UNPLANNED_MAINTENANCE),
        READY(Table.ClusterState.ReplicationState.READY),
        READY_OPTIMIZING(Table.ClusterState.ReplicationState.READY_OPTIMIZING),
        UNRECOGNIZED(Table.ClusterState.ReplicationState.UNRECOGNIZED);

        private final Table.ClusterState.ReplicationState proto;

        @InternalApi
        public static ReplicationState fromProto(Table.ClusterState.ReplicationState proto) {
            Preconditions.checkNotNull((Object)proto);
            for (ReplicationState state : ReplicationState.values()) {
                if (!state.proto.equals((Object)proto)) continue;
                return state;
            }
            return UNRECOGNIZED;
        }

        private ReplicationState(Table.ClusterState.ReplicationState proto) {
            this.proto = proto;
        }

        @InternalApi
        public Table.ClusterState.ReplicationState toProto() {
            return this.proto;
        }
    }
}

