/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopRowException;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.IRowDistribution;
import org.apache.hop.pipeline.transform.RowDistributionPluginType;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.pipeline.dialog.PipelineHopDialog;

public class HopGuiPipelineHopDelegate {
    private static final Class<?> PKG = HopGui.class;
    private HopGui hopGui;
    private HopGuiPipelineGraph pipelineGraph;
    private PropsUi props;

    public HopGuiPipelineHopDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
        this.props = PropsUi.getInstance();
    }

    public void newHop(PipelineMeta pipelineMeta, TransformMeta fr, TransformMeta to) {
        PipelineHopMeta hi = new PipelineHopMeta(fr, to);
        PipelineHopDialog hd = new PipelineHopDialog(this.hopGui.getActiveShell(), 0, hi, pipelineMeta);
        if (hd.open() != null) {
            this.newHop(pipelineMeta, hi);
        }
    }

    public void newHop(PipelineMeta pipelineMeta, PipelineHopMeta pipelineHopMeta) {
        if (this.checkIfHopAlreadyExists(pipelineMeta, pipelineHopMeta)) {
            pipelineMeta.addPipelineHop(pipelineHopMeta);
            int idx = pipelineMeta.indexOfPipelineHop(pipelineHopMeta);
            if (!this.performNewPipelineHopChecks(pipelineMeta, pipelineHopMeta)) {
                pipelineMeta.removePipelineHop(idx);
            } else {
                this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, new PipelineHopMeta[]{pipelineHopMeta}, new int[]{pipelineMeta.indexOfPipelineHop(pipelineHopMeta)});
            }
            this.pipelineGraph.redraw();
        }
    }

    public boolean checkIfHopAlreadyExists(PipelineMeta pipelineMeta, PipelineHopMeta newHop) {
        boolean ok = true;
        if (pipelineMeta.findPipelineHop(newHop.getFromTransform(), newHop.getToTransform()) != null) {
            MessageBox mb = new MessageBox(this.hopGui.getActiveShell(), 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"HopGui.Dialog.HopExists.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"HopGui.Dialog.HopExists.Title", (String[])new String[0]));
            mb.open();
            ok = false;
        }
        return ok;
    }

    public boolean performNewPipelineHopChecks(PipelineMeta pipelineMeta, PipelineHopMeta newHop) {
        boolean ok = true;
        if (pipelineMeta.hasLoop(newHop.getToTransform())) {
            MessageBox mb = new MessageBox(this.hopGui.getActiveShell(), 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopCausesLoop.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopCausesLoop.Title", (String[])new String[0]));
            mb.open();
            ok = false;
        }
        if (ok) {
            try {
                if (!newHop.getToTransform().getTransform().excludeFromRowLayoutVerification()) {
                    pipelineMeta.checkRowMixingStatically(this.pipelineGraph.getVariables(), newHop.getToTransform(), null);
                }
            }
            catch (HopRowException re) {
                new ErrorDialog(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopCausesRowMixing.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Dialog.HopCausesRowMixing.Message", (String[])new String[0]), (Exception)((Object)re));
            }
            if (!newHop.isErrorHop()) {
                this.verifyCopyDistribute(pipelineMeta, newHop.getFromTransform());
            }
        }
        return ok;
    }

    public void verifyCopyDistribute(PipelineMeta pipelineMeta, TransformMeta transformMeta) {
        List hops = pipelineMeta.findAllPipelineHopFrom(transformMeta);
        int hopCount = 0;
        for (PipelineHopMeta hop : hops) {
            if (!hop.isEnabled() || hop.isErrorHop()) continue;
            ++hopCount;
        }
        if (hopCount == 2) {
            boolean distributes = transformMeta.getTransform().excludeFromCopyDistributeVerification();
            boolean customDistribution = false;
            if (this.props.showCopyOrDistributeWarning() && !transformMeta.getTransform().excludeFromCopyDistributeVerification()) {
                MessageDialogWithToggle md = new MessageDialogWithToggle(this.hopGui.getActiveShell(), BaseMessages.getString(PKG, (String)"System.Warning", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.CopyOrDistribute.Message", (String[])new String[]{transformMeta.getName(), Integer.toString(hopCount)}), 8, this.getRowDistributionLabels(), BaseMessages.getString(PKG, (String)"HopGui.Message.Warning.NotShowWarning", (String[])new String[0]), !this.props.showCopyOrDistributeWarning());
                int idx = md.open();
                this.props.setShowCopyOrDistributeWarning(!md.getToggleState());
                boolean bl = distributes = idx == 0;
            }
            if (distributes) {
                transformMeta.setDistributes(true);
                transformMeta.setRowDistribution(null);
            } else if (customDistribution) {
                IRowDistribution rowDistribution = this.pipelineGraph.askUserForCustomDistributionMethod();
                transformMeta.setDistributes(true);
                transformMeta.setRowDistribution(rowDistribution);
            } else {
                transformMeta.setDistributes(false);
            }
            this.pipelineGraph.redraw();
        }
    }

    private String[] getRowDistributionLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(BaseMessages.getString(PKG, (String)"HopGui.Dialog.CopyOrDistribute.Distribute", (String[])new String[0]));
        labels.add(BaseMessages.getString(PKG, (String)"HopGui.Dialog.CopyOrDistribute.Copy", (String[])new String[0]));
        if (!PluginRegistry.getInstance().getPlugins(RowDistributionPluginType.class).isEmpty()) {
            labels.add(BaseMessages.getString(PKG, (String)"HopGui.Dialog.CopyOrDistribute.CustomRowDistribution", (String[])new String[0]));
        }
        return labels.toArray(new String[labels.size()]);
    }

    public void delHop(PipelineMeta pipelineMeta, PipelineHopMeta pipelineHopMeta) {
        TransformErrorMeta transformErrorMeta;
        int index = pipelineMeta.indexOfPipelineHop(pipelineHopMeta);
        this.hopGui.undoDelegate.addUndoDelete((IUndo)pipelineMeta, new Object[]{pipelineHopMeta.clone()}, new int[]{index});
        pipelineMeta.removePipelineHop(index);
        TransformMeta fromTransformMeta = pipelineHopMeta.getFromTransform();
        TransformMeta beforeFrom = (TransformMeta)fromTransformMeta.clone();
        int indexFrom = pipelineMeta.indexOfTransform(fromTransformMeta);
        TransformMeta toTransformMeta = pipelineHopMeta.getToTransform();
        TransformMeta beforeTo = (TransformMeta)toTransformMeta.clone();
        int indexTo = pipelineMeta.indexOfTransform(toTransformMeta);
        if (toTransformMeta.getTransform() != null) {
            toTransformMeta.getTransform().searchInfoAndTargetTransforms(pipelineMeta.getTransforms());
        }
        boolean transformFromNeedAddUndoChange = fromTransformMeta.getTransform().cleanAfterHopFromRemove(pipelineHopMeta.getToTransform());
        boolean transformToNeedAddUndoChange = toTransformMeta.getTransform().cleanAfterHopToRemove(fromTransformMeta);
        if (pipelineHopMeta.getFromTransform().isDoingErrorHandling() && (transformErrorMeta = fromTransformMeta.getTransformErrorMeta()).getTargetTransform() != null && transformErrorMeta.getTargetTransform().equals((Object)pipelineHopMeta.getToTransform())) {
            transformErrorMeta.setEnabled(false);
            transformFromNeedAddUndoChange = true;
        }
        if (transformFromNeedAddUndoChange) {
            this.hopGui.undoDelegate.addUndoChange((IUndo)pipelineMeta, new Object[]{beforeFrom}, new Object[]{fromTransformMeta}, new int[]{indexFrom});
        }
        if (transformToNeedAddUndoChange) {
            this.hopGui.undoDelegate.addUndoChange((IUndo)pipelineMeta, new Object[]{beforeTo}, new Object[]{toTransformMeta}, new int[]{indexTo});
        }
        this.pipelineGraph.redraw();
    }

    public void editHop(PipelineMeta pipelineMeta, PipelineHopMeta pipelineHopMeta) {
        String name = pipelineHopMeta.toString();
        PipelineHopMeta before = pipelineHopMeta.clone();
        PipelineHopDialog hd = new PipelineHopDialog(this.hopGui.getActiveShell(), 0, pipelineHopMeta, pipelineMeta);
        if (hd.open() != null) {
            PipelineHopMeta after = pipelineHopMeta.clone();
            String newName = pipelineHopMeta.toString();
            if (!name.equalsIgnoreCase(newName)) {
                this.pipelineGraph.redraw();
            }
        }
        this.pipelineGraph.updateGui();
    }
}

